/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.utils;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Verify;
import com.google.common.collect.Maps;
import com.google.common.primitives.UnsignedLong;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.concepts.WritableObjects;

@Beta
public abstract class UnsignedLongBitmap
implements Immutable {
    private static final @NonNull UnsignedLongBitmap EMPTY = new Regular(new long[0], new boolean[0]);

    private UnsignedLongBitmap() {
    }

    public static @NonNull UnsignedLongBitmap of() {
        return EMPTY;
    }

    public static @NonNull UnsignedLongBitmap of(long keyBits, boolean value) {
        return new Singleton(keyBits, value);
    }

    public static @NonNull UnsignedLongBitmap copyOf(Map<UnsignedLong, Boolean> map) {
        int size = map.size();
        switch (size) {
            case 0: {
                return UnsignedLongBitmap.of();
            }
            case 1: {
                Map.Entry<UnsignedLong, Boolean> entry = map.entrySet().iterator().next();
                return UnsignedLongBitmap.of(entry.getKey().longValue(), entry.getValue());
            }
        }
        ArrayList<Map.Entry<UnsignedLong, Boolean>> entries = new ArrayList<Map.Entry<UnsignedLong, Boolean>>(map.entrySet());
        entries.sort(Comparator.comparing(Map.Entry::getKey));
        long[] keys = new long[size];
        boolean[] values = new boolean[size];
        int idx = 0;
        for (Map.Entry<UnsignedLong, Boolean> e : entries) {
            keys[idx] = e.getKey().longValue();
            values[idx] = e.getValue();
            ++idx;
        }
        return new Regular(keys, values);
    }

    public abstract boolean isEmpty();

    public abstract int size();

    public final @NonNull HashMap<UnsignedLong, Boolean> mutableCopy() {
        int size = this.size();
        switch (size) {
            case 0: {
                return new HashMap<UnsignedLong, Boolean>();
            }
        }
        HashMap ret = Maps.newHashMapWithExpectedSize((int)size);
        this.putEntries(ret);
        return ret;
    }

    public static @NonNull UnsignedLongBitmap readFrom(@NonNull DataInput in, int size) throws IOException {
        switch (size) {
            case 0: {
                return UnsignedLongBitmap.of();
            }
            case 1: {
                return new Singleton(WritableObjects.readLong((DataInput)in), in.readBoolean());
            }
        }
        long[] keys = new long[size];
        boolean[] values = new boolean[size];
        for (int i = 0; i < size; ++i) {
            keys[i] = WritableObjects.readLong((DataInput)in);
            values[i] = in.readBoolean();
        }
        long prevKey = keys[0];
        for (int i = 1; i < size; ++i) {
            long key = keys[i];
            if (Long.compareUnsigned(prevKey, key) >= 0) {
                throw new IOException("Key " + Long.toUnsignedString(key) + " may not be used after key " + Long.toUnsignedString(prevKey));
            }
            prevKey = key;
        }
        return new Regular(keys, values);
    }

    public void writeEntriesTo(@NonNull DataOutput out, int size) throws IOException {
        if (size != this.size()) {
            throw new IOException("Mismatched size: expected " + this.size() + ", got " + size);
        }
        this.writeEntriesTo(out);
    }

    abstract void writeEntriesTo(@NonNull DataOutput var1) throws IOException;

    abstract StringBuilder appendEntries(StringBuilder var1);

    abstract void putEntries(HashMap<UnsignedLong, Boolean> var1);

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    public final String toString() {
        return this.isEmpty() ? "{}" : this.appendEntries(new StringBuilder().append('{')).append('}').toString();
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="https://github.com/spotbugs/spotbugs/issues/811")
    private static StringBuilder appendEntry(StringBuilder sb, long key, boolean value) {
        return sb.append(Long.toUnsignedString(key)).append('=').append(value);
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="https://github.com/spotbugs/spotbugs/issues/811")
    private static void writeEntry(@NonNull DataOutput out, long key, boolean value) throws IOException {
        WritableObjects.writeLong((DataOutput)out, (long)key);
        out.writeBoolean(value);
    }

    private static final class Singleton
    extends UnsignedLongBitmap {
        private final long key;
        private final boolean value;

        Singleton(long key, boolean value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        void writeEntriesTo(DataOutput out) throws IOException {
            UnsignedLongBitmap.writeEntry(out, this.key, this.value);
        }

        @Override
        StringBuilder appendEntries(StringBuilder sb) {
            return sb.append(Long.toUnsignedString(this.key)).append('=').append(this.value);
        }

        @Override
        void putEntries(HashMap<UnsignedLong, Boolean> ret) {
            ret.put(UnsignedLong.fromLongBits((long)this.key), this.value);
        }

        @Override
        public int hashCode() {
            return Long.hashCode(this.key) ^ Boolean.hashCode(this.value);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Singleton)) {
                return false;
            }
            Singleton other = (Singleton)obj;
            return this.key == other.key && this.value == other.value;
        }
    }

    @VisibleForTesting
    static final class Regular
    extends UnsignedLongBitmap {
        private final long[] keys;
        private final boolean[] values;

        Regular(long[] keys, boolean[] values) {
            this.keys = Objects.requireNonNull(keys);
            this.values = Objects.requireNonNull(values);
            Verify.verify((keys.length == values.length ? 1 : 0) != 0);
        }

        @Override
        public boolean isEmpty() {
            return this.keys.length == 0;
        }

        @Override
        public int size() {
            return this.keys.length;
        }

        @Override
        void writeEntriesTo(DataOutput out) throws IOException {
            for (int i = 0; i < this.keys.length; ++i) {
                UnsignedLongBitmap.writeEntry(out, this.keys[i], this.values[i]);
            }
        }

        @Override
        StringBuilder appendEntries(StringBuilder sb) {
            int last = this.keys.length - 1;
            for (int i = 0; i < last; ++i) {
                UnsignedLongBitmap.appendEntry(sb, this.keys[i], this.values[i]).append(", ");
            }
            return UnsignedLongBitmap.appendEntry(sb, this.keys[last], this.values[last]);
        }

        @Override
        void putEntries(HashMap<UnsignedLong, Boolean> ret) {
            for (int i = 0; i < this.keys.length; ++i) {
                ret.put(UnsignedLong.fromLongBits((long)this.keys[i]), this.values[i]);
            }
        }

        @Override
        public int hashCode() {
            return Arrays.hashCode(this.keys) ^ Arrays.hashCode(this.values);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Regular)) {
                return false;
            }
            Regular other = (Regular)obj;
            return Arrays.equals(this.keys, other.keys) && Arrays.equals(this.values, other.values);
        }
    }
}

