/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.sharding;

import akka.actor.ActorRef;
import akka.actor.ActorSelection;
import akka.actor.ActorSystem;
import akka.actor.PoisonPill;
import akka.actor.Props;
import akka.actor.Status;
import akka.cluster.ClusterEvent;
import akka.cluster.Member;
import akka.dispatch.OnComplete;
import akka.pattern.Patterns;
import akka.util.Timeout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.opendaylight.controller.cluster.access.concepts.MemberName;
import org.opendaylight.controller.cluster.common.actor.AbstractUntypedPersistentActor;
import org.opendaylight.controller.cluster.datastore.ClusterWrapper;
import org.opendaylight.controller.cluster.datastore.DistributedDataStoreInterface;
import org.opendaylight.controller.cluster.datastore.config.PrefixShardConfiguration;
import org.opendaylight.controller.cluster.datastore.utils.ActorUtils;
import org.opendaylight.controller.cluster.datastore.utils.ClusterUtils;
import org.opendaylight.controller.cluster.raft.client.messages.FindLeader;
import org.opendaylight.controller.cluster.raft.client.messages.FindLeaderReply;
import org.opendaylight.controller.cluster.sharding.DistributedShardFrontend;
import org.opendaylight.controller.cluster.sharding.DistributedShardedDOMDataTree;
import org.opendaylight.controller.cluster.sharding.LookupTask;
import org.opendaylight.controller.cluster.sharding.ShardingServiceAddressResolver;
import org.opendaylight.controller.cluster.sharding.messages.LookupPrefixShard;
import org.opendaylight.controller.cluster.sharding.messages.NotifyProducerCreated;
import org.opendaylight.controller.cluster.sharding.messages.NotifyProducerRemoved;
import org.opendaylight.controller.cluster.sharding.messages.PrefixShardCreated;
import org.opendaylight.controller.cluster.sharding.messages.PrefixShardRemovalLookup;
import org.opendaylight.controller.cluster.sharding.messages.PrefixShardRemoved;
import org.opendaylight.controller.cluster.sharding.messages.ProducerCreated;
import org.opendaylight.controller.cluster.sharding.messages.ProducerRemoved;
import org.opendaylight.controller.cluster.sharding.messages.StartConfigShardLookup;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.mdsal.dom.api.DOMDataTreeProducer;
import org.opendaylight.mdsal.dom.api.DOMDataTreeProducerException;
import org.opendaylight.mdsal.dom.api.DOMDataTreeShard;
import org.opendaylight.mdsal.dom.broker.DOMDataTreeShardRegistration;
import org.opendaylight.mdsal.dom.spi.DOMDataTreePrefixTableEntry;
import org.opendaylight.yangtools.concepts.AbstractObjectRegistration;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.compat.java8.FutureConverters;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.FiniteDuration;

@Deprecated(forRemoval=true)
public class ShardedDataTreeActor
extends AbstractUntypedPersistentActor {
    private static final Logger LOG = LoggerFactory.getLogger(ShardedDataTreeActor.class);
    private static final String PERSISTENCE_ID = "sharding-service-actor";
    private static final Timeout DEFAULT_ASK_TIMEOUT = new Timeout(15L, TimeUnit.SECONDS);
    static final FiniteDuration SHARD_LOOKUP_TASK_INTERVAL = new FiniteDuration(1L, TimeUnit.SECONDS);
    private final DistributedShardedDOMDataTree shardingService;
    private final ActorSystem actorSystem;
    private final ClusterWrapper clusterWrapper;
    private final ActorUtils actorUtils;
    private final ShardingServiceAddressResolver resolver;
    private final DistributedDataStoreInterface distributedConfigDatastore;
    private final DistributedDataStoreInterface distributedOperDatastore;
    private final int lookupTaskMaxRetries;
    private final Map<DOMDataTreeIdentifier, ActorProducerRegistration> idToProducer = new HashMap<DOMDataTreeIdentifier, ActorProducerRegistration>();

    ShardedDataTreeActor(ShardedDataTreeActorCreator builder) {
        LOG.debug("Creating ShardedDataTreeActor on {}", (Object)builder.getClusterWrapper().getCurrentMemberName());
        this.shardingService = builder.getShardingService();
        this.actorSystem = builder.getActorSystem();
        this.clusterWrapper = builder.getClusterWrapper();
        this.distributedConfigDatastore = builder.getDistributedConfigDatastore();
        this.distributedOperDatastore = builder.getDistributedOperDatastore();
        this.lookupTaskMaxRetries = builder.getLookupTaskMaxRetries();
        this.actorUtils = this.distributedConfigDatastore.getActorUtils();
        this.resolver = new ShardingServiceAddressResolver("ShardedDOMDataTreeFrontend", this.clusterWrapper.getCurrentMemberName());
        this.clusterWrapper.subscribeToMemberEvents(this.self());
    }

    public void preStart() {
    }

    protected void handleRecover(Object message) {
        LOG.debug("Received a recover message {}", message);
    }

    protected void handleCommand(Object message) {
        LOG.debug("{} : Received {}", (Object)this.clusterWrapper.getCurrentMemberName(), message);
        if (message instanceof ClusterEvent.MemberUp) {
            this.memberUp((ClusterEvent.MemberUp)message);
        } else if (message instanceof ClusterEvent.MemberWeaklyUp) {
            this.memberWeaklyUp((ClusterEvent.MemberWeaklyUp)message);
        } else if (message instanceof ClusterEvent.MemberExited) {
            this.memberExited((ClusterEvent.MemberExited)message);
        } else if (message instanceof ClusterEvent.MemberRemoved) {
            this.memberRemoved((ClusterEvent.MemberRemoved)message);
        } else if (message instanceof ClusterEvent.UnreachableMember) {
            this.memberUnreachable((ClusterEvent.UnreachableMember)message);
        } else if (message instanceof ClusterEvent.ReachableMember) {
            this.memberReachable((ClusterEvent.ReachableMember)message);
        } else if (message instanceof ProducerCreated) {
            this.onProducerCreated((ProducerCreated)message);
        } else if (message instanceof NotifyProducerCreated) {
            this.onNotifyProducerCreated((NotifyProducerCreated)message);
        } else if (message instanceof ProducerRemoved) {
            this.onProducerRemoved((ProducerRemoved)message);
        } else if (message instanceof NotifyProducerRemoved) {
            this.onNotifyProducerRemoved((NotifyProducerRemoved)message);
        } else if (message instanceof PrefixShardCreated) {
            this.onPrefixShardCreated((PrefixShardCreated)message);
        } else if (message instanceof LookupPrefixShard) {
            this.onLookupPrefixShard((LookupPrefixShard)message);
        } else if (message instanceof PrefixShardRemovalLookup) {
            this.onPrefixShardRemovalLookup((PrefixShardRemovalLookup)message);
        } else if (message instanceof PrefixShardRemoved) {
            this.onPrefixShardRemoved((PrefixShardRemoved)message);
        } else if (message instanceof StartConfigShardLookup) {
            this.onStartConfigShardLookup((StartConfigShardLookup)message);
        }
    }

    public String persistenceId() {
        return PERSISTENCE_ID;
    }

    private void memberUp(ClusterEvent.MemberUp message) {
        MemberName memberName = ShardedDataTreeActor.memberToName(message.member());
        LOG.info("{}: Received MemberUp: memberName: {}, address: {}", new Object[]{this.persistenceId(), memberName, message.member().address()});
        this.resolver.addPeerAddress(memberName, message.member().address());
    }

    private void memberWeaklyUp(ClusterEvent.MemberWeaklyUp message) {
        MemberName memberName = ShardedDataTreeActor.memberToName(message.member());
        LOG.info("{}: Received MemberWeaklyUp: memberName: {}, address: {}", new Object[]{this.persistenceId(), memberName, message.member().address()});
        this.resolver.addPeerAddress(memberName, message.member().address());
    }

    private void memberExited(ClusterEvent.MemberExited message) {
        MemberName memberName = ShardedDataTreeActor.memberToName(message.member());
        LOG.info("{}: Received MemberExited: memberName: {}, address: {}", new Object[]{this.persistenceId(), memberName, message.member().address()});
        this.resolver.removePeerAddress(memberName);
    }

    private void memberRemoved(ClusterEvent.MemberRemoved message) {
        MemberName memberName = ShardedDataTreeActor.memberToName(message.member());
        LOG.info("{}: Received MemberRemoved: memberName: {}, address: {}", new Object[]{this.persistenceId(), memberName, message.member().address()});
        this.resolver.removePeerAddress(memberName);
    }

    private void memberUnreachable(ClusterEvent.UnreachableMember message) {
        MemberName memberName = ShardedDataTreeActor.memberToName(message.member());
        LOG.debug("Received UnreachableMember: memberName {}, address: {}", (Object)memberName, (Object)message.member().address());
        this.resolver.removePeerAddress(memberName);
    }

    private void memberReachable(ClusterEvent.ReachableMember message) {
        MemberName memberName = ShardedDataTreeActor.memberToName(message.member());
        LOG.debug("Received ReachableMember: memberName {}, address: {}", (Object)memberName, (Object)message.member().address());
        this.resolver.addPeerAddress(memberName, message.member().address());
    }

    private void onProducerCreated(ProducerCreated message) {
        LOG.debug("Received ProducerCreated: {}", (Object)message);
        if (this.resolver.getShardingServicePeerActorAddresses().isEmpty()) {
            this.getSender().tell((Object)new Status.Success(null), ActorRef.noSender());
        }
        ActorRef sender = this.getSender();
        Collection<DOMDataTreeIdentifier> subtrees = message.getSubtrees();
        ArrayList futures = new ArrayList();
        for (String address : this.resolver.getShardingServicePeerActorAddresses()) {
            ActorSelection actorSelection = this.actorSystem.actorSelection(address);
            futures.add(FutureConverters.toJava(this.actorUtils.executeOperationAsync(actorSelection, (Object)new NotifyProducerCreated(subtrees), DEFAULT_ASK_TIMEOUT)).toCompletableFuture());
        }
        CompletableFuture<Void> combinedFuture = CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()]));
        ((CompletableFuture)combinedFuture.thenRun(() -> sender.tell((Object)new Status.Success(null), ActorRef.noSender()))).exceptionally(throwable -> {
            sender.tell((Object)new Status.Failure(throwable), this.self());
            return null;
        });
    }

    private void onNotifyProducerCreated(NotifyProducerCreated message) {
        LOG.debug("Received NotifyProducerCreated: {}", (Object)message);
        Collection<DOMDataTreeIdentifier> subtrees = message.getSubtrees();
        try {
            ActorProducerRegistration registration = new ActorProducerRegistration(this.shardingService.localCreateProducer(subtrees), subtrees);
            subtrees.forEach(id -> this.idToProducer.put((DOMDataTreeIdentifier)id, registration));
            this.sender().tell((Object)new Status.Success(null), this.self());
        }
        catch (IllegalArgumentException e) {
            this.sender().tell((Object)new Status.Failure((Throwable)e), this.getSelf());
        }
    }

    private void onProducerRemoved(ProducerRemoved message) {
        LOG.debug("Received ProducerRemoved: {}", (Object)message);
        ArrayList futures = new ArrayList();
        for (String address : this.resolver.getShardingServicePeerActorAddresses()) {
            ActorSelection selection = this.actorSystem.actorSelection(address);
            futures.add(FutureConverters.toJava(this.actorUtils.executeOperationAsync(selection, new NotifyProducerRemoved(message.getSubtrees()))).toCompletableFuture());
        }
        CompletableFuture<Void> combinedFuture = CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()]));
        ActorRef respondTo = this.getSender();
        ((CompletableFuture)combinedFuture.thenRun(() -> respondTo.tell((Object)new Status.Success(null), this.self()))).exceptionally(e -> {
            respondTo.tell((Object)new Status.Failure(null), this.self());
            return null;
        });
    }

    private void onNotifyProducerRemoved(NotifyProducerRemoved message) {
        LOG.debug("Received NotifyProducerRemoved: {}", (Object)message);
        ActorProducerRegistration registration = this.idToProducer.remove(message.getSubtrees().iterator().next());
        if (registration == null) {
            LOG.warn("The notification contained a path on which no producer is registered, throwing away");
            this.getSender().tell((Object)new Status.Success(null), ActorRef.noSender());
            return;
        }
        try {
            registration.close();
            this.getSender().tell((Object)new Status.Success(null), ActorRef.noSender());
        }
        catch (DOMDataTreeProducerException e) {
            LOG.error("Unable to close producer", (Throwable)e);
            this.getSender().tell((Object)new Status.Failure((Throwable)e), ActorRef.noSender());
        }
    }

    private void onLookupPrefixShard(LookupPrefixShard message) {
        LOG.debug("Member: {}, Received LookupPrefixShard: {}", (Object)this.clusterWrapper.getCurrentMemberName(), (Object)message);
        DOMDataTreeIdentifier prefix = message.getPrefix();
        ActorUtils utils = prefix.getDatastoreType() == LogicalDatastoreType.CONFIGURATION ? this.distributedConfigDatastore.getActorUtils() : this.distributedOperDatastore.getActorUtils();
        this.actorSystem.scheduler().scheduleOnce(SHARD_LOOKUP_TASK_INTERVAL, (Runnable)new ShardCreationLookupTask(this.actorSystem, this.getSender(), this.clusterWrapper, utils, this.shardingService, prefix, this.lookupTaskMaxRetries), (ExecutionContext)this.actorSystem.dispatcher());
    }

    private void onPrefixShardCreated(PrefixShardCreated message) {
        LOG.debug("Member: {}, Received PrefixShardCreated: {}", (Object)this.clusterWrapper.getCurrentMemberName(), (Object)message);
        PrefixShardConfiguration config = message.getConfiguration();
        this.shardingService.resolveShardAdditions(Collections.singleton(config.getPrefix()));
    }

    private void onPrefixShardRemovalLookup(PrefixShardRemovalLookup message) {
        LOG.debug("Member: {}, Received PrefixShardRemovalLookup: {}", (Object)this.clusterWrapper.getCurrentMemberName(), (Object)message);
        ShardRemovalLookupTask removalTask = new ShardRemovalLookupTask(this.actorSystem, this.getSender(), this.actorUtils, message.getPrefix(), this.lookupTaskMaxRetries);
        this.actorSystem.scheduler().scheduleOnce(SHARD_LOOKUP_TASK_INTERVAL, (Runnable)removalTask, (ExecutionContext)this.actorSystem.dispatcher());
    }

    private void onPrefixShardRemoved(PrefixShardRemoved message) {
        LOG.debug("Received PrefixShardRemoved: {}", (Object)message);
        this.shardingService.resolveShardRemovals(Collections.singleton(message.getPrefix()));
    }

    private void onStartConfigShardLookup(StartConfigShardLookup message) {
        LOG.debug("Received StartConfigShardLookup: {}", (Object)message);
        ActorUtils context = message.getType().equals((Object)LogicalDatastoreType.CONFIGURATION) ? this.distributedConfigDatastore.getActorUtils() : this.distributedOperDatastore.getActorUtils();
        this.actorSystem.scheduler().scheduleOnce(SHARD_LOOKUP_TASK_INTERVAL, (Runnable)new ConfigShardLookupTask(this.actorSystem, this.getSender(), context, message, this.lookupTaskMaxRetries), (ExecutionContext)this.actorSystem.dispatcher());
    }

    private static MemberName memberToName(Member member) {
        return MemberName.forName((String)((String)member.roles().iterator().next()));
    }

    public static class ShardedDataTreeActorCreator {
        private DistributedShardedDOMDataTree shardingService;
        private DistributedDataStoreInterface distributedConfigDatastore;
        private DistributedDataStoreInterface distributedOperDatastore;
        private ActorSystem actorSystem;
        private ClusterWrapper cluster;
        private int maxRetries;

        public DistributedShardedDOMDataTree getShardingService() {
            return this.shardingService;
        }

        public ShardedDataTreeActorCreator setShardingService(DistributedShardedDOMDataTree shardingService) {
            this.shardingService = shardingService;
            return this;
        }

        public ActorSystem getActorSystem() {
            return this.actorSystem;
        }

        public ShardedDataTreeActorCreator setActorSystem(ActorSystem actorSystem) {
            this.actorSystem = actorSystem;
            return this;
        }

        public ShardedDataTreeActorCreator setClusterWrapper(ClusterWrapper clusterWrapper) {
            this.cluster = clusterWrapper;
            return this;
        }

        public ClusterWrapper getClusterWrapper() {
            return this.cluster;
        }

        public DistributedDataStoreInterface getDistributedConfigDatastore() {
            return this.distributedConfigDatastore;
        }

        public ShardedDataTreeActorCreator setDistributedConfigDatastore(DistributedDataStoreInterface distributedConfigDatastore) {
            this.distributedConfigDatastore = distributedConfigDatastore;
            return this;
        }

        public DistributedDataStoreInterface getDistributedOperDatastore() {
            return this.distributedOperDatastore;
        }

        public ShardedDataTreeActorCreator setDistributedOperDatastore(DistributedDataStoreInterface distributedOperDatastore) {
            this.distributedOperDatastore = distributedOperDatastore;
            return this;
        }

        public ShardedDataTreeActorCreator setLookupTaskMaxRetries(int newMaxRetries) {
            this.maxRetries = newMaxRetries;
            return this;
        }

        public int getLookupTaskMaxRetries() {
            return this.maxRetries;
        }

        private void verify() {
            Objects.requireNonNull(this.shardingService);
            Objects.requireNonNull(this.actorSystem);
            Objects.requireNonNull(this.cluster);
            Objects.requireNonNull(this.distributedConfigDatastore);
            Objects.requireNonNull(this.distributedOperDatastore);
        }

        public Props props() {
            this.verify();
            return Props.create(ShardedDataTreeActor.class, (Object[])new Object[]{this});
        }
    }

    private static class ConfigShardReadinessTask
    extends LookupTask {
        private final ActorSystem system;
        private final ActorRef replyTo;
        private final ActorUtils context;
        private final ClusterWrapper clusterWrapper;
        private final ActorRef shard;

        ConfigShardReadinessTask(ActorSystem system, ActorRef replyTo, ActorUtils context, ClusterWrapper clusterWrapper, ActorRef shard, int lookupMaxRetries) {
            super(replyTo, lookupMaxRetries);
            this.system = system;
            this.replyTo = replyTo;
            this.context = context;
            this.clusterWrapper = clusterWrapper;
            this.shard = shard;
        }

        @Override
        void reschedule(int retries) {
            LOG.debug("{} - Leader for config shard not found on try: {}, retrying..", (Object)this.clusterWrapper.getCurrentMemberName(), (Object)retries);
            this.system.scheduler().scheduleOnce(SHARD_LOOKUP_TASK_INTERVAL, (Runnable)this, (ExecutionContext)this.system.dispatcher());
        }

        @Override
        public void run() {
            Future ask = Patterns.ask((ActorRef)this.shard, (Object)FindLeader.INSTANCE, (Timeout)this.context.getOperationTimeout());
            ask.onComplete((Function1)new OnComplete<Object>(){

                public void onComplete(Throwable throwable, Object findLeaderReply) {
                    if (throwable != null) {
                        this.tryReschedule(throwable);
                    } else {
                        FindLeaderReply findLeader = (FindLeaderReply)findLeaderReply;
                        Optional leaderActor = findLeader.getLeaderActor();
                        if (leaderActor.isPresent()) {
                            LOG.debug("{} - Leader for config shard is ready. Ending lookup.", (Object)clusterWrapper.getCurrentMemberName());
                            replyTo.tell((Object)new Status.Success(null), ActorRef.noSender());
                        } else {
                            this.tryReschedule(null);
                        }
                    }
                }
            }, (ExecutionContext)this.system.dispatcher());
        }
    }

    private static class ConfigShardLookupTask
    extends LookupTask {
        private final ActorSystem system;
        private final ActorRef replyTo;
        private final ActorUtils context;

        ConfigShardLookupTask(ActorSystem system, ActorRef replyTo, ActorUtils context, StartConfigShardLookup message, int lookupMaxRetries) {
            super(replyTo, lookupMaxRetries);
            this.system = system;
            this.replyTo = replyTo;
            this.context = context;
        }

        @Override
        void reschedule(int retries) {
            LOG.debug("Local backend for prefix configuration shard not found, try: {}, rescheduling..", (Object)retries);
            this.system.scheduler().scheduleOnce(SHARD_LOOKUP_TASK_INTERVAL, (Runnable)this, (ExecutionContext)this.system.dispatcher());
        }

        @Override
        public void run() {
            Optional<ActorRef> localShard = this.context.findLocalShard("prefix-configuration-shard");
            if (!localShard.isPresent()) {
                this.tryReschedule(null);
            } else {
                LOG.debug("Local backend for prefix configuration shard lookup successful");
                this.replyTo.tell((Object)new Status.Success(null), ActorRef.noSender());
            }
        }
    }

    private static class ShardRemovalLookupTask
    extends LookupTask {
        private final ActorSystem system;
        private final ActorRef replyTo;
        private final ActorUtils context;
        private final DOMDataTreeIdentifier toLookup;

        ShardRemovalLookupTask(ActorSystem system, ActorRef replyTo, ActorUtils context, DOMDataTreeIdentifier toLookup, int lookupMaxRetries) {
            super(replyTo, lookupMaxRetries);
            this.system = system;
            this.replyTo = replyTo;
            this.context = context;
            this.toLookup = toLookup;
        }

        @Override
        public void run() {
            Future<ActorRef> localShardFuture = this.context.findLocalShardAsync(ClusterUtils.getCleanShardName(this.toLookup.getRootIdentifier()));
            localShardFuture.onComplete((Function1)new OnComplete<ActorRef>(){

                public void onComplete(Throwable throwable, ActorRef actorRef) {
                    if (throwable != null) {
                        LOG.debug("Backend shard[{}] removal lookup successful notifying the registration future", (Object)toLookup);
                        replyTo.tell((Object)new Status.Success(null), ActorRef.noSender());
                    } else {
                        this.tryReschedule(null);
                    }
                }
            }, (ExecutionContext)this.system.dispatcher());
        }

        @Override
        void reschedule(int retries) {
            LOG.debug("Backend shard[{}] removal lookup failed, shard is still present, try: {}, rescheduling..", (Object)this.toLookup, (Object)retries);
            this.system.scheduler().scheduleOnce(SHARD_LOOKUP_TASK_INTERVAL, (Runnable)this, (ExecutionContext)this.system.dispatcher());
        }
    }

    private static final class FrontendLookupTask
    extends LookupTask {
        private final ActorSystem system;
        private final ActorRef replyTo;
        private final DistributedShardedDOMDataTree shardingService;
        private final DOMDataTreeIdentifier toLookup;

        FrontendLookupTask(ActorSystem system, ActorRef replyTo, DistributedShardedDOMDataTree shardingService, DOMDataTreeIdentifier toLookup, int lookupMaxRetries) {
            super(replyTo, lookupMaxRetries);
            this.system = system;
            this.replyTo = replyTo;
            this.shardingService = shardingService;
            this.toLookup = toLookup;
        }

        @Override
        public void run() {
            DOMDataTreePrefixTableEntry<DOMDataTreeShardRegistration<DOMDataTreeShard>> entry = this.shardingService.lookupShardFrontend(this.toLookup);
            if (entry != null && this.tableEntryIdCheck(entry, this.toLookup) && entry.getValue() != null) {
                this.replyTo.tell((Object)new Status.Success(null), ActorRef.noSender());
            } else {
                this.tryReschedule(null);
            }
        }

        private boolean tableEntryIdCheck(DOMDataTreePrefixTableEntry<?> entry, DOMDataTreeIdentifier prefix) {
            if (entry == null) {
                return false;
            }
            if (YangInstanceIdentifier.empty().equals((Object)prefix.getRootIdentifier())) {
                return true;
            }
            return entry.getIdentifier().equals(this.toLookup.getRootIdentifier().getLastPathArgument());
        }

        @Override
        void reschedule(int retries) {
            LOG.debug("Frontend for shard[{}] not found on try: {}, retrying..", (Object)this.toLookup, (Object)retries);
            this.system.scheduler().scheduleOnce(SHARD_LOOKUP_TASK_INTERVAL, (Runnable)this, (ExecutionContext)this.system.dispatcher());
        }
    }

    private static class ShardLeaderLookupTask
    extends LookupTask {
        private final ActorSystem system;
        private final ActorRef replyTo;
        private final ActorUtils context;
        private final ClusterWrapper clusterWrapper;
        private final ActorRef shard;
        private final DistributedShardedDOMDataTree shardingService;
        private final DOMDataTreeIdentifier toLookup;
        private final int lookupMaxRetries;

        ShardLeaderLookupTask(ActorSystem system, ActorRef replyTo, ActorUtils context, ClusterWrapper clusterWrapper, ActorRef shard, DistributedShardedDOMDataTree shardingService, DOMDataTreeIdentifier toLookup, int lookupMaxRetries) {
            super(replyTo, lookupMaxRetries);
            this.system = system;
            this.replyTo = replyTo;
            this.context = context;
            this.clusterWrapper = clusterWrapper;
            this.shard = shard;
            this.shardingService = shardingService;
            this.toLookup = toLookup;
            this.lookupMaxRetries = lookupMaxRetries;
        }

        @Override
        public void run() {
            Future ask = Patterns.ask((ActorRef)this.shard, (Object)FindLeader.INSTANCE, (Timeout)this.context.getOperationTimeout());
            ask.onComplete((Function1)new OnComplete<Object>(){

                public void onComplete(Throwable throwable, Object findLeaderReply) {
                    if (throwable != null) {
                        this.tryReschedule(throwable);
                    } else {
                        FindLeaderReply findLeader = (FindLeaderReply)findLeaderReply;
                        Optional leaderActor = findLeader.getLeaderActor();
                        if (leaderActor.isPresent()) {
                            LOG.debug("{} - Leader for shard[{}] backend ready, starting frontend lookup..", (Object)clusterWrapper.getCurrentMemberName(), (Object)toLookup);
                            system.scheduler().scheduleOnce(SHARD_LOOKUP_TASK_INTERVAL, (Runnable)new FrontendLookupTask(system, replyTo, shardingService, toLookup, lookupMaxRetries), (ExecutionContext)system.dispatcher());
                        } else {
                            this.tryReschedule(null);
                        }
                    }
                }
            }, (ExecutionContext)this.system.dispatcher());
        }

        @Override
        void reschedule(int retries) {
            LOG.debug("{} - Leader for shard[{}] backend not found on try: {}, retrying..", new Object[]{this.clusterWrapper.getCurrentMemberName(), this.toLookup, retries});
            this.system.scheduler().scheduleOnce(SHARD_LOOKUP_TASK_INTERVAL, (Runnable)this, (ExecutionContext)this.system.dispatcher());
        }
    }

    private static class ShardCreationLookupTask
    extends LookupTask {
        private final ActorSystem system;
        private final ActorRef replyTo;
        private final ClusterWrapper clusterWrapper;
        private final ActorUtils context;
        private final DistributedShardedDOMDataTree shardingService;
        private final DOMDataTreeIdentifier toLookup;
        private final int lookupMaxRetries;

        ShardCreationLookupTask(ActorSystem system, ActorRef replyTo, ClusterWrapper clusterWrapper, ActorUtils context, DistributedShardedDOMDataTree shardingService, DOMDataTreeIdentifier toLookup, int lookupMaxRetries) {
            super(replyTo, lookupMaxRetries);
            this.system = system;
            this.replyTo = replyTo;
            this.clusterWrapper = clusterWrapper;
            this.context = context;
            this.shardingService = shardingService;
            this.toLookup = toLookup;
            this.lookupMaxRetries = lookupMaxRetries;
        }

        @Override
        public void run() {
            Future<ActorRef> localShardFuture = this.context.findLocalShardAsync(ClusterUtils.getCleanShardName(this.toLookup.getRootIdentifier()));
            localShardFuture.onComplete((Function1)new OnComplete<ActorRef>(){

                public void onComplete(Throwable throwable, ActorRef actorRef) {
                    if (throwable != null) {
                        this.tryReschedule(throwable);
                    } else {
                        LOG.debug("Local backend for shard[{}] lookup successful, starting leader lookup..", (Object)toLookup);
                        system.scheduler().scheduleOnce(SHARD_LOOKUP_TASK_INTERVAL, (Runnable)new ShardLeaderLookupTask(system, replyTo, context, clusterWrapper, actorRef, shardingService, toLookup, lookupMaxRetries), (ExecutionContext)system.dispatcher());
                    }
                }
            }, (ExecutionContext)this.system.dispatcher());
        }

        @Override
        void reschedule(int retries) {
            LOG.debug("Local backend for shard[{}] not found, try: {}, rescheduling..", (Object)this.toLookup, (Object)retries);
            this.system.scheduler().scheduleOnce(SHARD_LOOKUP_TASK_INTERVAL, (Runnable)this, (ExecutionContext)this.system.dispatcher());
        }
    }

    private static class ShardFrontendRegistration
    extends AbstractObjectRegistration<ListenerRegistration<DistributedShardFrontend>> {
        private final ActorRef clientActor;
        private final ListenerRegistration<DistributedShardFrontend> shardRegistration;

        ShardFrontendRegistration(ActorRef clientActor, ListenerRegistration<DistributedShardFrontend> shardRegistration) {
            super(shardRegistration);
            this.clientActor = clientActor;
            this.shardRegistration = shardRegistration;
        }

        protected void removeRegistration() {
            this.shardRegistration.close();
            this.clientActor.tell((Object)PoisonPill.getInstance(), ActorRef.noSender());
        }
    }

    private class ActorProducerRegistration {
        private final DOMDataTreeProducer producer;
        private final Collection<DOMDataTreeIdentifier> subtrees;

        ActorProducerRegistration(DOMDataTreeProducer producer, Collection<DOMDataTreeIdentifier> subtrees) {
            this.producer = producer;
            this.subtrees = subtrees;
        }

        void close() throws DOMDataTreeProducerException {
            this.producer.close();
            this.subtrees.forEach(ShardedDataTreeActor.this.idToProducer::remove);
        }
    }
}

