/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.DataStoreType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.DatastoreShardId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.GetShardRoleInput;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class GetShardRoleInputBuilder
implements Builder<GetShardRoleInput> {
    private DataStoreType _dataStoreType;
    private String _shardName;
    Map<Class<? extends Augmentation<GetShardRoleInput>>, Augmentation<GetShardRoleInput>> augmentation = Collections.emptyMap();

    public GetShardRoleInputBuilder() {
    }

    public GetShardRoleInputBuilder(DatastoreShardId arg) {
        this._shardName = arg.getShardName();
        this._dataStoreType = arg.getDataStoreType();
    }

    public GetShardRoleInputBuilder(GetShardRoleInput base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<GetShardRoleInput>>, Augmentation<GetShardRoleInput>>(aug);
        }
        this._dataStoreType = base.getDataStoreType();
        this._shardName = base.getShardName();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof DatastoreShardId) {
            this._shardName = ((DatastoreShardId)arg).getShardName();
            this._dataStoreType = ((DatastoreShardId)arg).getDataStoreType();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.DatastoreShardId]");
    }

    public DataStoreType getDataStoreType() {
        return this._dataStoreType;
    }

    public String getShardName() {
        return this._shardName;
    }

    public <E$$ extends Augmentation<GetShardRoleInput>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public GetShardRoleInputBuilder setDataStoreType(DataStoreType value) {
        this._dataStoreType = value;
        return this;
    }

    private static void check_shardNameLength(String value) {
        int length = value.codePointCount(0, value.length());
        if (length >= 1) {
            return;
        }
        CodeHelpers.throwInvalidLength((String)"[[1..2147483647]]", (Object)value);
    }

    public GetShardRoleInputBuilder setShardName(String value) {
        if (value != null) {
            GetShardRoleInputBuilder.check_shardNameLength(value);
        }
        this._shardName = value;
        return this;
    }

    public GetShardRoleInputBuilder addAugmentation(Augmentation<GetShardRoleInput> augmentation) {
        Class augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<GetShardRoleInput>>, Augmentation<GetShardRoleInput>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public GetShardRoleInputBuilder removeAugmentation(Class<? extends Augmentation<GetShardRoleInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public GetShardRoleInput build() {
        return new GetShardRoleInputImpl(this);
    }

    private static final class GetShardRoleInputImpl
    extends AbstractAugmentable<GetShardRoleInput>
    implements GetShardRoleInput {
        private final DataStoreType _dataStoreType;
        private final String _shardName;
        private int hash = 0;
        private volatile boolean hashValid = false;

        GetShardRoleInputImpl(GetShardRoleInputBuilder base) {
            super(base.augmentation);
            this._dataStoreType = base.getDataStoreType();
            this._shardName = base.getShardName();
        }

        @Override
        public DataStoreType getDataStoreType() {
            return this._dataStoreType;
        }

        @Override
        public String getShardName() {
            return this._shardName;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = GetShardRoleInput.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return GetShardRoleInput.bindingEquals(this, obj);
        }

        public String toString() {
            return GetShardRoleInput.bindingToString(this);
        }
    }
}

