/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.raft;

import akka.actor.ActorRef;
import akka.actor.ActorSelection;
import akka.actor.Cancellable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.UUID;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.controller.cluster.raft.PeerInfo;
import org.opendaylight.controller.cluster.raft.RaftActor;
import org.opendaylight.controller.cluster.raft.RaftActorContext;
import org.opendaylight.controller.cluster.raft.VotingState;
import org.opendaylight.controller.cluster.raft.base.messages.ApplyState;
import org.opendaylight.controller.cluster.raft.base.messages.SnapshotComplete;
import org.opendaylight.controller.cluster.raft.base.messages.TimeoutNow;
import org.opendaylight.controller.cluster.raft.behaviors.AbstractLeader;
import org.opendaylight.controller.cluster.raft.messages.AddServer;
import org.opendaylight.controller.cluster.raft.messages.AddServerReply;
import org.opendaylight.controller.cluster.raft.messages.ChangeServersVotingStatus;
import org.opendaylight.controller.cluster.raft.messages.RemoveServer;
import org.opendaylight.controller.cluster.raft.messages.RemoveServerReply;
import org.opendaylight.controller.cluster.raft.messages.ServerChangeReply;
import org.opendaylight.controller.cluster.raft.messages.ServerChangeStatus;
import org.opendaylight.controller.cluster.raft.messages.ServerRemoved;
import org.opendaylight.controller.cluster.raft.messages.UnInitializedFollowerSnapshotReply;
import org.opendaylight.controller.cluster.raft.persisted.ServerConfigurationPayload;
import org.opendaylight.controller.cluster.raft.persisted.ServerInfo;
import org.opendaylight.controller.cluster.raft.protobuff.client.messages.Payload;
import org.opendaylight.yangtools.concepts.Identifier;
import org.opendaylight.yangtools.util.AbstractUUIDIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.FiniteDuration;

class RaftActorServerConfigurationSupport {
    private static final Logger LOG = LoggerFactory.getLogger(RaftActorServerConfigurationSupport.class);
    private final OperationState IDLE = new Idle();
    private final RaftActor raftActor;
    private final RaftActorContext raftContext;
    private final Queue<ServerOperationContext<?>> pendingOperationsQueue = new ArrayDeque();
    private OperationState currentOperationState = this.IDLE;

    RaftActorServerConfigurationSupport(RaftActor raftActor) {
        this.raftActor = raftActor;
        this.raftContext = raftActor.getRaftActorContext();
    }

    boolean handleMessage(Object message, ActorRef sender) {
        if (message instanceof AddServer) {
            this.onAddServer((AddServer)message, sender);
            return true;
        }
        if (message instanceof RemoveServer) {
            this.onRemoveServer((RemoveServer)message, sender);
            return true;
        }
        if (message instanceof ChangeServersVotingStatus) {
            this.onChangeServersVotingStatus((ChangeServersVotingStatus)message, sender);
            return true;
        }
        if (message instanceof ServerOperationTimeout) {
            this.currentOperationState.onServerOperationTimeout((ServerOperationTimeout)message);
            return true;
        }
        if (message instanceof UnInitializedFollowerSnapshotReply) {
            this.currentOperationState.onUnInitializedFollowerSnapshotReply((UnInitializedFollowerSnapshotReply)message);
            return true;
        }
        if (message instanceof ApplyState) {
            return this.onApplyState((ApplyState)message);
        }
        if (message instanceof SnapshotComplete) {
            this.currentOperationState.onSnapshotComplete();
            return false;
        }
        return false;
    }

    void onNewLeader(String leaderId) {
        this.currentOperationState.onNewLeader(leaderId);
    }

    private void onChangeServersVotingStatus(ChangeServersVotingStatus message, ActorRef sender) {
        boolean hasNoLeader;
        LOG.debug("{}: onChangeServersVotingStatus: {}, state: {}", new Object[]{this.raftContext.getId(), message, this.currentOperationState});
        boolean localServerChangingToVoting = Boolean.TRUE.equals(message.getServerVotingStatusMap().get(this.raftActor.getRaftActorContext().getId()));
        boolean bl = hasNoLeader = this.raftActor.getLeaderId() == null;
        if (localServerChangingToVoting && !this.raftContext.isVotingMember() && hasNoLeader) {
            this.currentOperationState.onNewOperation(new ChangeServersVotingStatusContext(message, sender, true));
        } else {
            this.onNewOperation(new ChangeServersVotingStatusContext(message, sender, false));
        }
    }

    private void onRemoveServer(RemoveServer removeServer, ActorRef sender) {
        LOG.debug("{}: onRemoveServer: {}, state: {}", new Object[]{this.raftContext.getId(), removeServer, this.currentOperationState});
        boolean isSelf = removeServer.getServerId().equals(this.raftContext.getId());
        if (isSelf && !this.raftContext.hasFollowers()) {
            sender.tell((Object)new RemoveServerReply(ServerChangeStatus.NOT_SUPPORTED, this.raftActor.getLeaderId()), this.raftActor.getSelf());
        } else if (!isSelf && !this.raftContext.getPeerIds().contains(removeServer.getServerId())) {
            sender.tell((Object)new RemoveServerReply(ServerChangeStatus.DOES_NOT_EXIST, this.raftActor.getLeaderId()), this.raftActor.getSelf());
        } else {
            String serverAddress = isSelf ? this.raftActor.self().path().toString() : this.raftContext.getPeerAddress(removeServer.getServerId());
            this.onNewOperation(new RemoveServerContext(removeServer, serverAddress, sender));
        }
    }

    private boolean onApplyState(ApplyState applyState) {
        Payload data = applyState.getReplicatedLogEntry().getData();
        if (data instanceof ServerConfigurationPayload) {
            this.currentOperationState.onApplyState(applyState);
            return true;
        }
        return false;
    }

    private void onAddServer(AddServer addServer, ActorRef sender) {
        LOG.debug("{}: onAddServer: {}, state: {}", new Object[]{this.raftContext.getId(), addServer, this.currentOperationState});
        this.onNewOperation(new AddServerContext(addServer, sender));
    }

    private void onNewOperation(ServerOperationContext<?> operationContext) {
        if (this.raftActor.isLeader()) {
            this.currentOperationState.onNewOperation(operationContext);
        } else {
            ActorSelection leader = this.raftActor.getLeader();
            if (leader != null) {
                LOG.debug("{}: Not leader - forwarding to leader {}", (Object)this.raftContext.getId(), (Object)leader);
                leader.tell(operationContext.getOperation(), operationContext.getClientRequestor());
            } else {
                LOG.debug("{}: No leader - returning NO_LEADER reply", (Object)this.raftContext.getId());
                operationContext.getClientRequestor().tell(operationContext.newReply(ServerChangeStatus.NO_LEADER, null), this.raftActor.self());
            }
        }
    }

    static class ServerOperationTimeout {
        private final String loggingContext;

        ServerOperationTimeout(String loggingContext) {
            this.loggingContext = Objects.requireNonNull(loggingContext, "loggingContext should not be null");
        }

        String getLoggingContext() {
            return this.loggingContext;
        }
    }

    private class WaitingForLeaderElected
    extends OperationState {
        private final ServerConfigurationPayload previousServerConfig;
        private final ChangeServersVotingStatusContext operationContext;
        private final Cancellable timer;

        WaitingForLeaderElected(ChangeServersVotingStatusContext operationContext, ServerConfigurationPayload previousServerConfig) {
            this.operationContext = operationContext;
            this.previousServerConfig = previousServerConfig;
            this.timer = this.newTimer(RaftActorServerConfigurationSupport.this.raftContext.getConfigParams().getElectionTimeOutInterval(), new ServerOperationTimeout(operationContext.getLoggingContext()));
        }

        @Override
        void onNewLeader(String newLeader) {
            if (newLeader == null) {
                return;
            }
            LOG.debug("{}: New leader {} elected", (Object)RaftActorServerConfigurationSupport.this.raftContext.getId(), (Object)newLeader);
            this.timer.cancel();
            if (RaftActorServerConfigurationSupport.this.raftActor.isLeader()) {
                this.persistNewServerConfiguration(this.operationContext);
            } else {
                LOG.debug("{}: Forwarding {} to new leader", (Object)RaftActorServerConfigurationSupport.this.raftContext.getId(), this.operationContext.getOperation());
                RaftActorServerConfigurationSupport.this.raftContext.updatePeerIds(this.previousServerConfig);
                this.changeToIdleState();
                RaftActorServerConfigurationSupport.this.onNewOperation(this.operationContext);
            }
        }

        @Override
        void onServerOperationTimeout(ServerOperationTimeout timeout) {
            LOG.warn("{}: Leader election timed out - cannot apply operation {}", (Object)RaftActorServerConfigurationSupport.this.raftContext.getId(), (Object)timeout.getLoggingContext());
            RaftActorServerConfigurationSupport.this.raftContext.updatePeerIds(this.previousServerConfig);
            RaftActorServerConfigurationSupport.this.raftActor.initializeBehavior();
            this.tryToForwardOperationToAnotherServer();
        }

        private void tryToForwardOperationToAnotherServer() {
            HashSet<String> serversVisited = new HashSet<String>(((ChangeServersVotingStatus)this.operationContext.getOperation()).getServersVisited());
            LOG.debug("{}: tryToForwardOperationToAnotherServer - servers already visited {}", (Object)RaftActorServerConfigurationSupport.this.raftContext.getId(), serversVisited);
            serversVisited.add(RaftActorServerConfigurationSupport.this.raftContext.getId());
            Map<String, Boolean> serverVotingStatusMap = ((ChangeServersVotingStatus)this.operationContext.getOperation()).getServerVotingStatusMap();
            ActorSelection forwardToPeerActor = null;
            for (Map.Entry<String, Boolean> e : serverVotingStatusMap.entrySet()) {
                ActorSelection actor;
                Boolean isVoting = e.getValue();
                String serverId = e.getKey();
                PeerInfo peerInfo = RaftActorServerConfigurationSupport.this.raftContext.getPeerInfo(serverId);
                if (!isVoting.booleanValue() || peerInfo == null || peerInfo.isVoting() || serversVisited.contains(serverId) || (actor = RaftActorServerConfigurationSupport.this.raftContext.getPeerActorSelection(serverId)) == null) continue;
                forwardToPeerActor = actor;
                break;
            }
            if (forwardToPeerActor != null) {
                LOG.debug("{}: Found server {} to forward to", (Object)RaftActorServerConfigurationSupport.this.raftContext.getId(), forwardToPeerActor);
                forwardToPeerActor.tell((Object)new ChangeServersVotingStatus(serverVotingStatusMap, serversVisited), this.operationContext.getClientRequestor());
                this.changeToIdleState();
            } else {
                this.operationComplete(this.operationContext, ServerChangeStatus.NO_LEADER);
            }
        }
    }

    private class ChangeServersVotingStatusState
    extends OperationState
    implements InitialOperationState {
        private final ChangeServersVotingStatusContext changeVotingStatusContext;
        private final boolean tryToElectLeader;

        ChangeServersVotingStatusState(ChangeServersVotingStatusContext changeVotingStatusContext, boolean tryToElectLeader) {
            this.changeVotingStatusContext = changeVotingStatusContext;
            this.tryToElectLeader = tryToElectLeader;
        }

        @Override
        public void initiate() {
            LOG.debug("Initiating ChangeServersVotingStatusState");
            if (this.tryToElectLeader) {
                this.initiateLocalLeaderElection();
            } else if (this.updateLocalPeerInfo()) {
                this.persistNewServerConfiguration(this.changeVotingStatusContext);
            }
        }

        private void initiateLocalLeaderElection() {
            LOG.debug("{}: Sending local ElectionTimeout to start leader election", (Object)RaftActorServerConfigurationSupport.this.raftContext.getId());
            ServerConfigurationPayload previousServerConfig = RaftActorServerConfigurationSupport.this.raftContext.getPeerServerInfo(true);
            if (!this.updateLocalPeerInfo()) {
                return;
            }
            RaftActorServerConfigurationSupport.this.raftContext.getActor().tell((Object)TimeoutNow.INSTANCE, RaftActorServerConfigurationSupport.this.raftContext.getActor());
            RaftActorServerConfigurationSupport.this.currentOperationState = new WaitingForLeaderElected(this.changeVotingStatusContext, previousServerConfig);
        }

        private boolean updateLocalPeerInfo() {
            List<ServerInfo> newServerInfoList = this.newServerInfoList();
            boolean atLeastOneVoting = false;
            for (ServerInfo info : newServerInfoList) {
                if (!info.isVoting()) continue;
                atLeastOneVoting = true;
                break;
            }
            if (!atLeastOneVoting) {
                this.operationComplete(this.changeVotingStatusContext, ServerChangeStatus.INVALID_REQUEST);
                return false;
            }
            RaftActorServerConfigurationSupport.this.raftContext.updatePeerIds(new ServerConfigurationPayload(newServerInfoList));
            if (RaftActorServerConfigurationSupport.this.raftActor.getCurrentBehavior() instanceof AbstractLeader) {
                AbstractLeader leader = (AbstractLeader)RaftActorServerConfigurationSupport.this.raftActor.getCurrentBehavior();
                leader.updateMinReplicaCount();
            }
            return true;
        }

        private List<ServerInfo> newServerInfoList() {
            Map<String, Boolean> serverVotingStatusMap = ((ChangeServersVotingStatus)this.changeVotingStatusContext.getOperation()).getServerVotingStatusMap();
            ArrayList<ServerInfo> newServerInfoList = new ArrayList<ServerInfo>();
            for (String peerId : RaftActorServerConfigurationSupport.this.raftContext.getPeerIds()) {
                newServerInfoList.add(new ServerInfo(peerId, serverVotingStatusMap.containsKey(peerId) ? serverVotingStatusMap.get(peerId).booleanValue() : RaftActorServerConfigurationSupport.this.raftContext.getPeerInfo(peerId).isVoting()));
            }
            newServerInfoList.add(new ServerInfo(RaftActorServerConfigurationSupport.this.raftContext.getId(), serverVotingStatusMap.containsKey(RaftActorServerConfigurationSupport.this.raftContext.getId()) ? serverVotingStatusMap.get(RaftActorServerConfigurationSupport.this.raftContext.getId()).booleanValue() : RaftActorServerConfigurationSupport.this.raftContext.isVotingMember()));
            return newServerInfoList;
        }
    }

    private static class ChangeServersVotingStatusContext
    extends ServerOperationContext<ChangeServersVotingStatus> {
        private final boolean tryToElectLeader;

        ChangeServersVotingStatusContext(ChangeServersVotingStatus convertMessage, ActorRef clientRequestor, boolean tryToElectLeader) {
            super(convertMessage, clientRequestor);
            this.tryToElectLeader = tryToElectLeader;
        }

        @Override
        InitialOperationState newInitialOperationState(RaftActorServerConfigurationSupport support) {
            RaftActorServerConfigurationSupport raftActorServerConfigurationSupport = support;
            Objects.requireNonNull(raftActorServerConfigurationSupport);
            return raftActorServerConfigurationSupport.new ChangeServersVotingStatusState(this, this.tryToElectLeader);
        }

        @Override
        Object newReply(ServerChangeStatus status, String leaderId) {
            return new ServerChangeReply(status, leaderId);
        }

        @Override
        void operationComplete(RaftActor raftActor, boolean succeeded) {
            boolean localServerChangedToNonVoting = Boolean.FALSE.equals(((ChangeServersVotingStatus)this.getOperation()).getServerVotingStatusMap().get(raftActor.getRaftActorContext().getId()));
            if (succeeded && localServerChangedToNonVoting) {
                LOG.debug("Leader changed to non-voting - trying leadership transfer");
                raftActor.becomeNonVoting();
            } else if (raftActor.isLeader()) {
                raftActor.onVotingStateChangeComplete();
            }
        }

        @Override
        String getLoggingContext() {
            return ((ChangeServersVotingStatus)this.getOperation()).toString();
        }
    }

    private static class RemoveServerContext
    extends ServerOperationContext<RemoveServer> {
        private final String peerAddress;

        RemoveServerContext(RemoveServer operation, String peerAddress, ActorRef clientRequestor) {
            super(operation, clientRequestor);
            this.peerAddress = peerAddress;
        }

        @Override
        Object newReply(ServerChangeStatus status, String leaderId) {
            return new RemoveServerReply(status, leaderId);
        }

        @Override
        InitialOperationState newInitialOperationState(RaftActorServerConfigurationSupport support) {
            RaftActorServerConfigurationSupport raftActorServerConfigurationSupport = support;
            Objects.requireNonNull(raftActorServerConfigurationSupport);
            return raftActorServerConfigurationSupport.new InitialRemoveServerState(this);
        }

        @Override
        void operationComplete(RaftActor raftActor, boolean succeeded) {
            if (this.peerAddress != null) {
                raftActor.context().actorSelection(this.peerAddress).tell((Object)new ServerRemoved(((RemoveServer)this.getOperation()).getServerId()), raftActor.getSelf());
            }
        }

        @Override
        boolean includeSelfInNewConfiguration(RaftActor raftActor) {
            return !((RemoveServer)this.getOperation()).getServerId().equals(raftActor.getId());
        }

        @Override
        String getLoggingContext() {
            return ((RemoveServer)this.getOperation()).getServerId();
        }
    }

    private final class InitialRemoveServerState
    extends RemoveServerState
    implements InitialOperationState {
        protected InitialRemoveServerState(RemoveServerContext removeServerContext) {
            super(removeServerContext);
        }

        @Override
        public void initiate() {
            String serverId = ((RemoveServer)this.getRemoveServerContext().getOperation()).getServerId();
            RaftActorServerConfigurationSupport.this.raftContext.removePeer(serverId);
            AbstractLeader leader = (AbstractLeader)RaftActorServerConfigurationSupport.this.raftActor.getCurrentBehavior();
            leader.removeFollower(serverId);
            leader.updateMinReplicaCount();
            this.persistNewServerConfiguration(this.getRemoveServerContext());
        }
    }

    private abstract class RemoveServerState
    extends OperationState {
        private final RemoveServerContext removeServerContext;

        protected RemoveServerState(RemoveServerContext removeServerContext) {
            this.removeServerContext = Objects.requireNonNull(removeServerContext);
        }

        public RemoveServerContext getRemoveServerContext() {
            return this.removeServerContext;
        }
    }

    private static class AddServerContext
    extends ServerOperationContext<AddServer> {
        AddServerContext(AddServer addServer, ActorRef clientRequestor) {
            super(addServer, clientRequestor);
        }

        @Override
        Object newReply(ServerChangeStatus status, String leaderId) {
            return new AddServerReply(status, leaderId);
        }

        @Override
        InitialOperationState newInitialOperationState(RaftActorServerConfigurationSupport support) {
            RaftActorServerConfigurationSupport raftActorServerConfigurationSupport = support;
            Objects.requireNonNull(raftActorServerConfigurationSupport);
            return raftActorServerConfigurationSupport.new InitialAddServerState(this);
        }

        @Override
        String getLoggingContext() {
            return ((AddServer)this.getOperation()).getNewServerId();
        }
    }

    private static abstract class ServerOperationContext<T> {
        private final T operation;
        private final ActorRef clientRequestor;
        private final Identifier contextId;

        ServerOperationContext(T operation, ActorRef clientRequestor) {
            this.operation = operation;
            this.clientRequestor = clientRequestor;
            this.contextId = new ServerOperationContextIdentifier();
        }

        Identifier getContextId() {
            return this.contextId;
        }

        T getOperation() {
            return this.operation;
        }

        ActorRef getClientRequestor() {
            return this.clientRequestor;
        }

        void operationComplete(RaftActor raftActor, boolean succeeded) {
        }

        boolean includeSelfInNewConfiguration(RaftActor raftActor) {
            return true;
        }

        abstract Object newReply(ServerChangeStatus var1, String var2);

        abstract InitialOperationState newInitialOperationState(RaftActorServerConfigurationSupport var1);

        abstract String getLoggingContext();
    }

    private static final class ServerOperationContextIdentifier
    extends AbstractUUIDIdentifier<ServerOperationContextIdentifier> {
        private static final long serialVersionUID = 1L;

        ServerOperationContextIdentifier() {
            super(UUID.randomUUID());
        }
    }

    private final class WaitingForPriorSnapshotComplete
    extends AddServerState {
        private final Cancellable snapshotTimer;

        WaitingForPriorSnapshotComplete(AddServerContext addServerContext, Cancellable snapshotTimer) {
            super(addServerContext);
            this.snapshotTimer = Objects.requireNonNull(snapshotTimer);
        }

        @Override
        public void onSnapshotComplete() {
            LOG.debug("{}: onSnapshotComplete", (Object)RaftActorServerConfigurationSupport.this.raftContext.getId());
            if (!RaftActorServerConfigurationSupport.this.raftActor.isLeader()) {
                LOG.debug("{}: No longer the leader", (Object)RaftActorServerConfigurationSupport.this.raftContext.getId());
                return;
            }
            AbstractLeader leader = (AbstractLeader)RaftActorServerConfigurationSupport.this.raftActor.getCurrentBehavior();
            if (leader.initiateCaptureSnapshot(((AddServer)this.getAddServerContext().getOperation()).getNewServerId())) {
                LOG.debug("{}: Initiating capture snapshot for new server {}", (Object)RaftActorServerConfigurationSupport.this.raftContext.getId(), (Object)((AddServer)this.getAddServerContext().getOperation()).getNewServerId());
                RaftActorServerConfigurationSupport.this.currentOperationState = new InstallingSnapshot(this.getAddServerContext(), this.newInstallSnapshotTimer());
                this.snapshotTimer.cancel();
            }
        }

        @Override
        public void onServerOperationTimeout(ServerOperationTimeout timeout) {
            this.handleInstallSnapshotTimeout(timeout);
            LOG.warn("{}: Timeout occured for new server {} while waiting for prior snapshot to complete", (Object)RaftActorServerConfigurationSupport.this.raftContext.getId(), (Object)timeout.getLoggingContext());
        }
    }

    private final class InstallingSnapshot
    extends AddServerState {
        private final Cancellable installSnapshotTimer;

        InstallingSnapshot(AddServerContext addServerContext, Cancellable installSnapshotTimer) {
            super(addServerContext);
            this.installSnapshotTimer = Objects.requireNonNull(installSnapshotTimer);
        }

        @Override
        public void onServerOperationTimeout(ServerOperationTimeout timeout) {
            this.handleInstallSnapshotTimeout(timeout);
            LOG.warn("{}: Timeout occured for new server {} while installing snapshot", (Object)RaftActorServerConfigurationSupport.this.raftContext.getId(), (Object)timeout.getLoggingContext());
        }

        @Override
        public void onUnInitializedFollowerSnapshotReply(UnInitializedFollowerSnapshotReply reply) {
            LOG.debug("{}: onUnInitializedFollowerSnapshotReply: {}", (Object)RaftActorServerConfigurationSupport.this.raftContext.getId(), (Object)reply);
            String followerId = reply.getFollowerId();
            if (((AddServer)this.getAddServerContext().getOperation()).getNewServerId().equals(followerId) && RaftActorServerConfigurationSupport.this.raftActor.isLeader()) {
                AbstractLeader leader = (AbstractLeader)RaftActorServerConfigurationSupport.this.raftActor.getCurrentBehavior();
                RaftActorServerConfigurationSupport.this.raftContext.getPeerInfo(followerId).setVotingState(VotingState.VOTING);
                leader.updateMinReplicaCount();
                this.persistNewServerConfiguration(this.getAddServerContext());
                this.installSnapshotTimer.cancel();
            } else {
                LOG.debug("{}: Dropping UnInitializedFollowerSnapshotReply for server {}: {}", new Object[]{RaftActorServerConfigurationSupport.this.raftContext.getId(), followerId, !RaftActorServerConfigurationSupport.this.raftActor.isLeader() ? "not leader" : "server Id doesn't match"});
            }
        }
    }

    private final class InitialAddServerState
    extends AddServerState
    implements InitialOperationState {
        InitialAddServerState(AddServerContext addServerContext) {
            super(addServerContext);
        }

        @Override
        public void initiate() {
            AbstractLeader leader = (AbstractLeader)RaftActorServerConfigurationSupport.this.raftActor.getCurrentBehavior();
            AddServer addServer = (AddServer)this.getAddServerContext().getOperation();
            LOG.debug("{}: Initiating {}", (Object)RaftActorServerConfigurationSupport.this.raftContext.getId(), (Object)addServer);
            if (RaftActorServerConfigurationSupport.this.raftContext.getPeerInfo(addServer.getNewServerId()) != null) {
                this.operationComplete(this.getAddServerContext(), ServerChangeStatus.ALREADY_EXISTS);
                return;
            }
            VotingState votingState = addServer.isVotingMember() ? VotingState.VOTING_NOT_INITIALIZED : VotingState.NON_VOTING;
            RaftActorServerConfigurationSupport.this.raftContext.addToPeers(addServer.getNewServerId(), addServer.getNewServerAddress(), votingState);
            leader.addFollower(addServer.getNewServerId());
            if (votingState == VotingState.VOTING_NOT_INITIALIZED) {
                Cancellable installSnapshotTimer = this.newInstallSnapshotTimer();
                if (leader.initiateCaptureSnapshot(addServer.getNewServerId())) {
                    LOG.debug("{}: Initiating capture snapshot for new server {}", (Object)RaftActorServerConfigurationSupport.this.raftContext.getId(), (Object)addServer.getNewServerId());
                    RaftActorServerConfigurationSupport.this.currentOperationState = new InstallingSnapshot(this.getAddServerContext(), installSnapshotTimer);
                } else {
                    LOG.debug("{}: Snapshot already in progress - waiting for completion", (Object)RaftActorServerConfigurationSupport.this.raftContext.getId());
                    RaftActorServerConfigurationSupport.this.currentOperationState = new WaitingForPriorSnapshotComplete(this.getAddServerContext(), installSnapshotTimer);
                }
            } else {
                LOG.debug("{}: New follower is non-voting - directly persisting new server configuration", (Object)RaftActorServerConfigurationSupport.this.raftContext.getId());
                this.persistNewServerConfiguration(this.getAddServerContext());
            }
        }
    }

    private abstract class AddServerState
    extends OperationState {
        private final AddServerContext addServerContext;

        AddServerState(AddServerContext addServerContext) {
            this.addServerContext = addServerContext;
        }

        AddServerContext getAddServerContext() {
            return this.addServerContext;
        }

        Cancellable newInstallSnapshotTimer() {
            return this.newTimer(new ServerOperationTimeout(((AddServer)this.addServerContext.getOperation()).getNewServerId()));
        }

        void handleInstallSnapshotTimeout(ServerOperationTimeout timeout) {
            String serverId = timeout.getLoggingContext();
            LOG.debug("{}: handleInstallSnapshotTimeout for new server {}", (Object)RaftActorServerConfigurationSupport.this.raftContext.getId(), (Object)serverId);
            RaftActorServerConfigurationSupport.this.raftContext.removePeer(serverId);
            boolean isLeader = RaftActorServerConfigurationSupport.this.raftActor.isLeader();
            if (isLeader) {
                AbstractLeader leader = (AbstractLeader)RaftActorServerConfigurationSupport.this.raftActor.getCurrentBehavior();
                leader.removeFollower(serverId);
            }
            this.operationComplete(this.getAddServerContext(), isLeader ? ServerChangeStatus.TIMEOUT : ServerChangeStatus.NO_LEADER);
        }
    }

    private final class Persisting
    extends OperationState {
        private final ServerOperationContext<?> operationContext;
        private final Cancellable timer;
        private boolean timedOut;

        Persisting(ServerOperationContext<?> operationContext, Cancellable timer) {
            this.timedOut = false;
            this.operationContext = operationContext;
            this.timer = timer;
        }

        @Override
        public void onApplyState(ApplyState applyState) {
            if (this.operationContext.getContextId().equals((Object)applyState.getIdentifier())) {
                LOG.info("{}: {} has been successfully replicated to a majority of followers", (Object)RaftActorServerConfigurationSupport.this.raftContext.getId(), (Object)applyState.getReplicatedLogEntry().getData());
                this.timer.cancel();
                this.operationComplete(this.operationContext, null);
            }
        }

        @Override
        public void onServerOperationTimeout(ServerOperationTimeout timeout) {
            LOG.warn("{}: Timeout occured while replicating the new server configuration for {}", (Object)RaftActorServerConfigurationSupport.this.raftContext.getId(), (Object)timeout.getLoggingContext());
            this.timedOut = true;
            ServerOperationContext<?> nextOperation = RaftActorServerConfigurationSupport.this.pendingOperationsQueue.poll();
            while (nextOperation != null) {
                this.sendReply(nextOperation, ServerChangeStatus.PRIOR_REQUEST_CONSENSUS_TIMEOUT);
                nextOperation = RaftActorServerConfigurationSupport.this.pendingOperationsQueue.poll();
            }
        }

        @Override
        public void onNewOperation(ServerOperationContext<?> newOperationContext) {
            if (this.timedOut) {
                this.sendReply(newOperationContext, ServerChangeStatus.PRIOR_REQUEST_CONSENSUS_TIMEOUT);
            } else {
                super.onNewOperation(newOperationContext);
            }
        }
    }

    private final class Idle
    extends OperationState {
        private Idle() {
        }

        @Override
        public void onNewOperation(ServerOperationContext<?> operationContext) {
            operationContext.newInitialOperationState(RaftActorServerConfigurationSupport.this).initiate();
        }

        @Override
        public void onApplyState(ApplyState applyState) {
        }
    }

    private abstract class OperationState {
        private OperationState() {
        }

        void onNewOperation(ServerOperationContext<?> operationContext) {
            LOG.debug("{}: Server operation already in progress - queueing {}", (Object)RaftActorServerConfigurationSupport.this.raftContext.getId(), operationContext.getOperation());
            RaftActorServerConfigurationSupport.this.pendingOperationsQueue.add(operationContext);
        }

        void onServerOperationTimeout(ServerOperationTimeout timeout) {
            LOG.debug("onServerOperationTimeout should not be called in state {}", (Object)this);
        }

        void onUnInitializedFollowerSnapshotReply(UnInitializedFollowerSnapshotReply reply) {
            LOG.debug("onUnInitializedFollowerSnapshotReply was called in state {}", (Object)this);
        }

        void onApplyState(ApplyState applyState) {
            LOG.debug("onApplyState was called in state {}", (Object)this);
        }

        void onSnapshotComplete() {
        }

        void onNewLeader(String newLeader) {
        }

        protected void persistNewServerConfiguration(ServerOperationContext<?> operationContext) {
            RaftActorServerConfigurationSupport.this.raftContext.setDynamicServerConfigurationInUse();
            ServerConfigurationPayload payload = RaftActorServerConfigurationSupport.this.raftContext.getPeerServerInfo(operationContext.includeSelfInNewConfiguration(RaftActorServerConfigurationSupport.this.raftActor));
            LOG.debug("{}: New server configuration : {}", (Object)RaftActorServerConfigurationSupport.this.raftContext.getId(), payload.getServerConfig());
            RaftActorServerConfigurationSupport.this.raftActor.persistData(operationContext.getClientRequestor(), operationContext.getContextId(), payload, false);
            RaftActorServerConfigurationSupport.this.currentOperationState = new Persisting(operationContext, this.newTimer(new ServerOperationTimeout(operationContext.getLoggingContext())));
            this.sendReply(operationContext, ServerChangeStatus.OK);
        }

        protected void operationComplete(ServerOperationContext<?> operationContext, @Nullable ServerChangeStatus replyStatus) {
            if (replyStatus != null) {
                this.sendReply(operationContext, replyStatus);
            }
            operationContext.operationComplete(RaftActorServerConfigurationSupport.this.raftActor, replyStatus == null || replyStatus == ServerChangeStatus.OK);
            this.changeToIdleState();
        }

        protected void changeToIdleState() {
            RaftActorServerConfigurationSupport.this.currentOperationState = RaftActorServerConfigurationSupport.this.IDLE;
            ServerOperationContext<?> nextOperation = RaftActorServerConfigurationSupport.this.pendingOperationsQueue.poll();
            if (nextOperation != null) {
                RaftActorServerConfigurationSupport.this.onNewOperation(nextOperation);
            }
        }

        protected void sendReply(ServerOperationContext<?> operationContext, ServerChangeStatus status) {
            LOG.debug("{}: Returning {} for operation {}", new Object[]{RaftActorServerConfigurationSupport.this.raftContext.getId(), status, operationContext.getOperation()});
            operationContext.getClientRequestor().tell(operationContext.newReply(status, RaftActorServerConfigurationSupport.this.raftActor.getLeaderId()), RaftActorServerConfigurationSupport.this.raftActor.self());
        }

        Cancellable newTimer(Object message) {
            return this.newTimer(RaftActorServerConfigurationSupport.this.raftContext.getConfigParams().getElectionTimeOutInterval().$times(2L), message);
        }

        Cancellable newTimer(FiniteDuration timeout, Object message) {
            return RaftActorServerConfigurationSupport.this.raftContext.getActorSystem().scheduler().scheduleOnce(timeout, RaftActorServerConfigurationSupport.this.raftContext.getActor(), message, (ExecutionContext)RaftActorServerConfigurationSupport.this.raftContext.getActorSystem().dispatcher(), RaftActorServerConfigurationSupport.this.raftContext.getActor());
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }

    private static interface InitialOperationState {
        public void initiate();
    }
}

