/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.raft.persisted;

import com.google.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.controller.cluster.raft.persisted.ServerInfo;
import org.opendaylight.controller.cluster.raft.protobuff.client.messages.Payload;
import org.opendaylight.controller.cluster.raft.protobuff.client.messages.PersistentPayload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServerConfigurationPayload
extends Payload
implements PersistentPayload,
Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(ServerConfigurationPayload.class);
    private static final long serialVersionUID = 1L;
    @SuppressFBWarnings(value={"SE_BAD_FIELD"}, justification="This field is not Serializable but this class implements writeReplace to delegate serialization to a Proxy class and thus instances of this class aren't serialized. FindBugs does not recognize this.")
    private final List<ServerInfo> serverConfig;
    private int serializedSize = -1;

    public ServerConfigurationPayload(@NonNull List<ServerInfo> serverConfig) {
        this.serverConfig = ImmutableList.copyOf(serverConfig);
    }

    public @NonNull List<ServerInfo> getServerConfig() {
        return this.serverConfig;
    }

    public int size() {
        if (this.serializedSize < 0) {
            try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
                try (ObjectOutputStream out = new ObjectOutputStream(bos);){
                    out.writeObject(this.writeReplace());
                }
                this.serializedSize = bos.toByteArray().length;
            }
            catch (IOException e) {
                this.serializedSize = 0;
                LOG.error("Error serializing", (Throwable)e);
            }
        }
        return this.serializedSize;
    }

    public int hashCode() {
        return this.serverConfig.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ServerConfigurationPayload other = (ServerConfigurationPayload)obj;
        return this.serverConfig.equals(other.serverConfig);
    }

    public String toString() {
        return "ServerConfigurationPayload [serverConfig=" + this.serverConfig + "]";
    }

    private Object writeReplace() {
        return new Proxy(this);
    }

    private static final class Proxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private List<ServerInfo> serverConfig;

        public Proxy() {
        }

        Proxy(ServerConfigurationPayload payload) {
            this.serverConfig = payload.getServerConfig();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.serverConfig.size());
            for (ServerInfo i : this.serverConfig) {
                out.writeObject(i.getId());
                out.writeBoolean(i.isVoting());
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int size = in.readInt();
            this.serverConfig = new ArrayList<ServerInfo>(size);
            for (int i = 0; i < size; ++i) {
                String id = (String)in.readObject();
                boolean voting = in.readBoolean();
                this.serverConfig.add(new ServerInfo(id, voting));
            }
        }

        private Object readResolve() {
            return new ServerConfigurationPayload(this.serverConfig);
        }
    }
}

