/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.raft.persisted;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Objects;
import org.opendaylight.controller.cluster.raft.ReplicatedLogEntry;
import org.opendaylight.controller.cluster.raft.protobuff.client.messages.Payload;

public final class SimpleReplicatedLogEntry
implements ReplicatedLogEntry,
Serializable {
    private static final long serialVersionUID = 1L;
    private final long index;
    private final long term;
    private final Payload payload;
    private boolean persistencePending;

    public SimpleReplicatedLogEntry(long index, long term, Payload payload) {
        this.index = index;
        this.term = term;
        this.payload = Objects.requireNonNull(payload);
    }

    @Override
    public Payload getData() {
        return this.payload;
    }

    @Override
    public long getTerm() {
        return this.term;
    }

    @Override
    public long getIndex() {
        return this.index;
    }

    @Override
    public int size() {
        return this.getData().size();
    }

    @Override
    public boolean isPersistencePending() {
        return this.persistencePending;
    }

    @Override
    public void setPersistencePending(boolean pending) {
        this.persistencePending = pending;
    }

    private Object writeReplace() {
        return new Proxy(this);
    }

    public int estimatedSerializedSize() {
        return Proxy.estimatedSerializedSize(this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.payload.hashCode();
        result = 31 * result + (int)(this.index ^ this.index >>> 32);
        result = 31 * result + (int)(this.term ^ this.term >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleReplicatedLogEntry other = (SimpleReplicatedLogEntry)obj;
        return this.index == other.index && this.term == other.term && this.payload.equals(other.payload);
    }

    public String toString() {
        return "SimpleReplicatedLogEntry [index=" + this.index + ", term=" + this.term + ", payload=" + this.payload + "]";
    }

    private static final class Proxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private ReplicatedLogEntry replicatedLogEntry;

        public Proxy() {
        }

        Proxy(ReplicatedLogEntry replicatedLogEntry) {
            this.replicatedLogEntry = replicatedLogEntry;
        }

        static int estimatedSerializedSize(ReplicatedLogEntry replicatedLogEntry) {
            return 16 + replicatedLogEntry.getData().size() + 400;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeLong(this.replicatedLogEntry.getIndex());
            out.writeLong(this.replicatedLogEntry.getTerm());
            out.writeObject(this.replicatedLogEntry.getData());
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.replicatedLogEntry = new SimpleReplicatedLogEntry(in.readLong(), in.readLong(), (Payload)in.readObject());
        }

        private Object readResolve() {
            return this.replicatedLogEntry;
        }
    }
}

