/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.raft.persisted;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.opendaylight.controller.cluster.raft.ReplicatedLogEntry;
import org.opendaylight.controller.cluster.raft.persisted.ServerConfigurationPayload;
import org.opendaylight.controller.cluster.raft.persisted.SimpleReplicatedLogEntry;
import org.opendaylight.controller.cluster.raft.protobuff.client.messages.Payload;

public class Snapshot
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final State state;
    private final List<ReplicatedLogEntry> unAppliedEntries;
    private final long lastIndex;
    private final long lastTerm;
    private final long lastAppliedIndex;
    private final long lastAppliedTerm;
    private final long electionTerm;
    private final String electionVotedFor;
    private final ServerConfigurationPayload serverConfig;

    Snapshot(State state, List<ReplicatedLogEntry> unAppliedEntries, long lastIndex, long lastTerm, long lastAppliedIndex, long lastAppliedTerm, long electionTerm, String electionVotedFor, ServerConfigurationPayload serverConfig) {
        this.state = state;
        this.unAppliedEntries = unAppliedEntries;
        this.lastIndex = lastIndex;
        this.lastTerm = lastTerm;
        this.lastAppliedIndex = lastAppliedIndex;
        this.lastAppliedTerm = lastAppliedTerm;
        this.electionTerm = electionTerm;
        this.electionVotedFor = electionVotedFor;
        this.serverConfig = serverConfig;
    }

    public static Snapshot create(State state, List<ReplicatedLogEntry> entries, long lastIndex, long lastTerm, long lastAppliedIndex, long lastAppliedTerm, long electionTerm, String electionVotedFor, ServerConfigurationPayload serverConfig) {
        return new Snapshot(state, entries, lastIndex, lastTerm, lastAppliedIndex, lastAppliedTerm, electionTerm, electionVotedFor, serverConfig);
    }

    public State getState() {
        return this.state;
    }

    public List<ReplicatedLogEntry> getUnAppliedEntries() {
        return this.unAppliedEntries;
    }

    public long getLastTerm() {
        return this.lastTerm;
    }

    public long getLastAppliedIndex() {
        return this.lastAppliedIndex;
    }

    public long getLastAppliedTerm() {
        return this.lastAppliedTerm;
    }

    public long getLastIndex() {
        return this.lastIndex;
    }

    public long getElectionTerm() {
        return this.electionTerm;
    }

    public String getElectionVotedFor() {
        return this.electionVotedFor;
    }

    public ServerConfigurationPayload getServerConfiguration() {
        return this.serverConfig;
    }

    private Object writeReplace() {
        return new Proxy(this);
    }

    public String toString() {
        return "Snapshot [lastIndex=" + this.lastIndex + ", lastTerm=" + this.lastTerm + ", lastAppliedIndex=" + this.lastAppliedIndex + ", lastAppliedTerm=" + this.lastAppliedTerm + ", unAppliedEntries size=" + this.unAppliedEntries.size() + ", state=" + this.state + ", electionTerm=" + this.electionTerm + ", electionVotedFor=" + this.electionVotedFor + ", ServerConfigPayload=" + this.serverConfig + "]";
    }

    private static final class Proxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private Snapshot snapshot;

        public Proxy() {
        }

        Proxy(Snapshot snapshot) {
            this.snapshot = snapshot;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeLong(this.snapshot.lastIndex);
            out.writeLong(this.snapshot.lastTerm);
            out.writeLong(this.snapshot.lastAppliedIndex);
            out.writeLong(this.snapshot.lastAppliedTerm);
            out.writeLong(this.snapshot.electionTerm);
            out.writeObject(this.snapshot.electionVotedFor);
            out.writeObject(this.snapshot.serverConfig);
            out.writeInt(this.snapshot.unAppliedEntries.size());
            for (ReplicatedLogEntry e : this.snapshot.unAppliedEntries) {
                out.writeLong(e.getIndex());
                out.writeLong(e.getTerm());
                out.writeObject(e.getData());
            }
            out.writeObject(this.snapshot.state);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            long lastIndex = in.readLong();
            long lastTerm = in.readLong();
            long lastAppliedIndex = in.readLong();
            long lastAppliedTerm = in.readLong();
            long electionTerm = in.readLong();
            String electionVotedFor = (String)in.readObject();
            ServerConfigurationPayload serverConfig = (ServerConfigurationPayload)in.readObject();
            int size = in.readInt();
            ArrayList<ReplicatedLogEntry> unAppliedEntries = new ArrayList<ReplicatedLogEntry>(size);
            for (int i = 0; i < size; ++i) {
                unAppliedEntries.add(new SimpleReplicatedLogEntry(in.readLong(), in.readLong(), (Payload)in.readObject()));
            }
            State state = (State)in.readObject();
            this.snapshot = Snapshot.create(state, unAppliedEntries, lastIndex, lastTerm, lastAppliedIndex, lastAppliedTerm, electionTerm, electionVotedFor, serverConfig);
        }

        private Object readResolve() {
            return this.snapshot;
        }
    }

    public static interface State
    extends Serializable {
        default public boolean needsMigration() {
            return false;
        }
    }
}

