/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.webconsole.features;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.utils.json.JSONWriter;
import org.apache.felix.webconsole.AbstractWebConsolePlugin;
import org.apache.karaf.features.Feature;
import org.apache.karaf.features.FeaturesService;
import org.apache.karaf.features.Repository;
import org.apache.karaf.webconsole.features.ExtendedFeature;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeaturesPlugin
extends AbstractWebConsolePlugin {
    private final Logger log = LoggerFactory.getLogger(FeaturesPlugin.class);
    public static final String NAME = "features";
    public static final String LABEL = "Features";
    private ClassLoader classLoader;
    private String featuresJs = "/features/res/ui/features.js";
    private FeaturesService featuresService;
    private BundleContext bundleContext;

    protected boolean isHtmlRequest(HttpServletRequest request) {
        return true;
    }

    public void start() {
        super.activate(this.bundleContext);
        this.classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        this.log.info("Features plugin activated");
    }

    public void stop() {
        this.log.info("Features plugin deactivated");
        super.deactivate();
    }

    public String getLabel() {
        return NAME;
    }

    public String getTitle() {
        return LABEL;
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        boolean success = false;
        String action = req.getParameter("action");
        String feature = req.getParameter("feature");
        String version = req.getParameter("version");
        String url = req.getParameter("url");
        if (action == null) {
            success = true;
        } else if ("installFeature".equals(action)) {
            success = this.installFeature(feature, version);
        } else if ("uninstallFeature".equals(action)) {
            success = this.uninstallFeature(feature, version);
        } else if ("refreshRepository".equals(action)) {
            success = this.refreshRepository(url);
        } else if ("removeRepository".equals(action)) {
            success = this.removeRepository(url);
        } else if ("addRepository".equals(action)) {
            success = this.addRepository(url);
        }
        if (success) {
            try {
                Thread.sleep(800L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.renderJSON(resp);
        } else {
            super.doPost(req, resp);
        }
    }

    protected void renderContent(HttpServletRequest request, HttpServletResponse response) throws IOException {
        PrintWriter pw = response.getWriter();
        String appRoot = (String)request.getAttribute("felix.webconsole.appRoot");
        String featuresScriptTag = "<script src='" + appRoot + this.featuresJs + "' language='JavaScript'></script>";
        pw.println(featuresScriptTag);
        pw.println("<script type='text/javascript'>");
        pw.println("// <![CDATA[");
        pw.println("var imgRoot = '" + appRoot + "/res/imgs';");
        pw.println("// ]]>");
        pw.println("</script>");
        pw.println("<div id='plugin_content'>");
        pw.println("<script type='text/javascript'>");
        pw.println("// <![CDATA[");
        pw.print("renderFeatures( ");
        this.writeJSON(pw);
        pw.println(" )");
        pw.println("// ]]>");
        pw.println("</script>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected URL getResource(String path) {
        if ((path = path.substring(NAME.length() + 1)) == null || path.isEmpty()) {
            return null;
        }
        URL url = this.classLoader.getResource(path);
        if (url != null) {
            InputStream ins = null;
            try {
                ins = url.openStream();
                if (ins == null) {
                    this.log.error("failed to open " + url);
                    url = null;
                }
            }
            catch (IOException e) {
                this.log.error(e.getMessage(), (Throwable)e);
                url = null;
            }
            finally {
                if (ins != null) {
                    try {
                        ins.close();
                    }
                    catch (IOException e) {
                        this.log.error(e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
        return url;
    }

    private boolean installFeature(String feature, String version) {
        boolean success = false;
        if (this.featuresService == null) {
            this.log.error("Features service is not available");
        }
        try {
            this.featuresService.installFeature(feature, version);
            success = true;
        }
        catch (Exception e) {
            this.log.error("Can't install feature {}/{}", new Object[]{feature, version, e});
        }
        return success;
    }

    private boolean uninstallFeature(String feature, String version) {
        boolean success = false;
        if (this.featuresService == null) {
            this.log.error("Features service is not available");
        }
        try {
            this.featuresService.uninstallFeature(feature, version);
            success = true;
        }
        catch (Exception e) {
            this.log.error("Can't uninstall feature {}/{}", new Object[]{feature, version, e});
        }
        return success;
    }

    private boolean removeRepository(String url) {
        boolean success = false;
        if (this.featuresService == null) {
            this.log.error("Features service is not available");
        }
        try {
            this.featuresService.removeRepository(new URI(url));
            success = true;
        }
        catch (Exception e) {
            this.log.error("Can't remove features repository {}", (Object)url, (Object)e);
        }
        return success;
    }

    private boolean refreshRepository(String url) {
        boolean success = false;
        if (this.featuresService == null) {
            this.log.error("Features service is not available");
        }
        try {
            this.featuresService.refreshRepository(new URI(url));
            success = true;
        }
        catch (Exception e) {
            this.log.error("Can't refresh features repository {}", (Object)url, (Object)e);
        }
        return success;
    }

    private boolean addRepository(String url) {
        boolean success = false;
        if (this.featuresService == null) {
            this.log.error("Features service is not available");
        }
        try {
            this.featuresService.addRepository(new URI(url));
            success = true;
        }
        catch (Exception e) {
            this.log.error("Can't add features repository {}", (Object)url, (Object)e);
        }
        return success;
    }

    private void renderJSON(HttpServletResponse response) throws IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        PrintWriter pw = response.getWriter();
        this.writeJSON(pw);
    }

    private void writeJSON(PrintWriter pw) throws IOException {
        List<Repository> repositories = this.getRepositories();
        List<ExtendedFeature> features = this.getFeatures(repositories);
        String statusLine = this.getStatusLine(features);
        JSONWriter jw = new JSONWriter(pw);
        jw.object();
        jw.key("status");
        jw.value(statusLine);
        jw.key("repositories");
        jw.array();
        for (Repository r : repositories) {
            jw.object();
            jw.key("name");
            String name = "";
            if (r.getName() != null) {
                name = r.getName();
            }
            jw.value(name);
            jw.key("url");
            String uri = r.getURI().toString();
            jw.value(uri);
            jw.key("actions");
            jw.array();
            boolean enable = true;
            if (uri.startsWith("bundle")) {
                enable = false;
            }
            this.action(jw, enable, "refreshRepository", "Refresh", "refresh");
            this.action(jw, enable, "removeRepository", "Remove", "delete");
            jw.endArray();
            jw.endObject();
        }
        jw.endArray();
        jw.key(NAME);
        jw.array();
        for (ExtendedFeature f : features) {
            this.featureInfo(jw, f);
        }
        jw.endArray();
        jw.endObject();
    }

    private List<Repository> getRepositories() {
        ArrayList<Repository> repositories = new ArrayList<Repository>();
        if (this.featuresService == null) {
            this.log.error("Features service is not available");
            return repositories;
        }
        try {
            repositories.addAll(Arrays.asList(this.featuresService.listRepositories()));
        }
        catch (Exception e) {
            this.log.error(e.getMessage());
        }
        return repositories;
    }

    private List<ExtendedFeature> getFeatures(List<Repository> repositories) {
        ArrayList<ExtendedFeature> features = new ArrayList<ExtendedFeature>();
        if (this.featuresService == null) {
            this.log.error("Features service is not available");
            return features;
        }
        try {
            for (Repository r : repositories) {
                for (Feature f : r.getFeatures()) {
                    ExtendedFeature.State state = this.featuresService.isInstalled(f) ? ExtendedFeature.State.INSTALLED : ExtendedFeature.State.UNINSTALLED;
                    features.add(new ExtendedFeature(state, r.getName(), f));
                }
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage());
        }
        features.sort(new ExtendedFeatureComparator());
        return features;
    }

    private String getStatusLine(List<ExtendedFeature> features) {
        int installed = 0;
        for (ExtendedFeature f : features) {
            if (f.getState() != ExtendedFeature.State.INSTALLED) continue;
            ++installed;
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append("Feature information: ");
        this.appendFeatureInfoCount(buffer, "in total", features.size());
        if (installed == features.size()) {
            buffer.append(" - all ");
            this.appendFeatureInfoCount(buffer, "active.", features.size());
        } else {
            if (installed != 0) {
                buffer.append(", ");
                this.appendFeatureInfoCount(buffer, "installed", installed);
            }
            buffer.append('.');
        }
        return buffer.toString();
    }

    private void appendFeatureInfoCount(StringBuilder buf, String msg, int count) {
        buf.append(count);
        buf.append(" feature");
        if (count != 1) {
            buf.append('s');
        }
        buf.append(' ');
        buf.append(msg);
    }

    private void featureInfo(JSONWriter jw, ExtendedFeature feature) throws IOException {
        jw.object();
        jw.key("id");
        jw.value(feature.getId());
        jw.key("name");
        jw.value(feature.getName());
        jw.key("version");
        jw.value(feature.getVersion());
        jw.key("repository");
        jw.value(feature.getRepository());
        jw.key("state");
        ExtendedFeature.State state = feature.getState();
        jw.value(state.toString());
        jw.key("actions");
        jw.array();
        if (state == ExtendedFeature.State.INSTALLED) {
            this.action(jw, true, "uninstallFeature", "Uninstall", "delete");
        } else if (state == ExtendedFeature.State.UNINSTALLED) {
            this.action(jw, true, "installFeature", "Install", "start");
        }
        jw.endArray();
        jw.endObject();
    }

    private void action(JSONWriter jw, boolean enabled, String op, String title, String image) throws IOException {
        jw.object();
        jw.key("enabled").value(enabled);
        jw.key("op").value(op);
        jw.key("title").value(title);
        jw.key("image").value(image);
        jw.endObject();
    }

    public void setFeaturesService(FeaturesService featuresService) {
        this.featuresService = featuresService;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    class ExtendedFeatureComparator
    implements Comparator<ExtendedFeature> {
        ExtendedFeatureComparator() {
        }

        @Override
        public int compare(ExtendedFeature o1, ExtendedFeature o2) {
            return o1.getName().toLowerCase().compareTo(o2.getName().toLowerCase());
        }
    }
}

