/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.repo.util;

import java.util.Objects;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaSourceRepresentation;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.spi.PotentialSchemaSource;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaSourceListener;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaSourceProvider;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaSourceRegistration;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaSourceRegistry;

public abstract class AbstractSchemaSourceCache<T extends SchemaSourceRepresentation>
implements SchemaSourceListener,
SchemaSourceProvider<T> {
    private final SchemaSourceRegistry consumer;
    private final Class<T> representation;
    private final PotentialSchemaSource.Costs cost;

    protected AbstractSchemaSourceCache(SchemaSourceRegistry consumer, Class<T> representation, PotentialSchemaSource.Costs cost) {
        this.consumer = Objects.requireNonNull(consumer);
        this.representation = Objects.requireNonNull(representation);
        this.cost = Objects.requireNonNull(cost);
    }

    protected abstract void offer(T var1);

    protected final SchemaSourceRegistration<T> register(SourceIdentifier sourceIdentifier) {
        PotentialSchemaSource src = PotentialSchemaSource.create((SourceIdentifier)sourceIdentifier, this.representation, (int)this.cost.getValue());
        return this.consumer.registerSchemaSource((SchemaSourceProvider)this, src);
    }

    public void schemaSourceEncountered(SchemaSourceRepresentation source) {
        if (this.representation.isAssignableFrom(source.getType())) {
            this.offer((SchemaSourceRepresentation)this.representation.cast(source));
        }
    }

    public final void schemaSourceRegistered(Iterable<PotentialSchemaSource<?>> sources) {
    }

    public final void schemaSourceUnregistered(PotentialSchemaSource<?> source) {
    }
}

