/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.TreeMultimap;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.ModuleImport;
import org.opendaylight.yangtools.yang.model.api.ModuleLike;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.Submodule;
import org.opendaylight.yangtools.yang.model.util.AbstractSchemaContext;

public final class FilteringSchemaContextProxy
extends AbstractSchemaContext {
    private final ImmutableMap<QNameModule, Module> moduleMap;
    private final ImmutableSet<Module> filteredModules;
    private final ImmutableSetMultimap<URI, Module> namespaceToModules;
    private final ImmutableSetMultimap<String, Module> nameToModules;

    public FilteringSchemaContextProxy(SchemaContext delegate, Collection<ModuleId> rootModules, Set<ModuleId> additionalModuleIds) {
        Objects.requireNonNull(rootModules, "Base modules cannot be null.");
        Objects.requireNonNull(additionalModuleIds, "Additional modules cannot be null.");
        ImmutableSet.Builder filteredModulesBuilder = new ImmutableSet.Builder();
        TreeMultimap nameToModulesAll = TreeMultimap.create(String::compareTo, (Comparator)REVISION_COMPARATOR);
        nameToModulesAll.putAll(FilteringSchemaContextProxy.getStringModuleMap(delegate));
        this.processForRootModules(delegate, rootModules, (ImmutableSet.Builder<Module>)filteredModulesBuilder);
        FilteringSchemaContextProxy.processForAdditionalModules(delegate, additionalModuleIds, (ImmutableSet.Builder<Module>)filteredModulesBuilder);
        filteredModulesBuilder.addAll(FilteringSchemaContextProxy.getImportedModules((Map<ModuleId, ? extends Module>)Maps.uniqueIndex((Iterable)delegate.getModules(), ModuleId.MODULE_TO_MODULE_ID::apply), (Collection<? extends Module>)filteredModulesBuilder.build(), (TreeMultimap<String, Module>)nameToModulesAll));
        ArrayList sortedModules = new ArrayList(filteredModulesBuilder.build());
        sortedModules.sort(NAME_REVISION_COMPARATOR);
        this.filteredModules = ImmutableSet.copyOf(sortedModules);
        SetMultimap nsMap = Multimaps.newSetMultimap(new TreeMap(), AbstractSchemaContext::createModuleSet);
        SetMultimap nameMap = Multimaps.newSetMultimap(new TreeMap(), AbstractSchemaContext::createModuleSet);
        ImmutableMap.Builder moduleMapBuilder = ImmutableMap.builder();
        for (Module module : this.filteredModules) {
            nameMap.put((Object)module.getName(), (Object)module);
            nsMap.put((Object)module.getNamespace(), (Object)module);
            moduleMapBuilder.put((Object)module.getQNameModule(), (Object)module);
        }
        this.namespaceToModules = ImmutableSetMultimap.copyOf((Multimap)nsMap);
        this.nameToModules = ImmutableSetMultimap.copyOf((Multimap)nameMap);
        this.moduleMap = moduleMapBuilder.build();
    }

    private static void processForAdditionalModules(SchemaContext delegate, Set<ModuleId> additionalModuleIds, ImmutableSet.Builder<Module> filteredModulesBuilder) {
        filteredModulesBuilder.addAll((Iterable)Collections2.filter((Collection)delegate.getModules(), module -> FilteringSchemaContextProxy.selectAdditionalModules(module, additionalModuleIds)));
    }

    private void processForRootModules(SchemaContext delegate, Collection<ModuleId> rootModules, ImmutableSet.Builder<Module> filteredModulesBuilder) {
        filteredModulesBuilder.addAll((Iterable)Collections2.filter((Collection)delegate.getModules(), module -> this.checkModuleDependency((ModuleLike)module, rootModules)));
    }

    private static Multimap<String, ? extends Module> getStringModuleMap(SchemaContext delegate) {
        return Multimaps.index((Iterable)delegate.getModules(), ModuleLike::getName);
    }

    private static Collection<Module> getImportedModules(Map<ModuleId, ? extends Module> allModules, Collection<? extends Module> baseModules, TreeMultimap<String, Module> nameToModulesAll) {
        LinkedList<Module> relatedModules = new LinkedList<Module>();
        for (Module module : baseModules) {
            for (ModuleImport moduleImport : module.getImports()) {
                ModuleId key;
                Module importedModule;
                Optional revisionDate = moduleImport.getRevision();
                if (revisionDate.isEmpty()) {
                    revisionDate = ((Module)nameToModulesAll.get((Object)moduleImport.getModuleName()).first()).getRevision();
                }
                Preconditions.checkArgument(((importedModule = allModules.get(key = new ModuleId(moduleImport.getModuleName(), revisionDate))) != null ? 1 : 0) != 0, (String)"Invalid schema, cannot find imported module: %s from module: %s, %s, modules:%s", (Object)key, (Object)module.getQNameModule(), (Object)module.getName(), allModules);
                relatedModules.add(importedModule);
                relatedModules.addAll(FilteringSchemaContextProxy.getImportedModules(allModules, Collections.singleton(importedModule), nameToModulesAll));
            }
        }
        return relatedModules;
    }

    public Set<Module> getModules() {
        return this.filteredModules;
    }

    @Override
    protected Map<QNameModule, Module> getModuleMap() {
        return this.moduleMap;
    }

    @Override
    protected SetMultimap<URI, Module> getNamespaceToModules() {
        return this.namespaceToModules;
    }

    @Override
    protected SetMultimap<String, Module> getNameToModules() {
        return this.nameToModules;
    }

    private static boolean selectAdditionalModules(Module module, Set<ModuleId> additionalModules) {
        return additionalModules.contains(new ModuleId(module.getName(), module.getRevision()));
    }

    private boolean checkModuleDependency(ModuleLike module, Collection<ModuleId> rootModules) {
        for (ModuleId rootModule : rootModules) {
            if (rootModule.equals(new ModuleId(module.getName(), module.getRevision()))) {
                return true;
            }
            for (ModuleImport moduleImport : module.getImports()) {
                if (!moduleImport.getModuleName().equals(rootModule.getName())) continue;
                return moduleImport.getRevision().isEmpty() || moduleImport.getRevision().equals(rootModule.getRev());
            }
            Iterator iterator = module.getSubmodules().iterator();
            if (!iterator.hasNext()) continue;
            Submodule moduleSub = (Submodule)iterator.next();
            return this.checkModuleDependency((ModuleLike)moduleSub, rootModules);
        }
        return false;
    }

    public String toString() {
        return String.format("SchemaContextProxyImpl{filteredModules=%s}", this.filteredModules);
    }

    public static final class ModuleId {
        private final String name;
        private final Revision rev;
        public static final Function<Module, ModuleId> MODULE_TO_MODULE_ID = input -> new ModuleId(input.getName(), input.getRevision());

        public ModuleId(String name, Optional<Revision> rev) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"No module dependency name given. Nothing to do.");
            this.name = name;
            Preconditions.checkArgument((boolean)rev.isPresent(), (Object)"No revision date given. Nothing to do.");
            this.rev = rev.get();
        }

        public String getName() {
            return this.name;
        }

        public Optional<Revision> getRev() {
            return Optional.ofNullable(this.rev);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ModuleId)) {
                return false;
            }
            ModuleId moduleId = (ModuleId)obj;
            if (this.name != null ? !this.name.equals(moduleId.name) : moduleId.name != null) {
                return false;
            }
            return !(this.rev != null ? !this.rev.equals((Object)moduleId.rev) : moduleId.rev != null);
        }

        public int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + (this.rev != null ? this.rev.hashCode() : 0);
            return result;
        }

        public String toString() {
            return String.format("ModuleId{name='%s', rev=%s}", this.name, this.rev);
        }
    }
}

