/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.util;

import com.google.common.annotations.Beta;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Optional;
import org.opendaylight.yangtools.yang.common.BiMapYangNamespaceContext;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.UnqualifiedQName;
import org.opendaylight.yangtools.yang.common.YangNamespaceContext;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.ModuleLike;
import org.opendaylight.yangtools.yang.model.api.QNameModuleAware;
import org.opendaylight.yangtools.yang.model.api.stmt.ModuleEffectiveStatement;
import org.opendaylight.yangtools.yang.model.util.AbstractEffectiveModelContextProvider;

@Beta
public final class ModuleNameNamespaceContext
extends AbstractEffectiveModelContextProvider
implements YangNamespaceContext {
    private static final long serialVersionUID = 1L;

    @SuppressFBWarnings(value={"SE_NO_SUITABLE_CONSTRUCTOR"}, justification="Handled through writeReplace()")
    public ModuleNameNamespaceContext(EffectiveModelContext schemaContext) {
        super(schemaContext);
    }

    public BiMapYangNamespaceContext toBiMap() {
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
        for (ModuleEffectiveStatement module : this.getEffectiveModelContext().getModuleStatements().values()) {
            String name = ((UnqualifiedQName)module.argument()).getLocalName();
            builder.put((Object)name, (Object)this.findNamespaceForPrefix(name).get());
        }
        return new BiMapYangNamespaceContext((BiMap)builder.build());
    }

    public Optional<QNameModule> findNamespaceForPrefix(String prefix) {
        return this.getEffectiveModelContext().findModules(prefix).stream().findFirst().map(QNameModuleAware::getQNameModule);
    }

    public Optional<String> findPrefixForNamespace(QNameModule namespace) {
        return this.getEffectiveModelContext().findModule(namespace).map(ModuleLike::getName);
    }

    private Object writeReplace() {
        return this.toBiMap();
    }
}

