/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.util;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.concepts.Mutable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContextProvider;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.GroupingEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ModuleEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaTreeAwareEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaTreeEffectiveStatement;

@Beta
public final class SchemaInferenceStack
implements Mutable,
EffectiveModelContextProvider {
    private final ArrayDeque<EffectiveStatement<QName, ?>> deque;
    private final @NonNull EffectiveModelContext effectiveModel;
    private @Nullable ModuleEffectiveStatement currentModule;
    private int groupingDepth;

    private SchemaInferenceStack(SchemaInferenceStack source) {
        this.deque = source.deque.clone();
        this.effectiveModel = source.effectiveModel;
        this.currentModule = source.currentModule;
        this.groupingDepth = source.groupingDepth;
    }

    public SchemaInferenceStack(EffectiveModelContext effectiveModel) {
        this.deque = new ArrayDeque();
        this.effectiveModel = Objects.requireNonNull(effectiveModel);
    }

    public EffectiveModelContext getEffectiveModelContext() {
        return this.effectiveModel;
    }

    public @NonNull SchemaInferenceStack copy() {
        return new SchemaInferenceStack(this);
    }

    public boolean isEmpty() {
        return this.deque.isEmpty();
    }

    public @NonNull EffectiveStatement<QName, ?> currentStatement() {
        return SchemaInferenceStack.checkNonNullState(this.deque.peekFirst());
    }

    public @NonNull ModuleEffectiveStatement currentModule() {
        return SchemaInferenceStack.checkNonNullState(this.currentModule);
    }

    public boolean inInstantiatedContext() {
        return this.groupingDepth == 0 && !this.deque.isEmpty();
    }

    public void clear() {
        this.deque.clear();
        this.currentModule = null;
        this.groupingDepth = 0;
    }

    public @NonNull GroupingEffectiveStatement enterGrouping(QName nodeIdentifier) {
        return this.pushGrouping(Objects.requireNonNull(nodeIdentifier));
    }

    public @NonNull SchemaTreeEffectiveStatement<?> enterSchemaTree(QName nodeIdentifier) {
        return this.pushSchema(Objects.requireNonNull(nodeIdentifier));
    }

    public @NonNull EffectiveStatement<QName, ?> exit() {
        EffectiveStatement<QName, ?> prev = this.deque.pop();
        if (prev instanceof GroupingEffectiveStatement) {
            --this.groupingDepth;
        }
        if (this.deque.isEmpty()) {
            this.currentModule = null;
        }
        return prev;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull SchemaNodeIdentifier.Absolute toSchemaNodeIdentifier() {
        Preconditions.checkState((boolean)this.inInstantiatedContext(), (String)"Cannot convert uninstantiated context %s", (Object)this);
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)this.deque.size());
        this.deque.descendingIterator().forEachRemaining(stmt -> builder.add((Object)((QName)stmt.argument())));
        return SchemaNodeIdentifier.Absolute.of((Collection)builder.build());
    }

    @Deprecated
    public @NonNull SchemaPath toSchemaPath() {
        SchemaPath ret = SchemaPath.ROOT;
        Iterator<EffectiveStatement<QName, ?>> it = this.deque.descendingIterator();
        while (it.hasNext()) {
            ret = ret.createChild((QName)it.next().argument());
        }
        return ret;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("stack", this.deque).toString();
    }

    private @NonNull GroupingEffectiveStatement pushGrouping(@NonNull QName nodeIdentifier) {
        EffectiveStatement<QName, ?> parent = this.deque.peekFirst();
        return parent != null ? this.pushGrouping(parent, nodeIdentifier) : this.pushFirstGrouping(nodeIdentifier);
    }

    private @NonNull GroupingEffectiveStatement pushGrouping(@NonNull EffectiveStatement<?, ?> parent, @NonNull QName nodeIdentifier) {
        GroupingEffectiveStatement ret = parent.streamEffectiveSubstatements(GroupingEffectiveStatement.class).filter(stmt -> nodeIdentifier.equals(stmt.argument())).findFirst().orElseThrow(() -> new IllegalArgumentException("Grouping " + nodeIdentifier + " not present"));
        this.deque.push((EffectiveStatement<QName, ?>)ret);
        ++this.groupingDepth;
        return ret;
    }

    private @NonNull GroupingEffectiveStatement pushFirstGrouping(@NonNull QName nodeIdentifier) {
        ModuleEffectiveStatement module = this.getModule(nodeIdentifier);
        GroupingEffectiveStatement ret = this.pushGrouping((EffectiveStatement<?, ?>)module, nodeIdentifier);
        this.currentModule = module;
        return ret;
    }

    private @NonNull SchemaTreeEffectiveStatement<?> pushSchema(@NonNull QName nodeIdentifier) {
        EffectiveStatement<QName, ?> parent = this.deque.peekFirst();
        return parent != null ? this.pushSchema(parent, nodeIdentifier) : this.pushFirstSchema(nodeIdentifier);
    }

    private @NonNull SchemaTreeEffectiveStatement<?> pushSchema(EffectiveStatement<QName, ?> parent, @NonNull QName nodeIdentifier) {
        Preconditions.checkState((boolean)(parent instanceof SchemaTreeAwareEffectiveStatement), (String)"Cannot descend schema tree at %s", parent);
        return this.pushSchema((SchemaTreeAwareEffectiveStatement)parent, nodeIdentifier);
    }

    private @NonNull SchemaTreeEffectiveStatement<?> pushSchema(@NonNull SchemaTreeAwareEffectiveStatement<?, ?> parent, @NonNull QName nodeIdentifier) {
        SchemaTreeEffectiveStatement ret = (SchemaTreeEffectiveStatement)parent.findSchemaTreeNode(nodeIdentifier).orElseThrow(() -> new IllegalArgumentException("Schema tree child " + nodeIdentifier + " not present"));
        this.deque.push((EffectiveStatement<QName, ?>)ret);
        return ret;
    }

    private @NonNull SchemaTreeEffectiveStatement<?> pushFirstSchema(@NonNull QName nodeIdentifier) {
        ModuleEffectiveStatement module = this.getModule(nodeIdentifier);
        SchemaTreeEffectiveStatement<?> ret = this.pushSchema((SchemaTreeAwareEffectiveStatement<?, ?>)module, nodeIdentifier);
        this.currentModule = module;
        return ret;
    }

    private @NonNull ModuleEffectiveStatement getModule(@NonNull QName nodeIdentifier) {
        ModuleEffectiveStatement module = (ModuleEffectiveStatement)this.effectiveModel.getModuleStatements().get(nodeIdentifier.getModule());
        Preconditions.checkArgument((module != null ? 1 : 0) != 0, (String)"Module for %s not found", (Object)nodeIdentifier);
        return module;
    }

    private static <T> @NonNull T checkNonNullState(@Nullable T obj) {
        if (obj == null) {
            throw new IllegalStateException("Cannot execute on empty stack");
        }
        return obj;
    }
}

