/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.util;

import com.google.common.annotations.Beta;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.CaseSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ContainerLike;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DerivableSchemaNode;
import org.opendaylight.yangtools.yang.model.api.GroupingDefinition;
import org.opendaylight.yangtools.yang.model.api.InputSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.NotificationDefinition;
import org.opendaylight.yangtools.yang.model.api.OutputSchemaNode;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.util.DataNodeAggregator;

public final class SchemaNodeUtils {
    private SchemaNodeUtils() {
    }

    public static Optional<SchemaNode> getOriginalIfPossible(SchemaNode node) {
        if (node instanceof DerivableSchemaNode) {
            Optional ret = ((DerivableSchemaNode)node).getOriginal();
            return ret;
        }
        return Optional.empty();
    }

    public static SchemaNode getRootOriginalIfPossible(SchemaNode data) {
        Optional<Object> previous = Optional.empty();
        Optional<SchemaNode> next = SchemaNodeUtils.getOriginalIfPossible(data);
        while (next.isPresent()) {
            previous = next;
            next = SchemaNodeUtils.getOriginalIfPossible(next.get());
        }
        return previous.orElse(null);
    }

    public static @Nullable ContainerLike getRpcDataSchema(@NonNull RpcDefinition rpc, @NonNull QName qname) {
        Objects.requireNonNull(rpc, "Rpc Schema must not be null");
        switch (Objects.requireNonNull(qname, "QName must not be null").getLocalName()) {
            case "input": {
                return rpc.getInput();
            }
            case "output": {
                return rpc.getOutput();
            }
        }
        throw new IllegalArgumentException("Supplied qname " + qname + " does not represent rpc input or output.");
    }

    @Beta
    public static @NonNull Collection<? extends TypeDefinition<?>> getAllTypeDefinitions(DataNodeContainer parent) {
        final ArrayList typedefs = new ArrayList();
        SchemaNodeUtils.traverse(new DataNodeAggregator(){

            @Override
            protected void addTypedefs(Collection<? extends TypeDefinition<?>> typeDefs) {
                typedefs.addAll(typeDefs);
            }
        }, Objects.requireNonNull(parent));
        return typedefs;
    }

    @Beta
    public static @NonNull Collection<? extends ContainerSchemaNode> getAllContainers(DataNodeContainer parent) {
        final ArrayList containers = new ArrayList();
        SchemaNodeUtils.traverse(new DataNodeAggregator(){

            @Override
            protected void addContainer(ContainerSchemaNode containerNode) {
                containers.add(containerNode);
            }
        }, Objects.requireNonNull(parent));
        return containers;
    }

    @Beta
    public static void traverse(@NonNull DataNodeAggregator aggregator, DataNodeContainer dataNode) {
        if (dataNode == null) {
            return;
        }
        for (DataSchemaNode childNode : dataNode.getChildNodes()) {
            if (childNode.isAugmenting()) continue;
            aggregator.addChild(childNode);
            if (childNode instanceof ContainerSchemaNode) {
                ContainerSchemaNode containerNode = (ContainerSchemaNode)childNode;
                aggregator.addContainer(containerNode);
                SchemaNodeUtils.traverse(aggregator, (DataNodeContainer)containerNode);
                continue;
            }
            if (childNode instanceof ListSchemaNode) {
                ListSchemaNode list = (ListSchemaNode)childNode;
                aggregator.addList(list);
                SchemaNodeUtils.traverse(aggregator, (DataNodeContainer)list);
                continue;
            }
            if (!(childNode instanceof ChoiceSchemaNode)) continue;
            ChoiceSchemaNode choiceNode = (ChoiceSchemaNode)childNode;
            aggregator.addChoice(choiceNode);
            for (CaseSchemaNode caseNode : choiceNode.getCases()) {
                SchemaNodeUtils.traverse(aggregator, (DataNodeContainer)caseNode);
            }
        }
        aggregator.addTypedefs(dataNode.getTypeDefinitions());
        SchemaNodeUtils.traverseModule(aggregator, dataNode);
        SchemaNodeUtils.traverseGroupings(aggregator, dataNode);
    }

    private static void traverseModule(DataNodeAggregator aggregator, DataNodeContainer dataNode) {
        if (!(dataNode instanceof Module)) {
            return;
        }
        Module module = (Module)dataNode;
        for (NotificationDefinition notificationDefinition : module.getNotifications()) {
            SchemaNodeUtils.traverse(aggregator, (DataNodeContainer)notificationDefinition);
        }
        for (RpcDefinition rpcDefinition : module.getRpcs()) {
            OutputSchemaNode output;
            aggregator.addTypedefs(rpcDefinition.getTypeDefinitions());
            InputSchemaNode input = rpcDefinition.getInput();
            if (input != null) {
                SchemaNodeUtils.traverse(aggregator, (DataNodeContainer)input);
            }
            if ((output = rpcDefinition.getOutput()) == null) continue;
            SchemaNodeUtils.traverse(aggregator, (DataNodeContainer)output);
        }
    }

    private static void traverseGroupings(DataNodeAggregator aggregator, DataNodeContainer dataNode) {
        for (GroupingDefinition grouping : dataNode.getGroupings()) {
            aggregator.addGrouping(grouping);
            SchemaNodeUtils.traverse(aggregator, (DataNodeContainer)grouping);
        }
    }
}

