/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.util.type;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.concepts.Mutable;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.api.type.BitsTypeDefinition;
import org.opendaylight.yangtools.yang.model.util.type.BitImpl;

@Beta
public final class BitBuilder
implements Builder<BitsTypeDefinition.Bit>,
Mutable {
    private final String name;
    private final Uint32 position;
    private ImmutableList<UnknownSchemaNode> unknownSchemaNodes = ImmutableList.of();
    private Status status = Status.CURRENT;
    private String description;
    private String reference;

    private BitBuilder(String name, Uint32 position) {
        this.name = Objects.requireNonNull(name);
        this.position = Objects.requireNonNull(position);
    }

    public static BitBuilder create(String name, Uint32 position) {
        return new BitBuilder(name, position);
    }

    public BitBuilder setDescription(String description) {
        this.description = description;
        return this;
    }

    public BitBuilder setReference(String reference) {
        this.reference = reference;
        return this;
    }

    public BitBuilder setStatus(Status status) {
        this.status = Objects.requireNonNull(status);
        return this;
    }

    public BitBuilder setUnknownSchemaNodes(Collection<UnknownSchemaNode> unknownSchemaNodes) {
        this.unknownSchemaNodes = ImmutableList.copyOf(unknownSchemaNodes);
        return this;
    }

    public BitBuilder setUnknownSchemaNodes(UnknownSchemaNode ... unknownSchemaNodes) {
        this.unknownSchemaNodes = ImmutableList.copyOf((Object[])unknownSchemaNodes);
        return this;
    }

    public BitsTypeDefinition.Bit build() {
        return new BitImpl(this.name, this.position, this.description, this.reference, this.status, (List<UnknownSchemaNode>)this.unknownSchemaNodes);
    }
}

