/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.util.type;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.api.type.EnumTypeDefinition;

final class EnumPairImpl
implements EnumTypeDefinition.EnumPair,
Immutable {
    private final @NonNull ImmutableList<UnknownSchemaNode> unknownSchemaNodes;
    private final String description;
    private final String reference;
    private final @NonNull Status status;
    private final @NonNull String name;
    private final int value;

    EnumPairImpl(String name, int value, String description, String reference, Status status, ImmutableList<UnknownSchemaNode> unknownSchemaNodes) {
        this.name = Objects.requireNonNull(name);
        this.value = value;
        this.description = description;
        this.reference = reference;
        this.status = Objects.requireNonNull(status);
        this.unknownSchemaNodes = Objects.requireNonNull(unknownSchemaNodes);
    }

    public Collection<? extends UnknownSchemaNode> getUnknownSchemaNodes() {
        return this.unknownSchemaNodes;
    }

    public Optional<String> getDescription() {
        return Optional.ofNullable(this.description);
    }

    public Optional<String> getReference() {
        return Optional.ofNullable(this.reference);
    }

    public Status getStatus() {
        return this.status;
    }

    public String getName() {
        return this.name;
    }

    public int getValue() {
        return this.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.unknownSchemaNodes.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + Integer.hashCode(this.value);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof EnumTypeDefinition.EnumPair)) {
            return false;
        }
        EnumTypeDefinition.EnumPair other = (EnumTypeDefinition.EnumPair)obj;
        if (!Objects.equals(this.name, other.getName())) {
            return false;
        }
        return this.value == other.getValue() && Objects.equals(this.unknownSchemaNodes, other.getUnknownSchemaNodes());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("value", this.value).toString();
    }
}

