/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.undertow.internal;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.SessionCookieConfig;
import javax.servlet.SessionTrackingMode;
import javax.servlet.descriptor.JspConfigDescriptor;
import org.ops4j.pax.web.service.undertow.internal.Context;

class ServletContextProxy
implements ServletContext {
    private AtomicReference<ServletContext> servletContextRef = new AtomicReference();
    private Context context;
    private final Object lock = new Object();

    ServletContextProxy(Context context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initServletContext() {
        try {
            Object object = this.lock;
            synchronized (object) {
                if (this.servletContextRef.get() == null) {
                    this.context.getHandler(servletContext -> this.servletContextRef.set((ServletContext)servletContext));
                }
            }
        }
        catch (ServletException e) {
            e.printStackTrace();
        }
    }

    public String getContextPath() {
        if (this.servletContextRef.get() == null) {
            this.initServletContext();
        }
        return this.servletContextRef.get().getContextPath();
    }

    public ServletContext getContext(String uripath) {
        if (this.servletContextRef.get() == null) {
            this.initServletContext();
        }
        return this.servletContextRef.get().getContext(uripath);
    }

    public int getMajorVersion() {
        if (this.servletContextRef.get() == null) {
            this.initServletContext();
        }
        return this.servletContextRef.get().getMajorVersion();
    }

    public int getMinorVersion() {
        if (this.servletContextRef.get() == null) {
            this.initServletContext();
        }
        return this.servletContextRef.get().getMinorVersion();
    }

    public int getEffectiveMajorVersion() {
        if (this.servletContextRef.get() == null) {
            this.initServletContext();
        }
        return this.servletContextRef.get().getEffectiveMajorVersion();
    }

    public int getEffectiveMinorVersion() {
        if (this.servletContextRef.get() == null) {
            this.initServletContext();
        }
        return this.servletContextRef.get().getEffectiveMinorVersion();
    }

    public String getMimeType(String file) {
        if (this.servletContextRef.get() == null) {
            this.initServletContext();
        }
        return this.servletContextRef.get().getMimeType(file);
    }

    public Set<String> getResourcePaths(String path) {
        if (this.servletContextRef.get() == null) {
            this.initServletContext();
        }
        return this.servletContextRef.get().getResourcePaths(path);
    }

    public URL getResource(String path) throws MalformedURLException {
        if (this.servletContextRef.get() == null) {
            this.initServletContext();
        }
        return this.servletContextRef.get().getResource(path);
    }

    public InputStream getResourceAsStream(String path) {
        if (this.servletContextRef.get() == null) {
            this.initServletContext();
        }
        return this.servletContextRef.get().getResourceAsStream(path);
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        if (this.servletContextRef.get() == null) {
            this.initServletContext();
        }
        return this.servletContextRef.get().getRequestDispatcher(path);
    }

    public RequestDispatcher getNamedDispatcher(String name) {
        if (this.servletContextRef.get() == null) {
            this.initServletContext();
        }
        return this.servletContextRef.get().getNamedDispatcher(name);
    }

    public Servlet getServlet(String name) throws ServletException {
        if (this.servletContextRef.get() == null) {
            this.initServletContext();
        }
        return this.servletContextRef.get().getServlet(name);
    }

    public Enumeration<Servlet> getServlets() {
        if (this.servletContextRef.get() == null) {
            this.initServletContext();
        }
        return this.servletContextRef.get().getServlets();
    }

    public Enumeration<String> getServletNames() {
        if (this.servletContextRef.get() == null) {
            this.initServletContext();
        }
        return this.servletContextRef.get().getServletNames();
    }

    public void log(String msg) {
        if (this.servletContextRef.get() == null) {
            this.initServletContext();
        }
        this.servletContextRef.get().log(msg);
    }

    public void log(Exception exception, String msg) {
        if (this.servletContextRef.get() == null) {
            this.initServletContext();
        }
        this.servletContextRef.get().log(exception, msg);
    }

    public void log(String message, Throwable throwable) {
        if (this.servletContextRef.get() == null) {
            this.initServletContext();
        }
        this.servletContextRef.get().log(message, throwable);
    }

    public String getRealPath(String path) {
        if (this.servletContextRef.get() == null) {
            this.initServletContext();
        }
        return this.servletContextRef.get().getRealPath(path);
    }

    public String getServerInfo() {
        if (this.servletContextRef.get() == null) {
            this.initServletContext();
        }
        return this.servletContextRef.get().getServerInfo();
    }

    public String getInitParameter(String name) {
        if (this.servletContextRef.get() == null) {
            this.initServletContext();
        }
        return this.servletContextRef.get().getInitParameter(name);
    }

    public Enumeration<String> getInitParameterNames() {
        if (this.servletContextRef.get() == null) {
            this.initServletContext();
        }
        return this.servletContextRef.get().getInitParameterNames();
    }

    public boolean setInitParameter(String name, String value) {
        if (this.servletContextRef.get() == null) {
            this.initServletContext();
        }
        return this.servletContextRef.get().setInitParameter(name, value);
    }

    public Object getAttribute(String name) {
        if (this.servletContextRef.get() == null) {
            this.initServletContext();
        }
        return this.servletContextRef.get().getAttribute(name);
    }

    public Enumeration<String> getAttributeNames() {
        if (this.servletContextRef.get() == null) {
            this.initServletContext();
        }
        return this.servletContextRef.get().getAttributeNames();
    }

    public void setAttribute(String name, Object object) {
        if (this.servletContextRef.get() == null) {
            this.initServletContext();
        }
        this.servletContextRef.get().setAttribute(name, object);
    }

    public void removeAttribute(String name) {
        if (this.servletContextRef.get() == null) {
            this.initServletContext();
        }
        this.servletContextRef.get().removeAttribute(name);
    }

    public String getServletContextName() {
        if (this.servletContextRef.get() == null) {
            this.initServletContext();
        }
        return this.servletContextRef.get().getServletContextName();
    }

    public ServletRegistration.Dynamic addServlet(String servletName, String className) {
        if (this.servletContextRef.get() == null) {
            this.initServletContext();
        }
        return this.servletContextRef.get().addServlet(servletName, className);
    }

    public ServletRegistration.Dynamic addServlet(String servletName, Servlet servlet) {
        if (this.servletContextRef.get() == null) {
            this.initServletContext();
        }
        return this.servletContextRef.get().addServlet(servletName, servlet);
    }

    public ServletRegistration.Dynamic addServlet(String servletName, Class<? extends Servlet> servletClass) {
        if (this.servletContextRef.get() == null) {
            this.initServletContext();
        }
        return this.servletContextRef.get().addServlet(servletName, servletClass);
    }

    public <T extends Servlet> T createServlet(Class<T> clazz) throws ServletException {
        if (this.servletContextRef.get() == null) {
            this.initServletContext();
        }
        return (T)this.servletContextRef.get().createServlet(clazz);
    }

    public ServletRegistration getServletRegistration(String servletName) {
        if (this.servletContextRef.get() == null) {
            this.initServletContext();
        }
        return this.servletContextRef.get().getServletRegistration(servletName);
    }

    public Map<String, ? extends ServletRegistration> getServletRegistrations() {
        if (this.servletContextRef.get() == null) {
            this.initServletContext();
        }
        return this.servletContextRef.get().getServletRegistrations();
    }

    public FilterRegistration.Dynamic addFilter(String filterName, String className) {
        if (this.servletContextRef.get() == null) {
            this.initServletContext();
        }
        return this.servletContextRef.get().addFilter(filterName, className);
    }

    public FilterRegistration.Dynamic addFilter(String filterName, Filter filter) {
        if (this.servletContextRef.get() == null) {
            this.initServletContext();
        }
        return this.servletContextRef.get().addFilter(filterName, filter);
    }

    public FilterRegistration.Dynamic addFilter(String filterName, Class<? extends Filter> filterClass) {
        if (this.servletContextRef.get() == null) {
            this.initServletContext();
        }
        return this.servletContextRef.get().addFilter(filterName, filterClass);
    }

    public <T extends Filter> T createFilter(Class<T> clazz) throws ServletException {
        if (this.servletContextRef.get() == null) {
            this.initServletContext();
        }
        return (T)this.servletContextRef.get().createFilter(clazz);
    }

    public FilterRegistration getFilterRegistration(String filterName) {
        if (this.servletContextRef.get() == null) {
            this.initServletContext();
        }
        return this.servletContextRef.get().getFilterRegistration(filterName);
    }

    public Map<String, ? extends FilterRegistration> getFilterRegistrations() {
        if (this.servletContextRef.get() == null) {
            this.initServletContext();
        }
        return this.servletContextRef.get().getFilterRegistrations();
    }

    public SessionCookieConfig getSessionCookieConfig() {
        if (this.servletContextRef.get() == null) {
            this.initServletContext();
        }
        return this.servletContextRef.get().getSessionCookieConfig();
    }

    public void setSessionTrackingModes(Set<SessionTrackingMode> sessionTrackingModes) {
        if (this.servletContextRef.get() == null) {
            this.initServletContext();
        }
        this.servletContextRef.get().setSessionTrackingModes(sessionTrackingModes);
    }

    public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
        if (this.servletContextRef.get() == null) {
            this.initServletContext();
        }
        return this.servletContextRef.get().getDefaultSessionTrackingModes();
    }

    public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
        if (this.servletContextRef.get() == null) {
            this.initServletContext();
        }
        return this.servletContextRef.get().getEffectiveSessionTrackingModes();
    }

    public void addListener(String className) {
        if (this.servletContextRef.get() == null) {
            this.initServletContext();
        }
        this.servletContextRef.get().addListener(className);
    }

    public <T extends EventListener> void addListener(T t) {
        if (this.servletContextRef.get() == null) {
            this.initServletContext();
        }
        this.servletContextRef.get().addListener(t);
    }

    public void addListener(Class<? extends EventListener> listenerClass) {
        if (this.servletContextRef.get() == null) {
            this.initServletContext();
        }
        this.servletContextRef.get().addListener(listenerClass);
    }

    public <T extends EventListener> T createListener(Class<T> clazz) throws ServletException {
        if (this.servletContextRef.get() == null) {
            this.initServletContext();
        }
        return (T)this.servletContextRef.get().createListener(clazz);
    }

    public JspConfigDescriptor getJspConfigDescriptor() {
        if (this.servletContextRef.get() == null) {
            this.initServletContext();
        }
        return this.servletContextRef.get().getJspConfigDescriptor();
    }

    public ClassLoader getClassLoader() {
        if (this.servletContextRef.get() == null) {
            this.initServletContext();
        }
        return this.servletContextRef.get().getClassLoader();
    }

    public void declareRoles(String ... roleNames) {
        if (this.servletContextRef.get() == null) {
            this.initServletContext();
        }
        this.servletContextRef.get().declareRoles(roleNames);
    }

    public String getVirtualServerName() {
        if (this.servletContextRef.get() == null) {
            this.initServletContext();
        }
        return this.servletContextRef.get().getVirtualServerName();
    }

    public ServletRegistration.Dynamic addJspFile(String servletName, String jspFile) {
        if (this.servletContextRef.get() == null) {
            this.initServletContext();
        }
        return this.servletContextRef.get().addJspFile(servletName, jspFile);
    }

    public int getSessionTimeout() {
        if (this.servletContextRef.get() == null) {
            this.initServletContext();
        }
        return this.servletContextRef.get().getSessionTimeout();
    }

    public void setSessionTimeout(int sessionTimeout) {
        if (this.servletContextRef.get() == null) {
            this.initServletContext();
        }
        this.servletContextRef.get().setSessionTimeout(sessionTimeout);
    }

    public String getRequestCharacterEncoding() {
        if (this.servletContextRef.get() == null) {
            this.initServletContext();
        }
        return this.servletContextRef.get().getRequestCharacterEncoding();
    }

    public void setRequestCharacterEncoding(String encoding) {
        if (this.servletContextRef.get() == null) {
            this.initServletContext();
        }
        this.servletContextRef.get().setRequestCharacterEncoding(encoding);
    }

    public String getResponseCharacterEncoding() {
        if (this.servletContextRef.get() == null) {
            this.initServletContext();
        }
        return this.servletContextRef.get().getResponseCharacterEncoding();
    }

    public void setResponseCharacterEncoding(String encoding) {
        if (this.servletContextRef.get() == null) {
            this.initServletContext();
        }
        this.servletContextRef.get().setResponseCharacterEncoding(encoding);
    }
}

