/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.undertow.internal.configuration.model;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlType(name="io-subsystemType", namespace="urn:jboss:domain:io:3.0", propOrder={"workers", "bufferPools"})
public class IoSubsystem {
    @XmlElement(name="worker")
    private List<Worker> workers = new ArrayList<Worker>();
    @XmlElement(name="buffer-pool")
    private List<BufferPool> bufferPools = new ArrayList<BufferPool>();

    public List<Worker> getWorkers() {
        return this.workers;
    }

    public List<BufferPool> getBuferPools() {
        return this.bufferPools;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        sb.append("\n\t\tworkers: " + this.workers);
        sb.append("\n\t\tbuffer pools: " + this.bufferPools);
        sb.append("\n\t}");
        return sb.toString();
    }

    @XmlType(name="bufferPoolType", namespace="urn:jboss:domain:io:3.0")
    public static class BufferPool {
        @XmlAttribute
        private String name;
        @XmlAttribute(name="buffer-size")
        private Integer bufferSize;
        @XmlAttribute(name="direct-buffers")
        private Boolean directBuffers;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Integer getBufferSize() {
            return this.bufferSize;
        }

        public void setBufferSize(Integer bufferSize) {
            this.bufferSize = bufferSize;
        }

        public Boolean getDirectBuffers() {
            return this.directBuffers;
        }

        public void setDirectBuffers(Boolean directBuffers) {
            this.directBuffers = directBuffers;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("{ ");
            sb.append("name: ").append(this.name);
            sb.append(", buffer size: ").append(this.bufferSize);
            sb.append(", use direct buffers: ").append(this.directBuffers);
            sb.append(" }");
            return sb.toString();
        }
    }

    @XmlType(name="workerType", namespace="urn:jboss:domain:io:3.0")
    public static class Worker {
        @XmlAttribute
        private String name;
        @XmlAttribute(name="io-threads")
        private int ioThreads = Math.max(Runtime.getRuntime().availableProcessors(), 2);
        @XmlAttribute(name="task-keepalive")
        private int taskKeepalive = 60000;
        @XmlAttribute(name="task-core-threads")
        private int taskCoreThreads = Math.max(Runtime.getRuntime().availableProcessors(), 2) * 8;
        @XmlAttribute(name="task-max-threads")
        private int taskMaxThreads = Math.max(Runtime.getRuntime().availableProcessors(), 2) * 8;
        @XmlAttribute(name="stack-size")
        private long stackSize = 0L;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getIoThreads() {
            return this.ioThreads;
        }

        public void setIoThreads(int ioThreads) {
            this.ioThreads = ioThreads;
        }

        public int getTaskKeepalive() {
            return this.taskKeepalive;
        }

        public void setTaskKeepalive(int taskKeepalive) {
            this.taskKeepalive = taskKeepalive;
        }

        public int getTaskCoreThreads() {
            return this.taskCoreThreads;
        }

        public void setTaskCoreThreads(int taskCoreThreads) {
            this.taskCoreThreads = taskCoreThreads;
        }

        public int getTaskMaxThreads() {
            return this.taskMaxThreads;
        }

        public void setTaskMaxThreads(int taskMaxThreads) {
            this.taskMaxThreads = taskMaxThreads;
        }

        public long getStackSize() {
            return this.stackSize;
        }

        public void setStackSize(long stackSize) {
            this.stackSize = stackSize;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("{ ");
            sb.append("name: ").append(this.name);
            sb.append(", io threads: ").append(this.ioThreads);
            sb.append(", task max threads: ").append(this.taskMaxThreads);
            sb.append(", task core threads: ").append(this.taskCoreThreads);
            sb.append(", task keep alive: ").append(this.taskKeepalive);
            sb.append(", stack size: ").append(this.stackSize);
            sb.append(" }");
            return sb.toString();
        }
    }
}

