/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.rfc7952.parser;

import com.google.common.collect.ImmutableList;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.rfc7952.model.api.AnnotationEffectiveStatement;
import org.opendaylight.yangtools.rfc7952.model.api.AnnotationSchemaNode;
import org.opendaylight.yangtools.rfc7952.model.api.AnnotationStatement;
import org.opendaylight.yangtools.rfc7952.model.api.MetadataStatements;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.TypeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.UnitsStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.UnknownStatement;
import org.opendaylight.yangtools.yang.model.util.type.ConcreteTypeBuilder;
import org.opendaylight.yangtools.yang.model.util.type.ConcreteTypes;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.AbstractDeclaredStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.BaseStatementSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.UnknownEffectiveStatementBase;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;

public final class AnnotationStatementSupport
extends BaseStatementSupport<QName, AnnotationStatement, AnnotationEffectiveStatement> {
    private static final AnnotationStatementSupport INSTANCE = new AnnotationStatementSupport((StatementDefinition)MetadataStatements.ANNOTATION);
    private final SubstatementValidator validator;

    AnnotationStatementSupport(StatementDefinition definition) {
        super(definition);
        this.validator = SubstatementValidator.builder((StatementDefinition)definition).addMandatory((StatementDefinition)YangStmtMapping.TYPE).addOptional((StatementDefinition)YangStmtMapping.DESCRIPTION).addAny((StatementDefinition)YangStmtMapping.IF_FEATURE).addOptional((StatementDefinition)YangStmtMapping.REFERENCE).addOptional((StatementDefinition)YangStmtMapping.STATUS).addOptional((StatementDefinition)YangStmtMapping.UNITS).build();
    }

    public static AnnotationStatementSupport getInstance() {
        return INSTANCE;
    }

    public QName parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        return StmtContextUtils.parseIdentifier(ctx, (String)value);
    }

    public void onStatementAdded(StmtContext.Mutable<QName, AnnotationStatement, AnnotationEffectiveStatement> stmt) {
        StatementDefinition parentDef = stmt.coerceParentContext().getPublicDefinition();
        SourceException.throwIf((YangStmtMapping.MODULE != parentDef && YangStmtMapping.SUBMODULE != parentDef ? 1 : 0) != 0, (StatementSourceReference)stmt.getStatementSourceReference(), (String)"Annotations may only be defined at root of either a module or a submodule", (Object[])new Object[0]);
    }

    protected SubstatementValidator getSubstatementValidator() {
        return this.validator;
    }

    protected AnnotationStatement createDeclared(StmtContext<QName, AnnotationStatement, ?> ctx, ImmutableList<? extends DeclaredStatement<?>> substatements) {
        return new Declared((QName)ctx.coerceStatementArgument(), substatements);
    }

    protected AnnotationStatement createEmptyDeclared(StmtContext<QName, AnnotationStatement, ?> ctx) {
        return this.createDeclared(ctx, (ImmutableList<? extends DeclaredStatement<?>>)ImmutableList.of());
    }

    protected AnnotationEffectiveStatement createEffective(StmtContext<QName, AnnotationStatement, AnnotationEffectiveStatement> ctx, AnnotationStatement declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return new Effective(declared, substatements, ctx);
    }

    protected AnnotationEffectiveStatement createEmptyEffective(StmtContext<QName, AnnotationStatement, AnnotationEffectiveStatement> ctx, AnnotationStatement declared) {
        return this.createEffective(ctx, declared, ImmutableList.of());
    }

    private static final class Effective
    extends UnknownEffectiveStatementBase<QName, AnnotationStatement>
    implements AnnotationEffectiveStatement,
    AnnotationSchemaNode {
        private final @NonNull TypeDefinition<?> type;
        private final @NonNull SchemaPath path;

        Effective(AnnotationStatement declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements, StmtContext<QName, AnnotationStatement, ?> ctx) {
            super((Object)((QName)ctx.coerceStatementArgument()), (UnknownStatement)declared, substatements, ctx);
            this.path = ((SchemaPath)ctx.coerceParentContext().getSchemaPath().get()).createChild((QName)this.argument());
            TypeEffectiveStatement typeStmt = (TypeEffectiveStatement)SourceException.throwIfNull((Object)((TypeEffectiveStatement)this.firstSubstatementOfType(TypeEffectiveStatement.class)), (StatementSourceReference)ctx.getStatementSourceReference(), (String)"AnnotationStatementSupport %s is missing a 'type' statement", (Object[])new Object[]{this.argument()});
            ConcreteTypeBuilder builder = ConcreteTypes.concreteTypeBuilder((TypeDefinition)typeStmt.getTypeDefinition(), (SchemaPath)this.path);
            StmtContext unitsStmt = StmtContextUtils.findFirstEffectiveSubstatement(ctx, UnitsStatement.class);
            if (unitsStmt != null) {
                builder.setUnits((String)unitsStmt.getStatementArgument());
            }
            this.type = builder.build();
        }

        public QName getQName() {
            return this.path.getLastComponent();
        }

        @Deprecated
        public SchemaPath getPath() {
            return this.path;
        }

        public TypeDefinition<?> getType() {
            return this.type;
        }

        public TypeDefinition<?> getTypeDefinition() {
            return this.type;
        }

        public AnnotationEffectiveStatement asEffectiveStatement() {
            return this;
        }
    }

    private static final class Declared
    extends AbstractDeclaredStatement.WithQNameArgument.WithSubstatements
    implements AnnotationStatement {
        Declared(QName argument, ImmutableList<? extends DeclaredStatement<?>> substatements) {
            super(argument, substatements);
        }
    }
}

