/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.spi;

import com.google.common.annotations.Beta;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaTreeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.UnknownStatement;
import org.opendaylight.yangtools.yang.parser.spi.meta.NamespaceBehaviour;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;

@Beta
public final class SchemaTreeNamespace<D extends DeclaredStatement<QName>, E extends SchemaTreeEffectiveStatement<D>>
extends NamespaceBehaviour<QName, StmtContext<?, D, E>, SchemaTreeNamespace<D, E>>
implements StatementNamespace<QName, D, E> {
    private static final @NonNull SchemaTreeNamespace<?, ?> INSTANCE = new SchemaTreeNamespace();

    private SchemaTreeNamespace() {
        super(SchemaTreeNamespace.class);
    }

    public static <D extends DeclaredStatement<QName>, E extends SchemaTreeEffectiveStatement<D>> @NonNull SchemaTreeNamespace<D, E> getInstance() {
        return INSTANCE;
    }

    @Override
    public StmtContext<?, D, E> get(QName key) {
        return null;
    }

    @Override
    public StmtContext<?, D, E> getFrom(NamespaceBehaviour.NamespaceStorageNode storage, QName key) {
        NamespaceBehaviour.NamespaceStorageNode storageNode = SchemaTreeNamespace.globalOrStatementSpecific(storage);
        StmtContext<?, D, E> existing = (StmtContext<?, D, E>)storageNode.getFromLocalStorage((Class)this.getIdentifier(), key);
        return existing != null ? existing : SchemaTreeNamespace.requestFrom(storageNode, key);
    }

    private static <D extends DeclaredStatement<QName>, E extends EffectiveStatement<QName, D>> StmtContext<?, D, E> requestFrom(NamespaceBehaviour.NamespaceStorageNode storageNode, QName key) {
        return storageNode instanceof NamespaceBehaviour.OnDemandSchemaTreeStorageNode ? ((NamespaceBehaviour.OnDemandSchemaTreeStorageNode)storageNode).requestSchemaTreeChild(key) : null;
    }

    @Override
    public Map<QName, StmtContext<?, D, E>> getAllFrom(NamespaceBehaviour.NamespaceStorageNode storage) {
        return null;
    }

    @Override
    public void addTo(NamespaceBehaviour.NamespaceStorageNode storage, QName key, StmtContext<?, D, E> value) {
        StmtContext<?, D, E> prev = SchemaTreeNamespace.globalOrStatementSpecific(storage).putToLocalStorageIfAbsent(SchemaTreeNamespace.class, key, value);
        if (prev != null) {
            throw new SourceException(value.getStatementSourceReference(), "Error in module '%s': cannot add '%s'. Node name collision: '%s' already declared at %s", value.getRoot().rawStatementArgument(), key, prev.getStatementArgument(), prev.getStatementSourceReference());
        }
    }

    public static Optional<StmtContext<?, ?, ?>> findNode(StmtContext<?, ?, ?> root, SchemaNodeIdentifier identifier) {
        Iterator iterator = identifier.getNodeIdentifiers().iterator();
        if (!iterator.hasNext()) {
            return Optional.of(root);
        }
        QName nextPath = (QName)iterator.next();
        StmtContext current = (StmtContext)root.getFromNamespace(SchemaTreeNamespace.class, nextPath);
        if (current == null) {
            return Optional.ofNullable(SchemaTreeNamespace.tryToFindUnknownStatement(nextPath.getLocalName(), root));
        }
        while (current != null && iterator.hasNext()) {
            nextPath = (QName)iterator.next();
            StmtContext nextNodeCtx = (StmtContext)current.getFromNamespace(SchemaTreeNamespace.class, nextPath);
            if (nextNodeCtx == null) {
                return Optional.ofNullable(SchemaTreeNamespace.tryToFindUnknownStatement(nextPath.getLocalName(), current));
            }
            current = nextNodeCtx;
        }
        return Optional.ofNullable(current);
    }

    private static StmtContext<?, ?, ?> tryToFindUnknownStatement(String localName, StmtContext<?, ?, ?> current) {
        Collection unknownSubstatements = StmtContextUtils.findAllSubstatements(current, UnknownStatement.class);
        for (StmtContext unknownSubstatement : unknownSubstatements) {
            if (!localName.equals(unknownSubstatement.rawStatementArgument())) continue;
            return unknownSubstatement;
        }
        return null;
    }

    private static NamespaceBehaviour.NamespaceStorageNode globalOrStatementSpecific(NamespaceBehaviour.NamespaceStorageNode storage) {
        NamespaceBehaviour.NamespaceStorageNode current = storage;
        while (!SchemaTreeNamespace.isLocalOrGlobal(current.getStorageNodeType())) {
            current = current.getParentNamespaceStorage();
        }
        return current;
    }

    private static boolean isLocalOrGlobal(NamespaceBehaviour.StorageNodeType type) {
        return type == NamespaceBehaviour.StorageNodeType.STATEMENT_LOCAL || type == NamespaceBehaviour.StorageNodeType.GLOBAL;
    }
}

