/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.spi.meta;

import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.meta.StatementSource;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;

public abstract class AbstractDeclaredStatement<A>
implements DeclaredStatement<A> {
    private final @NonNull ImmutableList<? extends DeclaredStatement<?>> substatements;
    private final @NonNull StatementDefinition definition;
    private final @NonNull StatementSource source;
    private final A argument;
    private final String rawArgument;

    protected AbstractDeclaredStatement(StmtContext<A, ?, ?> context) {
        this.rawArgument = context.rawStatementArgument();
        this.argument = context.getStatementArgument();
        this.source = context.getStatementSource();
        this.definition = context.getPublicDefinition();
        this.substatements = ImmutableList.copyOf((Collection)Collections2.transform(context.declaredSubstatements(), StmtContext::buildDeclared));
    }

    public String rawArgument() {
        return this.rawArgument;
    }

    public A argument() {
        return this.argument;
    }

    public StatementDefinition statementDefinition() {
        return this.definition;
    }

    public Collection<? extends DeclaredStatement<?>> declaredSubstatements() {
        return this.substatements;
    }

    public StatementSource getStatementSource() {
        return this.source;
    }
}

