/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.spi.meta;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;

@NonNullByDefault
public enum ModelProcessingPhase {
    INIT,
    SOURCE_PRE_LINKAGE(INIT),
    SOURCE_LINKAGE(SOURCE_PRE_LINKAGE),
    STATEMENT_DEFINITION(SOURCE_LINKAGE),
    FULL_DECLARATION(STATEMENT_DEFINITION),
    EFFECTIVE_MODEL(FULL_DECLARATION);

    private final @Nullable ModelProcessingPhase previousPhase;

    @SuppressFBWarnings(value={"NP_STORE_INTO_NONNULL_FIELD"}, justification="https://github.com/spotbugs/spotbugs/issues/743")
    private ModelProcessingPhase() {
        this.previousPhase = null;
    }

    private ModelProcessingPhase(ModelProcessingPhase previousPhase) {
        this.previousPhase = Objects.requireNonNull(previousPhase);
    }

    public @Nullable ModelProcessingPhase getPreviousPhase() {
        return this.previousPhase;
    }

    public boolean isCompletedBy(@Nullable ModelProcessingPhase other) {
        return other != null && this.ordinal() <= other.ordinal();
    }
}

