/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.spi.meta;

import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;

public final class StmtContextDefaults {
    private StmtContextDefaults() {
    }

    public static <A, E extends EffectiveStatement<A, ?>> @NonNull Optional<A> findSubstatementArgument(@NonNull StmtContext<?, ?, ?> stmt, @NonNull Class<E> type) {
        return stmt.allSubstatementsStream().filter(ctx -> ctx.isSupportedToBuildEffective() && ctx.producesEffective(type)).findAny().map(ctx -> ctx.coerceStatementArgument());
    }

    public static boolean hasSubstatement(@NonNull StmtContext<?, ?, ?> stmt, @NonNull Class<? extends EffectiveStatement<?, ?>> type) {
        return stmt.allSubstatementsStream().anyMatch(ctx -> ctx.isSupportedToBuildEffective() && ctx.producesEffective(type));
    }
}

