/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.spi.meta;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.common.YangVersion;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.BelongsToStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.KeyStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.LeafStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.MandatoryStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.MinElementsStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ModuleStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.PresenceEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.RevisionStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SubmoduleStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.UnknownStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.UnrecognizedStatement;
import org.opendaylight.yangtools.yang.parser.spi.meta.CopyType;
import org.opendaylight.yangtools.yang.parser.spi.meta.InferenceException;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.source.BelongsToPrefixToModuleName;
import org.opendaylight.yangtools.yang.parser.spi.source.ImportPrefixToModuleCtx;
import org.opendaylight.yangtools.yang.parser.spi.source.ModuleCtxToModuleQName;
import org.opendaylight.yangtools.yang.parser.spi.source.ModuleNameToModuleQName;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;

public final class StmtContextUtils {
    private StmtContextUtils() {
    }

    public static <A, D extends DeclaredStatement<A>> A firstAttributeOf(Iterable<? extends StmtContext<?, ?, ?>> contexts, Class<D> declaredType) {
        for (StmtContext<?, ?, ?> ctx : contexts) {
            if (!ctx.producesDeclared(declaredType)) continue;
            return (A)ctx.getStatementArgument();
        }
        return null;
    }

    public static <A, D extends DeclaredStatement<A>> A firstAttributeOf(StmtContext<?, ?, ?> ctx, Class<D> declaredType) {
        return ctx.producesDeclared(declaredType) ? (A)ctx.getStatementArgument() : null;
    }

    public static <A, D extends DeclaredStatement<A>> A firstSubstatementAttributeOf(StmtContext<?, ?, ?> ctx, Class<D> declaredType) {
        return StmtContextUtils.firstAttributeOf(ctx.allSubstatements(), declaredType);
    }

    public static <A, D extends DeclaredStatement<A>> StmtContext<A, ?, ?> findFirstDeclaredSubstatement(StmtContext<?, ?, ?> stmtContext, Class<D> declaredType) {
        for (StmtContext<?, ?, ?> subStmtContext : stmtContext.declaredSubstatements()) {
            if (!subStmtContext.producesDeclared(declaredType)) continue;
            return subStmtContext;
        }
        return null;
    }

    @SafeVarargs
    public static StmtContext<?, ?, ?> findFirstDeclaredSubstatement(StmtContext<?, ?, ?> stmtContext, int startIndex, Class<? extends DeclaredStatement<?>> ... types) {
        if (startIndex >= types.length) {
            return null;
        }
        for (StmtContext<?, ?, ?> subStmtContext : stmtContext.declaredSubstatements()) {
            if (!StmtContextUtils.producesDeclared(subStmtContext, types[startIndex])) continue;
            return startIndex + 1 == types.length ? subStmtContext : StmtContextUtils.findFirstDeclaredSubstatement(subStmtContext, ++startIndex, types);
        }
        return null;
    }

    public static <A, D extends DeclaredStatement<A>> Collection<StmtContext<A, D, ?>> findAllDeclaredSubstatements(StmtContext<?, ?, ?> stmtContext, Class<D> declaredType) {
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        for (StmtContext<?, ?, ?> subStmtContext : stmtContext.declaredSubstatements()) {
            if (!subStmtContext.producesDeclared(declaredType)) continue;
            listBuilder.add(subStmtContext);
        }
        return listBuilder.build();
    }

    public static <A, D extends DeclaredStatement<A>> Collection<StmtContext<A, D, ?>> findAllEffectiveSubstatements(StmtContext<?, ?, ?> stmtContext, Class<D> type) {
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        for (StmtContext<?, ?, ?> subStmtContext : stmtContext.effectiveSubstatements()) {
            if (!subStmtContext.producesDeclared(type)) continue;
            listBuilder.add(subStmtContext);
        }
        return listBuilder.build();
    }

    public static <A, D extends DeclaredStatement<A>> Collection<StmtContext<A, D, ?>> findAllSubstatements(StmtContext<?, ?, ?> stmtContext, Class<D> type) {
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        listBuilder.addAll(StmtContextUtils.findAllDeclaredSubstatements(stmtContext, type));
        listBuilder.addAll(StmtContextUtils.findAllEffectiveSubstatements(stmtContext, type));
        return listBuilder.build();
    }

    public static <A, D extends DeclaredStatement<A>> StmtContext<A, ?, ?> findFirstEffectiveSubstatement(StmtContext<?, ?, ?> stmtContext, Class<D> declaredType) {
        for (StmtContext<?, ?, ?> subStmtContext : stmtContext.effectiveSubstatements()) {
            if (!subStmtContext.producesDeclared(declaredType)) continue;
            return subStmtContext;
        }
        return null;
    }

    @Deprecated(forRemoval=true)
    public static <A, D extends DeclaredStatement<A>> StmtContext<A, ?, ?> findFirstSubstatement(StmtContext<?, ?, ?> stmtContext, Class<D> declaredType) {
        StmtContext<A, ?, ?> effectiveSubstatement = StmtContextUtils.findFirstEffectiveSubstatement(stmtContext, declaredType);
        return effectiveSubstatement != null ? effectiveSubstatement : StmtContextUtils.findFirstDeclaredSubstatement(stmtContext, declaredType);
    }

    public static <D extends DeclaredStatement<?>> StmtContext<?, ?, ?> findFirstDeclaredSubstatementOnSublevel(StmtContext<?, ?, ?> stmtContext, Class<D> declaredType, int sublevel) {
        for (StmtContext<?, ?, ?> subStmtContext : stmtContext.declaredSubstatements()) {
            StmtContext<?, ?, ?> result;
            if (sublevel == 1 && StmtContextUtils.producesDeclared(subStmtContext, declaredType)) {
                return subStmtContext;
            }
            if (sublevel <= 1 || (result = StmtContextUtils.findFirstDeclaredSubstatementOnSublevel(subStmtContext, declaredType, --sublevel)) == null) continue;
            return result;
        }
        return null;
    }

    public static <D extends DeclaredStatement<?>> StmtContext<?, ?, ?> findDeepFirstDeclaredSubstatement(StmtContext<?, ?, ?> stmtContext, Class<D> declaredType) {
        for (StmtContext<?, ?, ?> subStmtContext : stmtContext.declaredSubstatements()) {
            if (StmtContextUtils.producesDeclared(subStmtContext, declaredType)) {
                return subStmtContext;
            }
            StmtContext<?, ?, ?> result = StmtContextUtils.findDeepFirstDeclaredSubstatement(subStmtContext, declaredType);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Deprecated(forRemoval=true)
    public static boolean producesDeclared(StmtContext<?, ?, ?> ctx, Class<? extends DeclaredStatement<?>> type) {
        return type.isAssignableFrom(ctx.getPublicDefinition().getDeclaredRepresentationClass());
    }

    public static boolean isInExtensionBody(StmtContext<?, ?, ?> stmtCtx) {
        StmtContext<?, ?, ?> current = stmtCtx;
        StmtContext<?, ?, ?> parent;
        while ((parent = current.coerceParentContext()).getParentContext() != null) {
            if (StmtContextUtils.isUnknownStatement(parent)) {
                return true;
            }
            current = parent;
        }
        return false;
    }

    public static boolean isUnknownStatement(StmtContext<?, ?, ?> stmtCtx) {
        return UnknownStatement.class.isAssignableFrom(stmtCtx.getPublicDefinition().getDeclaredRepresentationClass());
    }

    public static boolean isUnrecognizedStatement(StmtContext<?, ?, ?> stmtCtx) {
        return stmtCtx.producesDeclared(UnrecognizedStatement.class);
    }

    public static boolean checkFeatureSupport(StmtContext<?, ?, ?> stmtContext, Set<QName> supportedFeatures) {
        boolean isSupported = false;
        boolean containsIfFeature = false;
        for (StmtContext<?, ?, ?> stmt : stmtContext.declaredSubstatements()) {
            if (!YangStmtMapping.IF_FEATURE.equals((Object)stmt.getPublicDefinition())) continue;
            containsIfFeature = true;
            Predicate argument = (Predicate)stmt.coerceStatementArgument();
            if (argument.test(supportedFeatures)) {
                isSupported = true;
                continue;
            }
            isSupported = false;
            break;
        }
        return !containsIfFeature || isSupported;
    }

    public static boolean isPresenceContainer(StmtContext<?, ?, ?> stmtCtx) {
        return stmtCtx.getPublicDefinition() == YangStmtMapping.CONTAINER && StmtContextUtils.containsPresenceSubStmt(stmtCtx);
    }

    public static boolean isNonPresenceContainer(StmtContext<?, ?, ?> stmtCtx) {
        return stmtCtx.getPublicDefinition() == YangStmtMapping.CONTAINER && !StmtContextUtils.containsPresenceSubStmt(stmtCtx);
    }

    private static boolean containsPresenceSubStmt(StmtContext<?, ?, ?> stmtCtx) {
        return stmtCtx.hasSubstatement(PresenceEffectiveStatement.class);
    }

    public static boolean isMandatoryNode(StmtContext<?, ?, ?> stmtCtx) {
        if (!(stmtCtx.getPublicDefinition() instanceof YangStmtMapping)) {
            return false;
        }
        switch ((YangStmtMapping)stmtCtx.getPublicDefinition()) {
            case LEAF: 
            case CHOICE: 
            case ANYXML: {
                return Boolean.TRUE.equals(StmtContextUtils.firstSubstatementAttributeOf(stmtCtx, MandatoryStatement.class));
            }
            case LIST: 
            case LEAF_LIST: {
                Integer minElements = (Integer)StmtContextUtils.firstSubstatementAttributeOf(stmtCtx, MinElementsStatement.class);
                return minElements != null && minElements > 0;
            }
        }
        return false;
    }

    public static boolean isNotMandatoryNodeOfType(StmtContext<?, ?, ?> stmtCtx, StatementDefinition stmtDef) {
        return stmtCtx.getPublicDefinition().equals(stmtDef) && !StmtContextUtils.isMandatoryNode(stmtCtx);
    }

    public static boolean hasAncestorOfType(StmtContext<?, ?, ?> ctx, Collection<StatementDefinition> ancestorTypes) {
        Objects.requireNonNull(ancestorTypes);
        for (StmtContext<?, ?, ?> current = ctx.getParentContext(); current != null; current = current.getParentContext()) {
            if (!ancestorTypes.contains(current.getPublicDefinition())) continue;
            return true;
        }
        return false;
    }

    public static <A, D extends DeclaredStatement<A>> boolean hasAncestorOfTypeWithChildOfType(StmtContext<?, ?, ?> ctx, StatementDefinition ancestorType, StatementDefinition ancestorChildType) {
        Objects.requireNonNull(ctx);
        Objects.requireNonNull(ancestorType);
        Objects.requireNonNull(ancestorChildType);
        StmtContext<?, ?, ?> current = ctx.coerceParentContext();
        StmtContext<?, ?, ?> parent = current.getParentContext();
        while (parent != null) {
            if (ancestorType.equals(current.getPublicDefinition()) && !current.hasSubstatement(ancestorChildType.getEffectiveRepresentationClass())) {
                return false;
            }
            current = parent;
            parent = current.getParentContext();
        }
        return true;
    }

    public static boolean hasParentOfType(StmtContext<?, ?, ?> ctx, StatementDefinition parentType) {
        Objects.requireNonNull(parentType);
        StmtContext<?, ?, ?> parentContext = ctx.getParentContext();
        return parentContext != null && parentType.equals(parentContext.getPublicDefinition());
    }

    public static void validateIfFeatureAndWhenOnListKeys(StmtContext<?, ?, ?> ctx) {
        if (!StmtContextUtils.isRelevantForIfFeatureAndWhenOnListKeysCheck(ctx)) {
            return;
        }
        StmtContext<?, ?, ?> listStmtCtx = ctx.coerceParentContext();
        StmtContext keyStmtCtx = StmtContextUtils.findFirstDeclaredSubstatement(listStmtCtx, KeyStatement.class);
        if (YangStmtMapping.LEAF.equals((Object)ctx.getPublicDefinition())) {
            if (StmtContextUtils.isListKey(ctx, keyStmtCtx)) {
                StmtContextUtils.disallowIfFeatureAndWhenOnListKeys(ctx);
            }
        } else if (YangStmtMapping.USES.equals((Object)ctx.getPublicDefinition())) {
            StmtContextUtils.findAllEffectiveSubstatements(listStmtCtx, LeafStatement.class).forEach(leafStmtCtx -> {
                if (StmtContextUtils.isListKey(leafStmtCtx, keyStmtCtx)) {
                    StmtContextUtils.disallowIfFeatureAndWhenOnListKeys(leafStmtCtx);
                }
            });
        }
    }

    private static boolean isRelevantForIfFeatureAndWhenOnListKeysCheck(StmtContext<?, ?, ?> ctx) {
        return YangVersion.VERSION_1_1.equals((Object)ctx.getRootVersion()) && StmtContextUtils.hasParentOfType(ctx, (StatementDefinition)YangStmtMapping.LIST) && StmtContextUtils.findFirstDeclaredSubstatement(ctx.coerceParentContext(), KeyStatement.class) != null;
    }

    private static boolean isListKey(StmtContext<?, ?, ?> leafStmtCtx, StmtContext<Set<QName>, ?, ?> keyStmtCtx) {
        return keyStmtCtx.coerceStatementArgument().contains(leafStmtCtx.getStatementArgument());
    }

    private static void disallowIfFeatureAndWhenOnListKeys(StmtContext<?, ?, ?> leafStmtCtx) {
        leafStmtCtx.allSubstatements().forEach(leafSubstmtCtx -> {
            StatementDefinition statementDef = leafSubstmtCtx.getPublicDefinition();
            SourceException.throwIf(YangStmtMapping.IF_FEATURE.equals((Object)statementDef) || YangStmtMapping.WHEN.equals((Object)statementDef), leafStmtCtx.getStatementSourceReference(), "%s statement is not allowed in %s leaf statement which is specified as a list key.", statementDef.getStatementName(), leafStmtCtx.getStatementArgument());
        });
    }

    public static QName qnameFromArgument(StmtContext<?, ?, ?> ctx, String value) {
        if (Strings.isNullOrEmpty((String)value)) {
            return ctx.getPublicDefinition().getStatementName();
        }
        QNameModule qnameModule = null;
        String localName = null;
        String[] namesParts = value.split(":");
        switch (namesParts.length) {
            case 1: {
                localName = namesParts[0];
                qnameModule = StmtContextUtils.getRootModuleQName(ctx);
                break;
            }
            default: {
                String prefix = namesParts[0];
                localName = namesParts[1];
                qnameModule = StmtContextUtils.getModuleQNameByPrefix(ctx, prefix);
                if (qnameModule == null && StmtContextUtils.isUnknownStatement(ctx)) {
                    localName = value;
                    qnameModule = StmtContextUtils.getRootModuleQName(ctx);
                }
                if (qnameModule != null || ctx.getCopyHistory().getLastOperation() != CopyType.ADDED_BY_AUGMENTATION) break;
                ctx = ctx.getOriginalCtx().orElse(null);
                qnameModule = StmtContextUtils.getModuleQNameByPrefix(ctx, prefix);
            }
        }
        return StmtContextUtils.internedQName(ctx, InferenceException.throwIfNull(qnameModule, ctx.getStatementSourceReference(), "Cannot resolve QNameModule for '%s'", value), localName);
    }

    public static QName parseIdentifier(StmtContext<?, ?, ?> ctx, String str) {
        SourceException.throwIf(str.isEmpty(), ctx.getStatementSourceReference(), "Identifier may not be an empty string", new Object[0]);
        return StmtContextUtils.internedQName(ctx, str);
    }

    public static QName parseNodeIdentifier(StmtContext<?, ?, ?> ctx, String prefix, String localName) {
        QNameModule origModule;
        Optional<StmtContext<?, ?, ?>> optOrigCtx;
        QNameModule module = StmtContextUtils.getModuleQNameByPrefix(ctx, prefix);
        if (module != null) {
            return StmtContextUtils.internedQName(ctx, module, localName);
        }
        if (ctx.getCopyHistory().getLastOperation() == CopyType.ADDED_BY_AUGMENTATION && (optOrigCtx = ctx.getOriginalCtx()).isPresent() && (origModule = StmtContextUtils.getModuleQNameByPrefix(ctx = optOrigCtx.get(), prefix)) != null) {
            return StmtContextUtils.internedQName(ctx, origModule, localName);
        }
        throw new InferenceException(ctx.getStatementSourceReference(), "Cannot resolve QNameModule for '%s'", prefix);
    }

    public static QName parseNodeIdentifier(StmtContext<?, ?, ?> ctx, String str) {
        SourceException.throwIf(str.isEmpty(), ctx.getStatementSourceReference(), "Node identifier may not be an empty string", new Object[0]);
        int colon = str.indexOf(58);
        if (colon == -1) {
            return StmtContextUtils.internedQName(ctx, str);
        }
        String prefix = str.substring(0, colon);
        SourceException.throwIf(prefix.isEmpty(), ctx.getStatementSourceReference(), "String '%s' has an empty prefix", str);
        String localName = str.substring(colon + 1);
        SourceException.throwIf(localName.isEmpty(), ctx.getStatementSourceReference(), "String '%s' has an empty identifier", str);
        return StmtContextUtils.parseNodeIdentifier(ctx, prefix, localName);
    }

    private static QName internedQName(StmtContext<?, ?, ?> ctx, String localName) {
        return StmtContextUtils.internedQName(ctx, StmtContextUtils.getRootModuleQName(ctx), localName);
    }

    private static QName internedQName(StmtContext<?, ?, ?> ctx, QNameModule module, String localName) {
        QName template;
        try {
            template = QName.create((QNameModule)module, (String)localName);
        }
        catch (IllegalArgumentException e) {
            throw new SourceException(ctx.getStatementSourceReference(), (Throwable)e, "Invalid identifier '%s'", localName);
        }
        return template.intern();
    }

    public static QNameModule getRootModuleQName(StmtContext<?, ?, ?> ctx) {
        QNameModule qnameModule;
        if (ctx == null) {
            return null;
        }
        StmtContext<?, ?, ?> rootCtx = ctx.getRoot();
        if (rootCtx.producesDeclared(ModuleStatement.class)) {
            qnameModule = (QNameModule)rootCtx.getFromNamespace(ModuleCtxToModuleQName.class, rootCtx);
        } else if (rootCtx.producesDeclared(SubmoduleStatement.class)) {
            String belongsToModuleName = (String)StmtContextUtils.firstAttributeOf(rootCtx.declaredSubstatements(), BelongsToStatement.class);
            qnameModule = (QNameModule)rootCtx.getFromNamespace(ModuleNameToModuleQName.class, belongsToModuleName);
        } else {
            qnameModule = null;
        }
        Preconditions.checkArgument((qnameModule != null ? 1 : 0) != 0, (String)"Failed to look up root QNameModule for %s", ctx);
        return qnameModule;
    }

    public static QNameModule getModuleQNameByPrefix(StmtContext<?, ?, ?> ctx, String prefix) {
        StmtContext<?, ?, ?> root = ctx.getRoot();
        StmtContext importedModule = (StmtContext)root.getFromNamespace(ImportPrefixToModuleCtx.class, prefix);
        QNameModule qnameModule = (QNameModule)ctx.getFromNamespace(ModuleCtxToModuleQName.class, importedModule);
        if (qnameModule != null) {
            return qnameModule;
        }
        if (root.producesDeclared(SubmoduleStatement.class)) {
            String moduleName = (String)root.getFromNamespace(BelongsToPrefixToModuleName.class, prefix);
            return (QNameModule)ctx.getFromNamespace(ModuleNameToModuleQName.class, moduleName);
        }
        return null;
    }

    public static Optional<Revision> getLatestRevision(Iterable<? extends StmtContext<?, ?, ?>> subStmts) {
        Revision revision = null;
        for (StmtContext<?, ?, ?> subStmt : subStmts) {
            if (!subStmt.producesDeclared(RevisionStatement.class)) continue;
            if (revision == null && subStmt.getStatementArgument() != null) {
                revision = (Revision)subStmt.getStatementArgument();
                continue;
            }
            Revision subArg = (Revision)subStmt.getStatementArgument();
            if (subArg == null || subArg.compareTo(revision) <= 0) continue;
            revision = subArg;
        }
        return Optional.ofNullable(revision);
    }
}

