/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.util;

import java.util.Objects;
import org.opendaylight.yangtools.concepts.AbstractIllegalArgumentCodec;
import org.opendaylight.yangtools.concepts.IllegalArgumentCodec;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.UnionTypeDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStringUnionCodec
extends AbstractIllegalArgumentCodec<String, Object> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractStringUnionCodec.class);
    protected final DataSchemaNode schema;
    protected final UnionTypeDefinition typeDefinition;

    protected AbstractStringUnionCodec(DataSchemaNode schema, UnionTypeDefinition typeDefinition) {
        this.schema = Objects.requireNonNull(schema);
        this.typeDefinition = Objects.requireNonNull(typeDefinition);
    }

    protected abstract IllegalArgumentCodec<String, Object> codecFor(TypeDefinition<?> var1);

    protected Object deserializeImpl(String stringRepresentation) {
        String returnValue = null;
        for (TypeDefinition type : this.typeDefinition.getTypes()) {
            IllegalArgumentCodec<String, Object> codec = this.codecFor(type);
            if (codec == null) {
                returnValue = stringRepresentation;
                continue;
            }
            try {
                return codec.deserialize((Object)stringRepresentation);
            }
            catch (IllegalArgumentException e) {
                LOG.debug("Value {} did not match representation for {}", new Object[]{stringRepresentation, type, e});
            }
        }
        if (returnValue == null) {
            throw new IllegalArgumentException("Invalid value \"" + stringRepresentation + "\" for union type.");
        }
        return returnValue;
    }

    protected final String serializeImpl(Object data) {
        for (TypeDefinition type : this.typeDefinition.getTypes()) {
            IllegalArgumentCodec<String, Object> codec = this.codecFor(type);
            if (codec == null) {
                LOG.debug("no codec found for {}", (Object)type);
                continue;
            }
            try {
                return (String)codec.serialize(data);
            }
            catch (IllegalArgumentException e) {
                LOG.debug("Data {} did not match for {}", new Object[]{data, type, e});
            }
        }
        throw new IllegalArgumentException("Invalid data \"" + data + "\" for union type.");
    }
}

