/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.util;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.odlext.model.api.YangModeledAnyxmlSchemaNode;
import org.opendaylight.yangtools.rfc7952.data.api.StreamWriterMetadataExtension;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.util.AbstractNodeDataWithSchema;
import org.opendaylight.yangtools.yang.data.util.AnyXmlNodeDataWithSchema;
import org.opendaylight.yangtools.yang.data.util.AnydataNodeDataWithSchema;
import org.opendaylight.yangtools.yang.data.util.CaseNodeDataWithSchema;
import org.opendaylight.yangtools.yang.data.util.ChoiceNodeDataWithSchema;
import org.opendaylight.yangtools.yang.data.util.ContainerNodeDataWithSchema;
import org.opendaylight.yangtools.yang.data.util.DataSchemaContextNode;
import org.opendaylight.yangtools.yang.data.util.DuplicateChildNodeRejectedException;
import org.opendaylight.yangtools.yang.data.util.LeafListNodeDataWithSchema;
import org.opendaylight.yangtools.yang.data.util.LeafNodeDataWithSchema;
import org.opendaylight.yangtools.yang.data.util.ListNodeDataWithSchema;
import org.opendaylight.yangtools.yang.data.util.SimpleNodeDataWithSchema;
import org.opendaylight.yangtools.yang.data.util.YangModeledAnyXmlNodeDataWithSchema;
import org.opendaylight.yangtools.yang.model.api.AnydataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.AnyxmlSchemaNode;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchemaNode;
import org.opendaylight.yangtools.yang.model.api.AugmentationTarget;
import org.opendaylight.yangtools.yang.model.api.CaseSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ContainerLike;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;

public class CompositeNodeDataWithSchema<T extends DataSchemaNode>
extends AbstractNodeDataWithSchema<T> {
    private final Multimap<AugmentationSchemaNode, AbstractNodeDataWithSchema<?>> augmentationsToChild = ArrayListMultimap.create();
    private final List<AbstractNodeDataWithSchema<?>> children = new ArrayList();

    public CompositeNodeDataWithSchema(T schema) {
        super(schema);
    }

    void addChild(AbstractNodeDataWithSchema<?> newChild) {
        this.children.add(newChild);
    }

    public final AbstractNodeDataWithSchema<?> addChild(Deque<DataSchemaNode> schemas, ChildReusePolicy policy) {
        Preconditions.checkArgument((!schemas.isEmpty() ? 1 : 0) != 0, (Object)"Expecting at least one schema");
        DataSchemaNode schema = schemas.pop();
        if (schemas.isEmpty()) {
            return this.addChild(schema, policy);
        }
        DataSchemaNode choiceCandidate = schema;
        Preconditions.checkArgument((boolean)(choiceCandidate instanceof ChoiceSchemaNode), (String)"Expected node of type ChoiceNode but was %s", choiceCandidate.getClass());
        ChoiceSchemaNode choiceNode = (ChoiceSchemaNode)choiceCandidate;
        DataSchemaNode caseCandidate = schemas.pop();
        Preconditions.checkArgument((boolean)(caseCandidate instanceof CaseSchemaNode), (String)"Expected node of type ChoiceCaseNode but was %s", caseCandidate.getClass());
        CaseSchemaNode caseNode = (CaseSchemaNode)caseCandidate;
        AugmentationSchemaNode augSchema = choiceCandidate.isAugmenting() ? CompositeNodeDataWithSchema.findCorrespondingAugment(this.getSchema(), choiceCandidate) : null;
        Collection<AbstractNodeDataWithSchema<Object>> childNodes = augSchema != null ? this.augmentationsToChild.get((Object)augSchema) : this.children;
        CaseNodeDataWithSchema caseNodeDataWithSchema = CompositeNodeDataWithSchema.findChoice(childNodes, choiceCandidate, caseCandidate);
        if (caseNodeDataWithSchema == null) {
            ChoiceNodeDataWithSchema choiceNodeDataWithSchema = new ChoiceNodeDataWithSchema(choiceNode);
            childNodes.add(choiceNodeDataWithSchema);
            caseNodeDataWithSchema = choiceNodeDataWithSchema.addCompositeChild(caseNode, ChildReusePolicy.NOOP);
        }
        return caseNodeDataWithSchema.addChild(schemas, policy);
    }

    private AbstractNodeDataWithSchema<?> addChild(DataSchemaNode schema, ChildReusePolicy policy) {
        AbstractNodeDataWithSchema<?> newChild = this.addSimpleChild(schema, policy);
        return newChild == null ? this.addCompositeChild(schema, policy) : newChild;
    }

    private AbstractNodeDataWithSchema<?> addSimpleChild(DataSchemaNode schema, ChildReusePolicy policy) {
        SimpleNodeDataWithSchema newChild;
        if (schema instanceof LeafSchemaNode) {
            newChild = new LeafNodeDataWithSchema((LeafSchemaNode)schema);
        } else if (schema instanceof AnyxmlSchemaNode) {
            if (schema instanceof YangModeledAnyxmlSchemaNode) {
                return null;
            }
            newChild = new AnyXmlNodeDataWithSchema((AnyxmlSchemaNode)schema);
        } else if (schema instanceof AnydataSchemaNode) {
            newChild = new AnydataNodeDataWithSchema((AnydataSchemaNode)schema);
        } else {
            return null;
        }
        AugmentationSchemaNode augSchema = schema.isAugmenting() ? CompositeNodeDataWithSchema.findCorrespondingAugment(this.getSchema(), schema) : null;
        if (augSchema != null) {
            this.augmentationsToChild.put((Object)augSchema, (Object)newChild);
        } else {
            this.addChild(newChild);
        }
        return newChild;
    }

    private static CaseNodeDataWithSchema findChoice(Collection<AbstractNodeDataWithSchema<?>> childNodes, DataSchemaNode choiceCandidate, DataSchemaNode caseCandidate) {
        if (childNodes != null) {
            for (AbstractNodeDataWithSchema<?> nodeDataWithSchema : childNodes) {
                if (!(nodeDataWithSchema instanceof ChoiceNodeDataWithSchema) || !nodeDataWithSchema.getSchema().getQName().equals((Object)choiceCandidate.getQName())) continue;
                CaseNodeDataWithSchema casePrevious = ((ChoiceNodeDataWithSchema)nodeDataWithSchema).getCase();
                Preconditions.checkArgument((boolean)((CaseSchemaNode)casePrevious.getSchema()).getQName().equals((Object)caseCandidate.getQName()), (String)"Data from case %s are specified but other data from case %s were specified earlier. Data aren't from the same case.", (Object)caseCandidate.getQName(), (Object)((CaseSchemaNode)casePrevious.getSchema()).getQName());
                return casePrevious;
            }
        }
        return null;
    }

    AbstractNodeDataWithSchema<?> addCompositeChild(DataSchemaNode schema, ChildReusePolicy policy) {
        CompositeNodeDataWithSchema newChild = schema instanceof ListSchemaNode ? new ListNodeDataWithSchema((ListSchemaNode)schema) : (schema instanceof LeafListSchemaNode ? new LeafListNodeDataWithSchema((LeafListSchemaNode)schema) : (schema instanceof ContainerLike ? new ContainerNodeDataWithSchema((ContainerLike)schema) : (schema instanceof YangModeledAnyxmlSchemaNode ? new YangModeledAnyXmlNodeDataWithSchema((YangModeledAnyxmlSchemaNode)schema) : new CompositeNodeDataWithSchema<DataSchemaNode>(schema))));
        return this.addCompositeChild(newChild, policy);
    }

    final AbstractNodeDataWithSchema<?> addCompositeChild(CompositeNodeDataWithSchema<?> newChild, ChildReusePolicy policy) {
        AugmentationSchemaNode augSchema = CompositeNodeDataWithSchema.findCorrespondingAugment(this.getSchema(), newChild.getSchema());
        List<AbstractNodeDataWithSchema<?>> view = augSchema == null ? this.children : this.augmentationsToChild.get((Object)augSchema);
        return policy.appendChild(view, newChild);
    }

    protected final int childSizeHint() {
        return this.children.size();
    }

    @Override
    public void write(NormalizedNodeStreamWriter writer, StreamWriterMetadataExtension metaWriter) throws IOException {
        for (AbstractNodeDataWithSchema<?> abstractNodeDataWithSchema : this.children) {
            abstractNodeDataWithSchema.write(writer, metaWriter);
        }
        for (Map.Entry entry : this.augmentationsToChild.asMap().entrySet()) {
            Collection childsFromAgumentation = (Collection)entry.getValue();
            if (childsFromAgumentation.isEmpty()) continue;
            writer.startAugmentationNode(DataSchemaContextNode.augmentationIdentifierFrom((AugmentationSchemaNode)entry.getKey()));
            for (AbstractNodeDataWithSchema nodeDataWithSchema : childsFromAgumentation) {
                nodeDataWithSchema.write(writer, metaWriter);
            }
            writer.endNode();
        }
    }

    private static AugmentationSchemaNode findCorrespondingAugment(DataSchemaNode parent, DataSchemaNode child) {
        if (parent instanceof AugmentationTarget && !(parent instanceof ChoiceSchemaNode)) {
            for (AugmentationSchemaNode augmentation : ((AugmentationTarget)parent).getAvailableAugmentations()) {
                DataSchemaNode childInAugmentation = augmentation.dataChildByName(child.getQName());
                if (childInAugmentation == null) continue;
                return augmentation;
            }
        }
        return null;
    }

    @Beta
    public static enum ChildReusePolicy {
        NOOP,
        REJECT{

            @Override
            AbstractNodeDataWithSchema<?> appendChild(Collection<AbstractNodeDataWithSchema<?>> view, AbstractNodeDataWithSchema<?> newChild) {
                Object childSchema = newChild.getSchema();
                AbstractNodeDataWithSchema<?> existing = 1.findExistingChild(view, childSchema);
                if (existing != null) {
                    throw new DuplicateChildNodeRejectedException("Duplicate child " + childSchema.getQName());
                }
                return super.appendChild(view, newChild);
            }
        }
        ,
        REUSE{

            @Override
            AbstractNodeDataWithSchema<?> appendChild(Collection<AbstractNodeDataWithSchema<?>> view, AbstractNodeDataWithSchema<?> newChild) {
                AbstractNodeDataWithSchema<?> existing = 2.findExistingChild(view, newChild.getSchema());
                return existing != null ? existing : super.appendChild(view, newChild);
            }
        };


        AbstractNodeDataWithSchema<?> appendChild(Collection<AbstractNodeDataWithSchema<?>> view, AbstractNodeDataWithSchema<?> newChild) {
            view.add(newChild);
            return newChild;
        }

        static @Nullable AbstractNodeDataWithSchema<?> findExistingChild(Collection<AbstractNodeDataWithSchema<?>> view, DataSchemaNode childSchema) {
            for (AbstractNodeDataWithSchema<?> existing : view) {
                if (!childSchema.equals(existing.getSchema())) continue;
                return existing;
            }
            return null;
        }
    }
}

