/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.util;

import com.google.common.base.Verify;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.rfc7952.data.api.StreamWriterMetadataExtension;
import org.opendaylight.yangtools.util.ImmutableMapTemplate;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.util.AbstractMountPointDataWithSchema;
import org.opendaylight.yangtools.yang.data.util.AbstractNodeDataWithSchema;
import org.opendaylight.yangtools.yang.data.util.SimpleNodeDataWithSchema;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;

public abstract class ListEntryNodeDataWithSchema
extends AbstractMountPointDataWithSchema<ListSchemaNode> {
    ListEntryNodeDataWithSchema(ListSchemaNode schema) {
        super(schema);
    }

    static @NonNull ListEntryNodeDataWithSchema forSchema(ListSchemaNode schema) {
        List keyDef = schema.getKeyDefinition();
        return keyDef.isEmpty() ? new Unkeyed(schema) : new Keyed(schema, keyDef);
    }

    private static final class Unkeyed
    extends ListEntryNodeDataWithSchema {
        Unkeyed(ListSchemaNode schema) {
            super(schema);
        }

        @Override
        public void write(NormalizedNodeStreamWriter writer, StreamWriterMetadataExtension metaWriter) throws IOException {
            writer.nextDataSchemaNode(this.getSchema());
            writer.startUnkeyedListItem(this.provideNodeIdentifier(), this.childSizeHint());
            super.write(writer, metaWriter);
            writer.endNode();
        }
    }

    private static final class Keyed
    extends ListEntryNodeDataWithSchema {
        private final Map<QName, SimpleNodeDataWithSchema<?>> keyValues = new HashMap();
        private final ImmutableMapTemplate<QName> predicateTemplate;

        Keyed(ListSchemaNode schema, List<QName> keyDef) {
            super(schema);
            this.predicateTemplate = ImmutableMapTemplate.ordered(keyDef);
        }

        @Override
        void addChild(AbstractNodeDataWithSchema<?> newChild) {
            Object childSchema = newChild.getSchema();
            if (childSchema instanceof LeafSchemaNode) {
                QName childName = childSchema.getQName();
                if (this.predicateTemplate.keySet().contains(childName)) {
                    Verify.verify((boolean)(newChild instanceof SimpleNodeDataWithSchema));
                    this.keyValues.put(childName, (SimpleNodeDataWithSchema)newChild);
                }
            }
            super.addChild(newChild);
        }

        @Override
        public void write(NormalizedNodeStreamWriter writer, StreamWriterMetadataExtension metaWriter) throws IOException {
            writer.nextDataSchemaNode(this.getSchema());
            YangInstanceIdentifier.NodeIdentifierWithPredicates identifier = YangInstanceIdentifier.NodeIdentifierWithPredicates.of((QName)((ListSchemaNode)this.getSchema()).getQName(), (Map)this.predicateTemplate.instantiateTransformed(this.keyValues, (key, node) -> node.getValue()));
            writer.startMapEntryNode(identifier, this.childSizeHint());
            this.writeMetadata(metaWriter);
            super.write(writer, metaWriter);
            writer.endNode();
        }
    }
}

