/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.util;

import com.google.common.annotations.Beta;
import com.google.common.collect.ForwardingObject;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.ActionDefinition;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ContainerLike;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.GroupingDefinition;
import org.opendaylight.yangtools.yang.model.api.InputSchemaNode;
import org.opendaylight.yangtools.yang.model.api.MustDefinition;
import org.opendaylight.yangtools.yang.model.api.NotificationDefinition;
import org.opendaylight.yangtools.yang.model.api.OperationDefinition;
import org.opendaylight.yangtools.yang.model.api.OutputSchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.UsesNode;
import org.opendaylight.yangtools.yang.xpath.api.YangXPathExpression;

@Beta
public class OperationAsContainer
extends ForwardingObject
implements ContainerLike,
OperationDefinition {
    private final @NonNull OperationDefinition delegate;

    OperationAsContainer(OperationDefinition parentNode) {
        this.delegate = Objects.requireNonNull(parentNode);
    }

    public static @NonNull OperationAsContainer of(OperationDefinition delegate) {
        return new OperationAsContainer(delegate);
    }

    protected final @NonNull OperationDefinition delegate() {
        return this.delegate;
    }

    public final Optional<String> getDescription() {
        return this.delegate.getDescription();
    }

    public final Optional<String> getReference() {
        return this.delegate.getReference();
    }

    public final Collection<? extends @NonNull TypeDefinition<?>> getTypeDefinitions() {
        return this.delegate.getTypeDefinitions();
    }

    public final Collection<? extends @NonNull GroupingDefinition> getGroupings() {
        return this.delegate.getGroupings();
    }

    public final Status getStatus() {
        return this.delegate.getStatus();
    }

    public final InputSchemaNode getInput() {
        return this.delegate.getInput();
    }

    public final OutputSchemaNode getOutput() {
        return this.delegate.getOutput();
    }

    public final QName getQName() {
        return this.delegate.getQName();
    }

    @Deprecated
    public final SchemaPath getPath() {
        return this.delegate.getPath();
    }

    public final Optional<DataSchemaNode> findDataChildByName(QName name) {
        if (!name.getModule().equals((Object)this.getQName().getModule())) {
            return Optional.empty();
        }
        switch (name.getLocalName()) {
            case "input": {
                return Optional.of(this.delegate.getInput());
            }
            case "output": {
                return Optional.of(this.delegate.getOutput());
            }
        }
        return Optional.empty();
    }

    public Collection<? extends UsesNode> getUses() {
        return ImmutableSet.of();
    }

    public final Collection<? extends AugmentationSchemaNode> getAvailableAugmentations() {
        return ImmutableSet.of();
    }

    public final Collection<? extends DataSchemaNode> getChildNodes() {
        OutputSchemaNode output;
        ArrayList<Object> ret = new ArrayList<Object>();
        InputSchemaNode input = this.getInput();
        if (input != null) {
            ret.add(input);
        }
        if ((output = this.getOutput()) != null) {
            ret.add(output);
        }
        return ret;
    }

    @Deprecated
    public final boolean isAugmenting() {
        return false;
    }

    @Deprecated
    public final boolean isAddedByUses() {
        return false;
    }

    public final boolean isConfiguration() {
        return false;
    }

    public final Collection<? extends ActionDefinition> getActions() {
        return ImmutableSet.of();
    }

    public Optional<ActionDefinition> findAction(QName qname) {
        Objects.requireNonNull(qname);
        return Optional.empty();
    }

    public final Collection<? extends NotificationDefinition> getNotifications() {
        return ImmutableSet.of();
    }

    public Optional<NotificationDefinition> findNotification(QName qname) {
        Objects.requireNonNull(qname);
        return Optional.empty();
    }

    public final Collection<? extends @NonNull MustDefinition> getMustConstraints() {
        return ImmutableSet.of();
    }

    public final Optional<? extends YangXPathExpression.QualifiedBound> getWhenCondition() {
        return Optional.empty();
    }
}

