/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import java.util.Collection;
import java.util.Objects;
import org.opendaylight.mdsal.binding.api.DataTreeChangeListener;
import org.opendaylight.mdsal.binding.dom.adapter.AdapterContext;
import org.opendaylight.mdsal.binding.dom.adapter.LazyDataTreeModification;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataTreeChangeListener;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidate;

class BindingDOMDataTreeChangeListenerAdapter<T extends DataObject>
implements DOMDataTreeChangeListener {
    private final AdapterContext adapterContext;
    private final DataTreeChangeListener<T> listener;
    private final LogicalDatastoreType store;

    BindingDOMDataTreeChangeListenerAdapter(AdapterContext adapterContext, DataTreeChangeListener<T> listener, LogicalDatastoreType store) {
        this.adapterContext = Objects.requireNonNull(adapterContext);
        this.listener = Objects.requireNonNull(listener);
        this.store = Objects.requireNonNull(store);
    }

    public void onDataTreeChanged(Collection<DataTreeCandidate> domChanges) {
        this.listener.onDataTreeChanged(LazyDataTreeModification.from(this.adapterContext.currentSerializer(), domChanges, this.store));
    }

    public void onInitialData() {
        this.listener.onInitialData();
    }
}

