/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.mdsal.binding.api.DataTreeIdentifier;
import org.opendaylight.mdsal.binding.api.DataTreeListener;
import org.opendaylight.mdsal.binding.api.DataTreeListeningException;
import org.opendaylight.mdsal.binding.api.DataTreeModification;
import org.opendaylight.mdsal.binding.dom.adapter.AbstractBindingAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.AdapterContext;
import org.opendaylight.mdsal.binding.dom.adapter.CurrentAdapterSerializer;
import org.opendaylight.mdsal.binding.dom.adapter.LazyDataTreeModification;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingNormalizedNodeSerializer;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.mdsal.dom.api.DOMDataTreeListener;
import org.opendaylight.mdsal.dom.api.DOMDataTreeListeningException;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidate;

public class BindingDOMDataTreeListenerAdapter
extends AbstractBindingAdapter<DataTreeListener>
implements DOMDataTreeListener {
    private final LogicalDatastoreType store;

    protected BindingDOMDataTreeListenerAdapter(DataTreeListener delegate, AdapterContext codec, LogicalDatastoreType store) {
        super(codec, delegate);
        this.store = Objects.requireNonNull(store, "store");
    }

    public void onDataTreeChanged(Collection<DataTreeCandidate> domChanges, Map<DOMDataTreeIdentifier, NormalizedNode<?, ?>> domSubtrees) {
        CurrentAdapterSerializer serializer = this.currentSerializer();
        ((DataTreeListener)this.getDelegate()).onDataTreeChanged(this.toBinding(serializer, domChanges), this.toBinding((BindingNormalizedNodeSerializer)serializer, domSubtrees));
    }

    private Map<DataTreeIdentifier<?>, DataObject> toBinding(BindingNormalizedNodeSerializer serializer, Map<DOMDataTreeIdentifier, NormalizedNode<?, ?>> domSubtrees) {
        HashMap ret = Maps.newHashMapWithExpectedSize((int)domSubtrees.size());
        for (Map.Entry<DOMDataTreeIdentifier, NormalizedNode<?, ?>> domEntry : domSubtrees.entrySet()) {
            Map.Entry bindingEntry = serializer.fromNormalizedNode(domEntry.getKey().getRootIdentifier(), domEntry.getValue());
            ret.put(DataTreeIdentifier.create((LogicalDatastoreType)this.store, (InstanceIdentifier)((InstanceIdentifier)bindingEntry.getKey())), (DataObject)bindingEntry.getValue());
        }
        return ret;
    }

    private Collection<DataTreeModification<?>> toBinding(CurrentAdapterSerializer serializer, Collection<DataTreeCandidate> domChanges) {
        return (Collection)Collection.class.cast(LazyDataTreeModification.from(serializer, domChanges, this.store));
    }

    public void onDataTreeFailed(Collection<DOMDataTreeListeningException> causes) {
        ArrayList<DataTreeListeningException> bindingCauses = new ArrayList<DataTreeListeningException>(causes.size());
        for (DOMDataTreeListeningException cause : causes) {
            bindingCauses.add(BindingDOMDataTreeListenerAdapter.mapException(cause));
        }
        ((DataTreeListener)this.getDelegate()).onDataTreeFailed(bindingCauses);
    }

    private static DataTreeListeningException mapException(DOMDataTreeListeningException cause) {
        return new DataTreeListeningException(cause.getMessage(), (Throwable)cause);
    }
}

