/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import java.util.Collection;
import org.opendaylight.mdsal.binding.api.CursorAwareWriteTransaction;
import org.opendaylight.mdsal.binding.api.DataTreeIdentifier;
import org.opendaylight.mdsal.binding.api.DataTreeProducer;
import org.opendaylight.mdsal.binding.api.DataTreeProducerException;
import org.opendaylight.mdsal.binding.dom.adapter.AbstractBindingAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.AdapterContext;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDOMCursorAwareWriteTransactionAdapter;
import org.opendaylight.mdsal.dom.api.DOMDataTreeCursorAwareTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.mdsal.dom.api.DOMDataTreeProducer;
import org.opendaylight.mdsal.dom.api.DOMDataTreeProducerException;

final class BindingDOMDataTreeProducerAdapter
extends AbstractBindingAdapter<DOMDataTreeProducer>
implements DataTreeProducer {
    BindingDOMDataTreeProducerAdapter(AdapterContext adapterContext, DOMDataTreeProducer delegate) {
        super(adapterContext, delegate);
    }

    public CursorAwareWriteTransaction createTransaction(boolean isolated) {
        DOMDataTreeCursorAwareTransaction domTx = ((DOMDataTreeProducer)this.getDelegate()).createTransaction(isolated);
        return new BindingDOMCursorAwareWriteTransactionAdapter<DOMDataTreeCursorAwareTransaction>(this.adapterContext(), domTx);
    }

    public DataTreeProducer createProducer(Collection<DataTreeIdentifier<?>> subtrees) {
        Collection<DOMDataTreeIdentifier> domSubtrees = this.currentSerializer().toDOMDataTreeIdentifiers(subtrees);
        DOMDataTreeProducer domChildProducer = ((DOMDataTreeProducer)this.getDelegate()).createProducer(domSubtrees);
        return new BindingDOMDataTreeProducerAdapter(this.adapterContext(), domChildProducer);
    }

    public void close() throws DataTreeProducerException {
        try {
            ((DOMDataTreeProducer)this.getDelegate()).close();
        }
        catch (DOMDataTreeProducerException e) {
            throw new DataTreeProducerException(e.getMessage(), (Throwable)e);
        }
    }
}

