/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.opendaylight.mdsal.binding.dom.adapter.AdapterContext;
import org.opendaylight.mdsal.binding.dom.adapter.CurrentAdapterSerializer;
import org.opendaylight.mdsal.binding.dom.adapter.LazySerializedDOMNotification;
import org.opendaylight.mdsal.binding.dom.adapter.invoke.NotificationListenerInvoker;
import org.opendaylight.mdsal.binding.spec.reflect.BindingReflections;
import org.opendaylight.mdsal.dom.api.DOMEvent;
import org.opendaylight.mdsal.dom.api.DOMNotification;
import org.opendaylight.mdsal.dom.api.DOMNotificationListener;
import org.opendaylight.yangtools.yang.binding.DataContainer;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.opendaylight.yangtools.yang.binding.NotificationListener;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;

class BindingDOMNotificationListenerAdapter
implements DOMNotificationListener {
    private final AdapterContext adapterContext;
    private final NotificationListener delegate;
    private final ImmutableMap<SchemaNodeIdentifier.Absolute, NotificationListenerInvoker> invokers;

    BindingDOMNotificationListenerAdapter(AdapterContext adapterContext, NotificationListener delegate) {
        this.adapterContext = Objects.requireNonNull(adapterContext);
        this.delegate = Objects.requireNonNull(delegate);
        this.invokers = BindingDOMNotificationListenerAdapter.createInvokerMapFor(delegate.getClass());
    }

    public void onNotification(DOMNotification notification) {
        Notification baNotification = this.deserialize(notification);
        QName notificationQName = notification.getType().lastNodeIdentifier();
        this.getInvoker(notification.getType()).invokeNotification(this.delegate, notificationQName, (DataContainer)baNotification);
    }

    private Notification deserialize(DOMNotification notification) {
        if (notification instanceof LazySerializedDOMNotification) {
            return ((LazySerializedDOMNotification)notification).getBindingData();
        }
        CurrentAdapterSerializer serializer = this.adapterContext.currentSerializer();
        return notification instanceof DOMEvent ? serializer.fromNormalizedNodeNotification(notification.getType(), notification.getBody(), ((DOMEvent)notification).getEventInstant()) : serializer.fromNormalizedNodeNotification(notification.getType(), notification.getBody());
    }

    private NotificationListenerInvoker getInvoker(SchemaNodeIdentifier.Absolute type) {
        return (NotificationListenerInvoker)this.invokers.get((Object)type);
    }

    protected Set<SchemaNodeIdentifier.Absolute> getSupportedNotifications() {
        return this.invokers.keySet();
    }

    private static ImmutableMap<SchemaNodeIdentifier.Absolute, NotificationListenerInvoker> createInvokerMapFor(Class<? extends NotificationListener> implClz) {
        HashMap<SchemaNodeIdentifier.Absolute, NotificationListenerInvoker> builder = new HashMap<SchemaNodeIdentifier.Absolute, NotificationListenerInvoker>();
        for (TypeToken ifaceToken : TypeToken.of(implClz).getTypes().interfaces()) {
            Class iface = ifaceToken.getRawType();
            if (!NotificationListener.class.isAssignableFrom(iface) || !BindingReflections.isBindingClass((Class)iface)) continue;
            Class listenerType = iface;
            NotificationListenerInvoker invoker = NotificationListenerInvoker.from(listenerType);
            for (SchemaNodeIdentifier.Absolute path : BindingDOMNotificationListenerAdapter.getNotificationTypes(listenerType)) {
                builder.put(path, invoker);
            }
        }
        return ImmutableMap.copyOf(builder);
    }

    private static Set<SchemaNodeIdentifier.Absolute> getNotificationTypes(Class<? extends NotificationListener> type) {
        HashSet<SchemaNodeIdentifier.Absolute> ret = new HashSet<SchemaNodeIdentifier.Absolute>();
        for (Method method : type.getMethods()) {
            if (!BindingReflections.isNotificationCallback((Method)method)) continue;
            Class<?> notification = method.getParameterTypes()[0];
            ret.add(SchemaNodeIdentifier.Absolute.of((QName)BindingReflections.findQName(notification)));
        }
        return ret;
    }
}

