/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.ListenableFuture;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import org.opendaylight.mdsal.binding.dom.adapter.AdapterContext;
import org.opendaylight.mdsal.binding.dom.adapter.CurrentAdapterSerializer;
import org.opendaylight.mdsal.binding.dom.adapter.LazyDOMRpcResultFuture;
import org.opendaylight.mdsal.binding.dom.adapter.StaticConfiguration;
import org.opendaylight.mdsal.binding.dom.adapter.invoke.RpcServiceInvoker;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingLazyContainerNode;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingNormalizedNodeSerializer;
import org.opendaylight.mdsal.binding.spec.reflect.BindingReflections;
import org.opendaylight.mdsal.dom.api.DOMRpcIdentifier;
import org.opendaylight.mdsal.dom.api.DOMRpcImplementation;
import org.opendaylight.mdsal.dom.api.DOMRpcResult;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.common.YangConstants;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;

final class BindingDOMRpcImplementationAdapter
implements DOMRpcImplementation {
    private static final Cache<Class<?>, RpcServiceInvoker> SERVICE_INVOKERS = CacheBuilder.newBuilder().weakKeys().build();
    private static final int COST = 1;
    private final AdapterContext adapterContext;
    private final RpcServiceInvoker invoker;
    private final RpcService delegate;
    private final QName inputQname;

    <T extends RpcService> BindingDOMRpcImplementationAdapter(AdapterContext adapterContext, Class<T> type, Map<QName, Method> localNameToMethod, T delegate) {
        try {
            this.invoker = (RpcServiceInvoker)SERVICE_INVOKERS.get(type, () -> RpcServiceInvoker.from(localNameToMethod));
        }
        catch (ExecutionException e) {
            throw new IllegalArgumentException("Failed to create invokers for type " + type, e);
        }
        this.adapterContext = Objects.requireNonNull(adapterContext);
        this.delegate = Objects.requireNonNull(delegate);
        this.inputQname = YangConstants.operationInputQName((QNameModule)BindingReflections.getQNameModule(type)).intern();
    }

    public ListenableFuture<DOMRpcResult> invokeRpc(DOMRpcIdentifier rpc, NormalizedNode<?, ?> input) {
        QName rpcType = rpc.getType();
        CurrentAdapterSerializer serializer = this.adapterContext.currentSerializer();
        DataObject bindingInput = input != null ? this.deserialize(serializer, rpcType, input) : null;
        ListenableFuture<RpcResult<?>> bindingResult = this.invoke(rpcType, bindingInput);
        return LazyDOMRpcResultFuture.create((BindingNormalizedNodeSerializer)serializer, bindingResult);
    }

    public long invocationCost() {
        return 1L;
    }

    private DataObject deserialize(CurrentAdapterSerializer serializer, QName rpcType, NormalizedNode<?, ?> input) {
        if (StaticConfiguration.ENABLE_CODEC_SHORTCUT && input instanceof BindingLazyContainerNode) {
            return ((BindingLazyContainerNode)input).getDataObject();
        }
        ContainerNode container = (ContainerNode)input;
        Preconditions.checkArgument((boolean)this.inputQname.equals((Object)((YangInstanceIdentifier.NodeIdentifier)container.getIdentifier()).getNodeType()), (String)"Unexpected RPC %s input %s", (Object)rpcType, input);
        return serializer.fromNormalizedNodeRpcData(SchemaNodeIdentifier.Absolute.of((QName[])new QName[]{rpcType, this.inputQname}), container);
    }

    private ListenableFuture<RpcResult<?>> invoke(QName rpcType, DataObject input) {
        return this.invoker.invokeRpc(this.delegate, rpcType, input);
    }
}

