/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.opendaylight.mdsal.binding.api.RpcProviderService;
import org.opendaylight.mdsal.binding.dom.adapter.AbstractBindingAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.AdapterContext;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDOMRpcImplementationAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.BindingRpcAdapterRegistration;
import org.opendaylight.mdsal.binding.dom.adapter.CurrentAdapterSerializer;
import org.opendaylight.mdsal.dom.api.DOMRpcIdentifier;
import org.opendaylight.mdsal.dom.api.DOMRpcImplementation;
import org.opendaylight.mdsal.dom.api.DOMRpcImplementationRegistration;
import org.opendaylight.mdsal.dom.api.DOMRpcProviderService;
import org.opendaylight.yangtools.concepts.ObjectRegistration;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;

@VisibleForTesting
public class BindingDOMRpcProviderServiceAdapter
extends AbstractBindingAdapter<DOMRpcProviderService>
implements RpcProviderService {
    private static final ImmutableSet<YangInstanceIdentifier> GLOBAL = ImmutableSet.of((Object)YangInstanceIdentifier.empty());

    public BindingDOMRpcProviderServiceAdapter(AdapterContext adapterContext, DOMRpcProviderService domRpcRegistry) {
        super(adapterContext, domRpcRegistry);
    }

    public <S extends RpcService, T extends S> ObjectRegistration<T> registerRpcImplementation(Class<S> type, T implementation) {
        return this.register(type, implementation, (Collection<YangInstanceIdentifier>)GLOBAL);
    }

    public <S extends RpcService, T extends S> ObjectRegistration<T> registerRpcImplementation(Class<S> type, T implementation, Set<InstanceIdentifier<?>> paths) {
        return this.register(type, implementation, this.toYangInstanceIdentifiers(paths));
    }

    private <S extends RpcService, T extends S> ObjectRegistration<T> register(Class<S> type, T implementation, Collection<YangInstanceIdentifier> rpcContextPaths) {
        ImmutableBiMap rpcs = this.currentSerializer().getRpcMethodToQName(type).inverse();
        BindingDOMRpcImplementationAdapter adapter = new BindingDOMRpcImplementationAdapter(this.adapterContext(), type, (Map<QName, Method>)rpcs, implementation);
        Set<DOMRpcIdentifier> domRpcs = BindingDOMRpcProviderServiceAdapter.createDomRpcIdentifiers(rpcs.keySet(), rpcContextPaths);
        DOMRpcImplementationRegistration domReg = ((DOMRpcProviderService)this.getDelegate()).registerRpcImplementation((DOMRpcImplementation)adapter, domRpcs);
        return new BindingRpcAdapterRegistration<T>(implementation, domReg);
    }

    private static Set<DOMRpcIdentifier> createDomRpcIdentifiers(Set<QName> rpcs, Collection<YangInstanceIdentifier> paths) {
        HashSet<DOMRpcIdentifier> ret = new HashSet<DOMRpcIdentifier>();
        for (YangInstanceIdentifier path : paths) {
            for (QName rpc : rpcs) {
                ret.add(DOMRpcIdentifier.create((QName)rpc, (YangInstanceIdentifier)path));
            }
        }
        return ret;
    }

    private Collection<YangInstanceIdentifier> toYangInstanceIdentifiers(Set<InstanceIdentifier<?>> identifiers) {
        ArrayList<YangInstanceIdentifier> ret = new ArrayList<YangInstanceIdentifier>(identifiers.size());
        CurrentAdapterSerializer serializer = this.currentSerializer();
        for (InstanceIdentifier<?> binding : identifiers) {
            ret.add(serializer.toCachedYangInstanceIdentifier(binding));
        }
        return ret;
    }
}

