/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import com.google.common.annotations.Beta;
import java.util.Iterator;
import java.util.Optional;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.AnyxmlNode;
import org.opendaylight.yangtools.yang.data.api.schema.AugmentationNode;
import org.opendaylight.yangtools.yang.data.api.schema.ChoiceNode;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.LeafNode;
import org.opendaylight.yangtools.yang.data.api.schema.LeafSetEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.LeafSetNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.UnkeyedListEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.UnkeyedListNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidateNode;

@Beta
public enum BindingStructuralType {
    NOT_ADDRESSABLE,
    INVISIBLE_CONTAINER,
    INVISIBLE_LIST,
    VISIBLE_CONTAINER,
    UNKNOWN;


    public static BindingStructuralType from(DataTreeCandidateNode domChildNode) {
        Optional dataBased = domChildNode.getDataAfter();
        if (!dataBased.isPresent()) {
            dataBased = domChildNode.getDataBefore();
        }
        if (dataBased.isPresent()) {
            return BindingStructuralType.from((NormalizedNode)dataBased.get());
        }
        return BindingStructuralType.from(domChildNode.getIdentifier());
    }

    private static BindingStructuralType from(YangInstanceIdentifier.PathArgument identifier) {
        if (identifier instanceof YangInstanceIdentifier.NodeIdentifierWithPredicates || identifier instanceof YangInstanceIdentifier.AugmentationIdentifier) {
            return VISIBLE_CONTAINER;
        }
        if (identifier instanceof YangInstanceIdentifier.NodeWithValue) {
            return NOT_ADDRESSABLE;
        }
        return UNKNOWN;
    }

    static BindingStructuralType from(NormalizedNode<?, ?> data) {
        if (BindingStructuralType.isNotAddressable(data)) {
            return NOT_ADDRESSABLE;
        }
        if (data instanceof MapNode) {
            return INVISIBLE_LIST;
        }
        if (data instanceof ChoiceNode) {
            return INVISIBLE_CONTAINER;
        }
        if (BindingStructuralType.isVisibleContainer(data)) {
            return VISIBLE_CONTAINER;
        }
        return UNKNOWN;
    }

    public static BindingStructuralType recursiveFrom(DataTreeCandidateNode node) {
        BindingStructuralType type = BindingStructuralType.from(node);
        switch (type) {
            case INVISIBLE_CONTAINER: 
            case INVISIBLE_LIST: {
                Iterator iterator = node.getChildNodes().iterator();
                if (iterator.hasNext()) {
                    DataTreeCandidateNode child = (DataTreeCandidateNode)iterator.next();
                    BindingStructuralType childType = BindingStructuralType.recursiveFrom(child);
                    switch (childType) {
                        case INVISIBLE_CONTAINER: 
                        case INVISIBLE_LIST: {
                            return NOT_ADDRESSABLE;
                        }
                        case NOT_ADDRESSABLE: 
                        case UNKNOWN: 
                        case VISIBLE_CONTAINER: {
                            return childType;
                        }
                    }
                    throw new IllegalStateException("Unhandled child type " + childType + " for child " + child);
                }
                return NOT_ADDRESSABLE;
            }
        }
        return type;
    }

    private static boolean isVisibleContainer(NormalizedNode<?, ?> data) {
        return data instanceof MapEntryNode || data instanceof ContainerNode || data instanceof AugmentationNode;
    }

    private static boolean isNotAddressable(NormalizedNode<?, ?> normalizedNode) {
        return normalizedNode instanceof LeafNode || normalizedNode instanceof AnyxmlNode || normalizedNode instanceof LeafSetNode || normalizedNode instanceof LeafSetEntryNode || normalizedNode instanceof UnkeyedListNode || normalizedNode instanceof UnkeyedListEntryNode;
    }
}

