/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.time.Instant;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingNormalizedNodeSerializer;
import org.opendaylight.mdsal.binding.spec.reflect.BindingReflections;
import org.opendaylight.mdsal.dom.api.DOMEvent;
import org.opendaylight.mdsal.dom.api.DOMNotification;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;

final class LazySerializedDOMNotification
implements DOMNotification,
DOMEvent {
    private static final LoadingCache<Class<?>, SchemaNodeIdentifier.Absolute> PATHS = CacheBuilder.newBuilder().weakKeys().build(new CacheLoader<Class<?>, SchemaNodeIdentifier.Absolute>(){

        public SchemaNodeIdentifier.Absolute load(Class<?> key) {
            return SchemaNodeIdentifier.Absolute.of((QName)BindingReflections.findQName(key)).intern();
        }
    });
    private final @NonNull BindingNormalizedNodeSerializer codec;
    private final @NonNull Notification data;
    private final // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull SchemaNodeIdentifier.Absolute type;
    private final @NonNull Instant eventInstant;
    private volatile ContainerNode domBody;

    LazySerializedDOMNotification(BindingNormalizedNodeSerializer codec, Notification data, SchemaNodeIdentifier.Absolute type, Instant eventInstant) {
        this.codec = Objects.requireNonNull(codec);
        this.data = Objects.requireNonNull(data);
        this.type = Objects.requireNonNull(type);
        this.eventInstant = Objects.requireNonNull(eventInstant);
    }

    static @NonNull DOMNotification create(BindingNormalizedNodeSerializer codec, Notification data, Instant eventInstant) {
        SchemaNodeIdentifier.Absolute type = (SchemaNodeIdentifier.Absolute)PATHS.getUnchecked((Object)data.implementedInterface());
        return new LazySerializedDOMNotification(codec, data, type, eventInstant);
    }

    public SchemaNodeIdentifier.Absolute getType() {
        return this.type;
    }

    public ContainerNode getBody() {
        ContainerNode local = this.domBody;
        if (local == null) {
            this.domBody = local = this.codec.toNormalizedNodeNotification(this.data);
        }
        return local;
    }

    public Instant getEventInstant() {
        return this.eventInstant;
    }

    @NonNull Notification getBindingData() {
        return this.data;
    }
}

