/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter.invoke;

import com.google.common.base.Throwables;
import com.google.common.util.concurrent.ListenableFuture;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import org.opendaylight.mdsal.binding.dom.adapter.invoke.RpcMethodInvoker;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.opendaylight.yangtools.yang.common.RpcResult;

class RpcMethodInvokerWithoutInput
extends RpcMethodInvoker {
    private static final MethodType INVOCATION_SIGNATURE = MethodType.methodType(ListenableFuture.class, RpcService.class);
    private final MethodHandle handle;

    RpcMethodInvokerWithoutInput(MethodHandle methodHandle) {
        this.handle = methodHandle.asType(INVOCATION_SIGNATURE);
    }

    @Override
    ListenableFuture<RpcResult<?>> invokeOn(RpcService impl, DataObject input) {
        try {
            return this.handle.invokeExact(impl);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new IllegalStateException(e);
        }
    }
}

