/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter.query;

import com.google.common.base.Function;
import com.google.common.base.Verify;
import com.google.common.base.VerifyException;
import com.google.common.collect.Iterators;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Spliterator;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.gaul.modernizer_maven_annotations.SuppressModernizer;
import org.opendaylight.mdsal.binding.api.query.QueryResult;
import org.opendaylight.mdsal.binding.dom.adapter.query.DefaultQueryResultItem;
import org.opendaylight.mdsal.binding.dom.adapter.query.DefaultQueryResultSpliterator;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingCodecTree;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingCodecTreeNode;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingDataObjectCodecTreeNode;
import org.opendaylight.mdsal.dom.api.query.DOMQueryResult;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;

@NonNullByDefault
@SuppressModernizer
final class DefaultQueryResult<T extends DataObject>
implements QueryResult<T>,
Function<Map.Entry<YangInstanceIdentifier, NormalizedNode<?, ?>>, QueryResult.Item<T>> {
    private static final VarHandle ITEM_CODEC;
    private final DOMQueryResult domResult;
    private final BindingCodecTree codec;
    @SuppressFBWarnings(value={"NP_STORE_INTO_NONNULL_FIELD"}, justification="Ungrokked type annotation")
    private volatile @Nullable BindingDataObjectCodecTreeNode<T> itemCodec = null;

    DefaultQueryResult(BindingCodecTree codec, DOMQueryResult domResult) {
        this.codec = Objects.requireNonNull(codec);
        this.domResult = Objects.requireNonNull(domResult);
    }

    public Iterator<QueryResult.Item<T>> iterator() {
        return Iterators.transform((Iterator)this.domResult.iterator(), (Function)this);
    }

    public Spliterator<QueryResult.Item<T>> spliterator() {
        return new DefaultQueryResultSpliterator(this, this.domResult.spliterator());
    }

    public Stream<QueryResult.Item<T>> stream() {
        return this.domResult.stream().map(this);
    }

    public Stream<QueryResult.Item<T>> parallelStream() {
        return this.domResult.parallelStream().map(this);
    }

    public QueryResult.Item<T> apply(Map.Entry<YangInstanceIdentifier, NormalizedNode<?, ?>> domItem) {
        return new DefaultQueryResultItem(this, domItem);
    }

    T createObject(Map.Entry<YangInstanceIdentifier, NormalizedNode<?, ?>> domItem) {
        @Nullable BindingDataObjectCodecTreeNode<T> local = ITEM_CODEC.getAcquire(this);
        return (T)((DataObject)(local != null ? local : this.loadItemCodec(domItem.getKey())).deserialize(domItem.getValue()));
    }

    InstanceIdentifier<T> createPath(YangInstanceIdentifier domPath) {
        return (InstanceIdentifier)Verify.verifyNotNull((Object)this.codec.getInstanceIdentifierCodec().toBinding(domPath), (String)"path", (Object[])new Object[0]);
    }

    private BindingDataObjectCodecTreeNode<T> loadItemCodec(YangInstanceIdentifier domPath) {
        BindingCodecTreeNode codecNode = this.codec.getSubtreeCodec(domPath);
        if (!(codecNode instanceof BindingDataObjectCodecTreeNode)) {
            throw new VerifyException("Unexpected codec " + codecNode);
        }
        BindingDataObjectCodecTreeNode ret = (BindingDataObjectCodecTreeNode)codecNode;
        Object witness = ITEM_CODEC.compareAndExchangeRelease(this, null, ret);
        return witness == null ? ret : (BindingDataObjectCodecTreeNode)witness;
    }

    static {
        try {
            ITEM_CODEC = MethodHandles.lookup().findVarHandle(DefaultQueryResult.class, "itemCodec", BindingDataObjectCodecTreeNode.class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

