/*
 * Decompiled with CFR 0.152.
 */
package akka.persistence.snapshot.local;

import akka.actor.Actor;
import akka.actor.ActorContext;
import akka.actor.ActorLogging;
import akka.actor.ActorRef;
import akka.actor.SupervisorStrategy;
import akka.annotation.InternalApi;
import akka.dispatch.MessageDispatcher;
import akka.event.LoggingAdapter;
import akka.pattern.CircuitBreaker;
import akka.persistence.DeleteSnapshotsFailure;
import akka.persistence.DeleteSnapshotsSuccess;
import akka.persistence.Persistence;
import akka.persistence.SaveSnapshotFailure;
import akka.persistence.SaveSnapshotSuccess;
import akka.persistence.SelectedSnapshot;
import akka.persistence.SnapshotMetadata;
import akka.persistence.SnapshotMetadata$;
import akka.persistence.SnapshotSelectionCriteria;
import akka.persistence.serialization.Snapshot;
import akka.persistence.serialization.package$;
import akka.persistence.snapshot.SnapshotStore;
import akka.serialization.Serialization;
import akka.serialization.SerializationExtension$;
import akka.util.ByteString$;
import akka.util.Helpers$;
import akka.util.Helpers$Requiring$;
import com.typesafe.config.Config;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.IterableFactory;
import scala.collection.IterableFactory$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.LinearSeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0005\t}h!\u0002\u001a4\u0001]Z\u0004\u0002\u0003'\u0001\u0005\u0003\u0005\u000b\u0011\u0002(\t\u000b]\u0003A\u0011\u0001-\t\u000fq\u0003!\u0019!C\u0005;\"1a\r\u0001Q\u0001\nyCqa\u001a\u0001C\u0002\u0013%\u0001\u000e\u0003\u0004m\u0001\u0001\u0006I!\u001b\u0005\b[\u0002\u0011\r\u0011\"\u0003i\u0011\u0019q\u0007\u0001)A\u0005S\"9q\u000e\u0001b\u0001\n\u0013\u0001\bBB<\u0001A\u0003%\u0011\u000fC\u0004y\u0001\t\u0007I\u0011B=\t\u000f\u0005\u0015\u0001\u0001)A\u0005u\"I\u0011q\u0001\u0001C\u0002\u0013%\u0011\u0011\u0002\u0005\t\u0003/\u0001\u0001\u0015!\u0003\u0002\f!I\u0011\u0011\u0004\u0001A\u0002\u0013%\u00111\u0004\u0005\n\u0003k\u0001\u0001\u0019!C\u0005\u0003oA\u0001\"a\u0011\u0001A\u0003&\u0011Q\u0004\u0005\b\u0003\u000b\u0002A\u0011IA$\u0011\u001d\t)\t\u0001C!\u0003\u000fCq!a&\u0001\t\u0003\nI\nC\u0004\u0002\u0018\u0002!\t%!(\t\u000f\u0005\r\u0006\u0001\"\u0011\u0002&\"9\u00111\u0017\u0001\u0005\n\u0005U\u0006bBA`\u0001\u0011%\u0011\u0011\u0019\u0005\b\u0003;\u0004A\u0011CAp\u0011\u001d\t)\u000f\u0001C\t\u0003ODq!!@\u0001\t#\ty\u0010C\u0004\u0003\u000e\u0001!\tBa\u0004\t\u000f\t}\u0001\u0001\"\u0003\u0003\"!9!Q\b\u0001\u0005\n\t}\u0002b\u0002B0\u0001\u0011E!\u0011\r\u0005\n\u0005S\u0002\u0011\u0013!C\t\u0005WBqA! \u0001\t\u0013\u0011y\bC\u0004\u0003\u0006\u0002!\tEa\"\t\u000f\t%\u0005\u0001\"\u0003\u0003\f\"I!Q\u0012\u0001C\u0002\u0013%!q\u0012\u0005\t\u00057\u0003\u0001\u0015!\u0003\u0003\u0012\u001a1!Q\u0014\u0001\u0007\u0005?C!\"a\u0019'\u0005\u0003\u0005\u000b\u0011BA3\u0011\u00199f\u0005\"\u0001\u0003.\"I!1\u0017\u0014C\u0002\u0013\u0005!q\u0012\u0005\t\u0005k3\u0003\u0015!\u0003\u0003\u0012\"9!q\u0017\u0014\u0005\u0002\tefA\u0002Bd\u0001\u0019\u0011I\r\u0003\u0006\u0003L2\u0012\t\u0011)A\u0005\u0003[Aaa\u0016\u0017\u0005\u0002\t5\u0007b\u0002BjY\u00115!Q\u001b\u0005\b\u0005ocC\u0011\u0001Br\u0011\u001d\u0011I\u000f\u0001C\u0005\u0005W\u0014!\u0003T8dC2\u001cf.\u00199tQ>$8\u000b^8sK*\u0011A'N\u0001\u0006Y>\u001c\u0017\r\u001c\u0006\u0003m]\n\u0001b\u001d8baNDw\u000e\u001e\u0006\u0003qe\n1\u0002]3sg&\u001cH/\u001a8dK*\t!(\u0001\u0003bW.\f7\u0003\u0002\u0001=\u0005\u001a\u0003\"!\u0010!\u000e\u0003yR\u0011aP\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0003z\u0012a!\u00118z%\u00164\u0007CA\"E\u001b\u0005)\u0014BA#6\u00055\u0019f.\u00199tQ>$8\u000b^8sKB\u0011qIS\u0007\u0002\u0011*\u0011\u0011*O\u0001\u0006C\u000e$xN]\u0005\u0003\u0017\"\u0013A\"Q2u_JdunZ4j]\u001e\faaY8oM&<7\u0001\u0001\t\u0003\u001fVk\u0011\u0001\u0015\u0006\u0003\u0019FS!AU*\u0002\u0011QL\b/Z:bM\u0016T\u0011\u0001V\u0001\u0004G>l\u0017B\u0001,Q\u0005\u0019\u0019uN\u001c4jO\u00061A(\u001b8jiz\"\"!W.\u0011\u0005i\u0003Q\"A\u001a\t\u000b1\u0013\u0001\u0019\u0001(\u0002\u001f\u0019KG.\u001a8b[\u0016\u0004\u0016\r\u001e;fe:,\u0012A\u0018\t\u0003?\u0012l\u0011\u0001\u0019\u0006\u0003C\n\f\u0001\"\\1uG\"Lgn\u001a\u0006\u0003Gz\nA!\u001e;jY&\u0011Q\r\u0019\u0002\u0006%\u0016<W\r_\u0001\u0011\r&dWM\\1nKB\u000bG\u000f^3s]\u0002\nQ\u0003]3sg&\u001cH/\u001a8dK&#7\u000b^1si&#\u00070F\u0001j!\ti$.\u0003\u0002l}\t\u0019\u0011J\u001c;\u0002-A,'o]5ti\u0016t7-Z%e'R\f'\u000f^%eq\u0002\nq\"\\1y\u0019>\fG-\u0011;uK6\u0004Ho]\u0001\u0011[\u0006DHj\\1e\u0003R$X-\u001c9ug\u0002\n\u0001c\u001d;sK\u0006lG)[:qCR\u001c\u0007.\u001a:\u0016\u0003E\u0004\"A];\u000e\u0003MT!\u0001^\u001d\u0002\u0011\u0011L7\u000f]1uG\"L!A^:\u0003#5+7o]1hK\u0012K7\u000f]1uG\",'/A\ttiJ,\u0017-\u001c#jgB\fGo\u00195fe\u0002\n1\u0001Z5s+\u0005Q\bcA>\u0002\u00025\tAP\u0003\u0002~}\u0006\u0011\u0011n\u001c\u0006\u0002\u007f\u0006!!.\u0019<b\u0013\r\t\u0019\u0001 \u0002\u0005\r&dW-\u0001\u0003eSJ\u0004\u0013AF:fe&\fG.\u001b>bi&|g.\u0012=uK:\u001c\u0018n\u001c8\u0016\u0005\u0005-\u0001\u0003BA\u0007\u0003'i!!a\u0004\u000b\u0007\u0005E\u0011(A\u0007tKJL\u0017\r\\5{CRLwN\\\u0005\u0005\u0003+\tyAA\u0007TKJL\u0017\r\\5{CRLwN\\\u0001\u0018g\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8FqR,gn]5p]\u0002\naa]1wS:<WCAA\u000f!\u0019\ty\"!\u000b\u0002.5\u0011\u0011\u0011\u0005\u0006\u0005\u0003G\t)#A\u0005j[6,H/\u00192mK*\u0019\u0011q\u0005 \u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002,\u0005\u0005\"aA*fiB!\u0011qFA\u0019\u001b\u00059\u0014bAA\u001ao\t\u00012K\\1qg\"|G/T3uC\u0012\fG/Y\u0001\u000bg\u00064\u0018N\\4`I\u0015\fH\u0003BA\u001d\u0003\u007f\u00012!PA\u001e\u0013\r\tiD\u0010\u0002\u0005+:LG\u000fC\u0005\u0002BA\t\t\u00111\u0001\u0002\u001e\u0005\u0019\u0001\u0010J\u0019\u0002\u000fM\fg/\u001b8hA\u0005IAn\\1e\u0003NLhn\u0019\u000b\u0007\u0003\u0013\n\t'a\u001f\u0011\r\u0005-\u0013\u0011KA+\u001b\t\tiEC\u0002\u0002Py\n!bY8oGV\u0014(/\u001a8u\u0013\u0011\t\u0019&!\u0014\u0003\r\u0019+H/\u001e:f!\u0015i\u0014qKA.\u0013\r\tIF\u0010\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005=\u0012QL\u0005\u0004\u0003?:$\u0001E*fY\u0016\u001cG/\u001a3T]\u0006\u00048\u000f[8u\u0011\u001d\t\u0019G\u0005a\u0001\u0003K\nQ\u0002]3sg&\u001cH/\u001a8dK&#\u0007\u0003BA4\u0003krA!!\u001b\u0002rA\u0019\u00111\u000e \u000e\u0005\u00055$bAA8\u001b\u00061AH]8pizJ1!a\u001d?\u0003\u0019\u0001&/\u001a3fM&!\u0011qOA=\u0005\u0019\u0019FO]5oO*\u0019\u00111\u000f \t\u000f\u0005u$\u00031\u0001\u0002\u0000\u0005A1M]5uKJL\u0017\r\u0005\u0003\u00020\u0005\u0005\u0015bAABo\tI2K\\1qg\"|GoU3mK\u000e$\u0018n\u001c8De&$XM]5b\u0003%\u0019\u0018M^3Bgft7\r\u0006\u0004\u0002\n\u0006-\u0015q\u0012\t\u0007\u0003\u0017\n\t&!\u000f\t\u000f\u000555\u00031\u0001\u0002.\u0005AQ.\u001a;bI\u0006$\u0018\r\u0003\u00047'\u0001\u0007\u0011\u0011\u0013\t\u0004{\u0005M\u0015bAAK}\t\u0019\u0011I\\=\u0002\u0017\u0011,G.\u001a;f\u0003NLhn\u0019\u000b\u0005\u0003\u0013\u000bY\nC\u0004\u0002\u000eR\u0001\r!!\f\u0015\r\u0005%\u0015qTAQ\u0011\u001d\t\u0019'\u0006a\u0001\u0003KBq!! \u0016\u0001\u0004\ty(A\u000bsK\u000e,\u0017N^3QYV<\u0017N\\%oi\u0016\u0014h.\u00197\u0016\u0005\u0005\u001d\u0006\u0003BAU\u0003Wk\u0011\u0001A\u0005\u0005\u0003[\u000byKA\u0004SK\u000e,\u0017N^3\n\u0007\u0005E\u0006JA\u0003BGR|'/A\u0007t]\u0006\u00048\u000f[8u\r&dWm\u001d\u000b\u0005\u0003o\u000bi\fE\u0003\u0002 \u0005e&0\u0003\u0003\u0002<\u0006\u0005\"aA*fc\"9\u0011QR\fA\u0002\u00055\u0012\u0001\u00027pC\u0012$B!a1\u0002LB1\u0011QYAd\u0003+j\u0011AY\u0005\u0004\u0003\u0013\u0014'a\u0001+ss\"9\u0011Q\u0012\rA\u0002\u00055\u0007CBA\u0010\u0003s\u000bi\u0003K\u0002\u0019\u0003#\u0004B!a5\u0002Z6\u0011\u0011Q\u001b\u0006\u0004\u0003/t\u0014AC1o]>$\u0018\r^5p]&!\u00111\\Ak\u0005\u001d!\u0018-\u001b7sK\u000e\fAa]1wKR1\u0011\u0011HAq\u0003GDq!!$\u001a\u0001\u0004\ti\u0003\u0003\u000473\u0001\u0007\u0011\u0011S\u0001\fI\u0016\u001cXM]5bY&TX\r\u0006\u0003\u0002j\u0006M\b\u0003BAv\u0003_l!!!<\u000b\u0007\u0005Eq'\u0003\u0003\u0002r\u00065(\u0001C*oCB\u001c\bn\u001c;\t\u000f\u0005U(\u00041\u0001\u0002x\u0006Y\u0011N\u001c9viN#(/Z1n!\rY\u0018\u0011`\u0005\u0004\u0003wd(aC%oaV$8\u000b\u001e:fC6\f\u0011b]3sS\u0006d\u0017N_3\u0015\r\u0005e\"\u0011\u0001B\u0006\u0011\u001d\u0011\u0019a\u0007a\u0001\u0005\u000b\tAb\\;uaV$8\u000b\u001e:fC6\u00042a\u001fB\u0004\u0013\r\u0011I\u0001 \u0002\r\u001fV$\b/\u001e;TiJ,\u0017-\u001c\u0005\u0007mm\u0001\r!!;\u0002!]LG\u000f[(viB,Ho\u0015;sK\u0006lG\u0003\u0002B\t\u0005;!2A\u001fB\n\u0011\u001d\u0011)\u0002\ba\u0001\u0005/\t\u0011\u0001\u001d\t\b{\te!QAA\u001d\u0013\r\u0011YB\u0010\u0002\n\rVt7\r^5p]FBq!!$\u001d\u0001\u0004\ti#A\bxSRD\u0017J\u001c9viN#(/Z1n+\u0011\u0011\u0019Ca\u000b\u0015\t\t\u0015\"1\b\u000b\u0005\u0005O\u00119\u0004\u0005\u0003\u0003*\t-B\u0002\u0001\u0003\b\u0005[i\"\u0019\u0001B\u0018\u0005\u0005!\u0016\u0003\u0002B\u0019\u0003#\u00032!\u0010B\u001a\u0013\r\u0011)D\u0010\u0002\b\u001d>$\b.\u001b8h\u0011\u001d\u0011)\"\ba\u0001\u0005s\u0001r!\u0010B\r\u0003o\u00149\u0003C\u0004\u0002\u000ev\u0001\r!!\f\u0002\u0015]LG\u000f[*ue\u0016\fW.\u0006\u0004\u0003B\t=#Q\t\u000b\u0007\u0005\u0007\u0012IEa\u0017\u0011\t\t%\"Q\t\u0003\b\u0005\u000fr\"\u0019\u0001B\u0018\u0005\u0005\u0011\u0005b\u0002B&=\u0001\u0007!QJ\u0001\u0007gR\u0014X-Y7\u0011\t\t%\"q\n\u0003\b\u0005#r\"\u0019\u0001B*\u0005\u0005\t\u0015\u0003\u0002B\u0019\u0005+\u00022a\u001fB,\u0013\r\u0011I\u0006 \u0002\n\u00072|7/Z1cY\u0016DqA!\u0006\u001f\u0001\u0004\u0011i\u0006E\u0004>\u00053\u0011iEa\u0011\u0002)Mt\u0017\r]:i_R4\u0015\u000e\\3G_J<&/\u001b;f)\u0015Q(1\rB3\u0011\u001d\tii\ba\u0001\u0003[A\u0011Ba\u001a !\u0003\u0005\r!!\u001a\u0002\u0013\u0015DH/\u001a8tS>t\u0017AH:oCB\u001c\bn\u001c;GS2,gi\u001c:Xe&$X\r\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011iG\u000b\u0003\u0002f\t=4F\u0001B9!\u0011\u0011\u0019H!\u001f\u000e\u0005\tU$\u0002\u0002B<\u0003+\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\n\t\tm$Q\u000f\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017!E:oCB\u001c\bn\u001c;NKR\fG-\u0019;bgR1\u0011Q\u001aBA\u0005\u0007Cq!a\u0019\"\u0001\u0004\t)\u0007C\u0004\u0002~\u0005\u0002\r!a \u0002\u0011A\u0014Xm\u0015;beR$\"!!\u000f\u0002\u0017Mt\u0017\r]:i_R$\u0015N\u001d\u000b\u0002u\u0006)B-\u001a4bk2$8+_:uK6,enY8eS:<WC\u0001BI!\u0011\u0011\u0019J!'\u000e\u0005\tU%b\u0001BL}\u0006!A.\u00198h\u0013\u0011\t9H!&\u0002-\u0011,g-Y;miNK8\u000f^3n\u000b:\u001cw\u000eZ5oO\u0002\u0012ac\u00158baNDw\u000e\u001e$jY\u0016t\u0017-\\3GS2$XM]\n\u0006M\t\u0005&q\u0015\t\u0005\u0005'\u0013\u0019+\u0003\u0003\u0003&\nU%AB(cU\u0016\u001cG\u000fE\u0002|\u0005SK1Aa+}\u000591\u0015\u000e\\3oC6,g)\u001b7uKJ$BAa,\u00032B\u0019\u0011\u0011\u0016\u0014\t\u000f\u0005\r\u0004\u00061\u0001\u0002f\u0005!RM\\2pI\u0016$\u0007+\u001a:tSN$XM\\2f\u0013\u0012\fQ#\u001a8d_\u0012,G\rU3sg&\u001cH/\u001a8dK&#\u0007%\u0001\u0004bG\u000e,\u0007\u000f\u001e\u000b\u0007\u0005w\u0013\tMa1\u0011\u0007u\u0012i,C\u0002\u0003@z\u0012qAQ8pY\u0016\fg\u000eC\u0003yW\u0001\u0007!\u0010C\u0004\u0003F.\u0002\r!!\u001a\u0002\t9\fW.\u001a\u0002\u001c':\f\u0007o\u001d5piN+\u0017O\u0014:GS2,g.Y7f\r&dG/\u001a:\u0014\u000b1\u0012\tKa*\u0002\u00055$G\u0003\u0002Bh\u0005#\u00042!!+-\u0011\u001d\u0011YM\fa\u0001\u0003[\tq!\\1uG\",7\u000f\u0006\u0005\u0003<\n]'1\u001cBp\u0011\u001d\u0011In\fa\u0001\u0003K\n1\u0001]5e\u0011\u001d\u0011in\fa\u0001\u0003K\n1a\u001d8s\u0011\u001d\u0011\to\fa\u0001\u0003K\n1\u0001^7t)\u0019\u0011YL!:\u0003h\")\u0001\u0010\ra\u0001u\"9!Q\u0019\u0019A\u0002\u0005\u0015\u0014aD3yiJ\f7\r^'fi\u0006$\u0017\r^1\u0015\t\t5(1 \t\u0006{\u0005]#q\u001e\t\n{\tE\u0018Q\rB{\u0005kL1Aa=?\u0005\u0019!V\u000f\u001d7fgA\u0019QHa>\n\u0007\tehH\u0001\u0003M_:<\u0007b\u0002B\u007fc\u0001\u0007\u0011QM\u0001\tM&dWM\\1nK\u0002")
public class LocalSnapshotStore
implements SnapshotStore {
    private final Regex akka$persistence$snapshot$local$LocalSnapshotStore$$FilenamePattern;
    private final int akka$persistence$snapshot$local$LocalSnapshotStore$$persistenceIdStartIdx;
    private final int maxLoadAttempts;
    private final MessageDispatcher streamDispatcher;
    private final File dir;
    private final Serialization serializationExtension;
    private Set<SnapshotMetadata> akka$persistence$snapshot$local$LocalSnapshotStore$$saving;
    private final String akka$persistence$snapshot$local$LocalSnapshotStore$$defaultSystemEncoding;
    private Persistence akka$persistence$snapshot$SnapshotStore$$extension;
    private boolean akka$persistence$snapshot$SnapshotStore$$publish;
    private CircuitBreaker akka$persistence$snapshot$SnapshotStore$$breaker;
    private PartialFunction<Object, BoxedUnit> receiveSnapshotStore;
    private LoggingAdapter akka$actor$ActorLogging$$_log;
    private ActorContext context;
    private ActorRef self;

    @Override
    public final PartialFunction<Object, BoxedUnit> receive() {
        return SnapshotStore.receive$(this);
    }

    @Override
    public LoggingAdapter log() {
        return ActorLogging.log$(this);
    }

    @Override
    public final ActorRef sender() {
        return Actor.sender$(this);
    }

    @Override
    @InternalApi
    public void aroundReceive(PartialFunction<Object, BoxedUnit> receive2, Object msg) {
        Actor.aroundReceive$(this, receive2, msg);
    }

    @Override
    @InternalApi
    public void aroundPreStart() {
        Actor.aroundPreStart$(this);
    }

    @Override
    @InternalApi
    public void aroundPostStop() {
        Actor.aroundPostStop$(this);
    }

    @Override
    @InternalApi
    public void aroundPreRestart(Throwable reason, Option<Object> message) {
        Actor.aroundPreRestart$(this, reason, message);
    }

    @Override
    @InternalApi
    public void aroundPostRestart(Throwable reason) {
        Actor.aroundPostRestart$(this, reason);
    }

    @Override
    public SupervisorStrategy supervisorStrategy() {
        return Actor.supervisorStrategy$(this);
    }

    @Override
    public void postStop() throws Exception {
        Actor.postStop$(this);
    }

    @Override
    public void preRestart(Throwable reason, Option<Object> message) throws Exception {
        Actor.preRestart$(this, reason, message);
    }

    @Override
    public void postRestart(Throwable reason) throws Exception {
        Actor.postRestart$(this, reason);
    }

    @Override
    public void unhandled(Object message) {
        Actor.unhandled$(this, message);
    }

    @Override
    public Persistence akka$persistence$snapshot$SnapshotStore$$extension() {
        return this.akka$persistence$snapshot$SnapshotStore$$extension;
    }

    @Override
    public boolean akka$persistence$snapshot$SnapshotStore$$publish() {
        return this.akka$persistence$snapshot$SnapshotStore$$publish;
    }

    @Override
    public CircuitBreaker akka$persistence$snapshot$SnapshotStore$$breaker() {
        return this.akka$persistence$snapshot$SnapshotStore$$breaker;
    }

    @Override
    public final PartialFunction<Object, BoxedUnit> receiveSnapshotStore() {
        return this.receiveSnapshotStore;
    }

    @Override
    public final void akka$persistence$snapshot$SnapshotStore$_setter_$akka$persistence$snapshot$SnapshotStore$$extension_$eq(Persistence x$1) {
        this.akka$persistence$snapshot$SnapshotStore$$extension = x$1;
    }

    @Override
    public final void akka$persistence$snapshot$SnapshotStore$_setter_$akka$persistence$snapshot$SnapshotStore$$publish_$eq(boolean x$1) {
        this.akka$persistence$snapshot$SnapshotStore$$publish = x$1;
    }

    @Override
    public final void akka$persistence$snapshot$SnapshotStore$_setter_$akka$persistence$snapshot$SnapshotStore$$breaker_$eq(CircuitBreaker x$1) {
        this.akka$persistence$snapshot$SnapshotStore$$breaker = x$1;
    }

    @Override
    public final void akka$persistence$snapshot$SnapshotStore$_setter_$receiveSnapshotStore_$eq(PartialFunction<Object, BoxedUnit> x$1) {
        this.receiveSnapshotStore = x$1;
    }

    @Override
    public LoggingAdapter akka$actor$ActorLogging$$_log() {
        return this.akka$actor$ActorLogging$$_log;
    }

    @Override
    public void akka$actor$ActorLogging$$_log_$eq(LoggingAdapter x$1) {
        this.akka$actor$ActorLogging$$_log = x$1;
    }

    @Override
    public ActorContext context() {
        return this.context;
    }

    @Override
    public final ActorRef self() {
        return this.self;
    }

    @Override
    public void akka$actor$Actor$_setter_$context_$eq(ActorContext x$1) {
        this.context = x$1;
    }

    @Override
    public final void akka$actor$Actor$_setter_$self_$eq(ActorRef x$1) {
        this.self = x$1;
    }

    public Regex akka$persistence$snapshot$local$LocalSnapshotStore$$FilenamePattern() {
        return this.akka$persistence$snapshot$local$LocalSnapshotStore$$FilenamePattern;
    }

    public int akka$persistence$snapshot$local$LocalSnapshotStore$$persistenceIdStartIdx() {
        return this.akka$persistence$snapshot$local$LocalSnapshotStore$$persistenceIdStartIdx;
    }

    private int maxLoadAttempts() {
        return this.maxLoadAttempts;
    }

    private MessageDispatcher streamDispatcher() {
        return this.streamDispatcher;
    }

    private File dir() {
        return this.dir;
    }

    private Serialization serializationExtension() {
        return this.serializationExtension;
    }

    public Set<SnapshotMetadata> akka$persistence$snapshot$local$LocalSnapshotStore$$saving() {
        return this.akka$persistence$snapshot$local$LocalSnapshotStore$$saving;
    }

    public void akka$persistence$snapshot$local$LocalSnapshotStore$$saving_$eq(Set<SnapshotMetadata> x$1) {
        this.akka$persistence$snapshot$local$LocalSnapshotStore$$saving = x$1;
    }

    @Override
    public Future<Option<SelectedSnapshot>> loadAsync(String persistenceId, SnapshotSelectionCriteria criteria) {
        Seq metadata = (Seq)((IterableOps)this.snapshotMetadatas(persistenceId, criteria).sorted(SnapshotMetadata$.MODULE$.ordering())).takeRight(this.maxLoadAttempts());
        return Future$.MODULE$.apply((Function0 & Serializable)() -> {
            Option s;
            Try<Option<SelectedSnapshot>> try_ = this.load((Seq<SnapshotMetadata>)metadata);
            if (!(try_ instanceof Success)) {
                if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable e = failure.exception();
                    throw e;
                }
                throw new MatchError(try_);
            }
            Success success = (Success)try_;
            Option option = s = (Option)success.value();
            return option;
        }, (ExecutionContext)this.streamDispatcher());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Future<BoxedUnit> saveAsync(SnapshotMetadata metadata, Object snapshot) {
        void var3_3;
        this.akka$persistence$snapshot$local$LocalSnapshotStore$$saving_$eq((Set<SnapshotMetadata>)((Set)this.akka$persistence$snapshot$local$LocalSnapshotStore$$saving().$plus((Object)metadata)));
        Future completion = Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> this.save(metadata, snapshot), (ExecutionContext)this.streamDispatcher());
        return var3_3;
    }

    @Override
    public Future<BoxedUnit> deleteAsync(SnapshotMetadata metadata) {
        this.akka$persistence$snapshot$local$LocalSnapshotStore$$saving_$eq((Set<SnapshotMetadata>)((Set)this.akka$persistence$snapshot$local$LocalSnapshotStore$$saving().$minus((Object)metadata)));
        return Future$.MODULE$.apply((Function0 & Serializable)() -> (Seq)this.snapshotFiles(metadata).map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.delete())), (ExecutionContext)this.streamDispatcher()).map((Function1 & Serializable)x$3 -> {
            LocalSnapshotStore.$anonfun$deleteAsync$3(x$3);
            return BoxedUnit.UNIT;
        }, (ExecutionContext)this.streamDispatcher());
    }

    @Override
    public Future<BoxedUnit> deleteAsync(String persistenceId, SnapshotSelectionCriteria criteria) {
        Seq<SnapshotMetadata> metadatas = this.snapshotMetadatas(persistenceId, criteria);
        return Future$.MODULE$.sequence((IterableOnce)metadatas.map((Function1 & Serializable)metadata -> this.deleteAsync((SnapshotMetadata)metadata)), IterableFactory$.MODULE$.toBuildFrom((IterableFactory)IndexedSeq$.MODULE$), (ExecutionContext)this.streamDispatcher()).map((Function1 & Serializable)x$4 -> {
            LocalSnapshotStore.$anonfun$deleteAsync$5(x$4);
            return BoxedUnit.UNIT;
        }, (ExecutionContext)this.streamDispatcher());
    }

    @Override
    public PartialFunction<Object, BoxedUnit> receivePluginInternal() {
        return new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ LocalSnapshotStore $outer;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof SaveSnapshotSuccess) {
                    SaveSnapshotSuccess saveSnapshotSuccess = (SaveSnapshotSuccess)A1;
                    SnapshotMetadata metadata = saveSnapshotSuccess.metadata();
                    this.$outer.akka$persistence$snapshot$local$LocalSnapshotStore$$saving_$eq((Set<SnapshotMetadata>)((Set)this.$outer.akka$persistence$snapshot$local$LocalSnapshotStore$$saving().$minus((Object)metadata)));
                    object = BoxedUnit.UNIT;
                } else {
                    object = A1 instanceof SaveSnapshotFailure ? BoxedUnit.UNIT : (A1 instanceof DeleteSnapshotsSuccess ? BoxedUnit.UNIT : (A1 instanceof DeleteSnapshotsFailure ? BoxedUnit.UNIT : function1.apply(x1)));
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                boolean bl = object instanceof SaveSnapshotSuccess ? true : (object instanceof SaveSnapshotFailure ? true : (object instanceof DeleteSnapshotsSuccess ? true : object instanceof DeleteSnapshotsFailure));
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    private Seq<File> snapshotFiles(SnapshotMetadata metadata) {
        return Predef$.MODULE$.wrapRefArray((Object[])this.snapshotDir().listFiles(new SnapshotSeqNrFilenameFilter(this, metadata))).toVector();
    }

    private Try<Option<SelectedSnapshot>> load(Seq<SnapshotMetadata> metadata) {
        Success success;
        block3: {
            Option option;
            block4: {
                Success success2;
                block5: {
                    Try try_;
                    block6: {
                        Throwable e;
                        while (true) {
                            if (None$.MODULE$.equals(option = metadata.lastOption())) {
                                success = new Success((Object)None$.MODULE$);
                                break block3;
                            }
                            if (!(option instanceof Some)) break block4;
                            Some some = (Some)option;
                            SnapshotMetadata md = (SnapshotMetadata)some.value();
                            try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> (Snapshot)this.withInputStream(md, (Function1 & Serializable)inputStream -> this.deserialize((InputStream)inputStream)));
                            if (try_ instanceof Success) {
                                Success success3 = (Success)try_;
                                Snapshot s = (Snapshot)success3.value();
                                success2 = new Success((Object)new Some((Object)new SelectedSnapshot(md, s.data())));
                                break block5;
                            }
                            if (!(try_ instanceof Failure)) break block6;
                            Failure failure = (Failure)try_;
                            e = failure.exception();
                            Seq remaining = (Seq)metadata.init();
                            this.log().error(e, "Error loading snapshot [{}], remaining attempts: [{}]", (Object)md, (Object)BoxesRunTime.boxToInteger((int)remaining.size()));
                            if (remaining.isEmpty()) break;
                            metadata = remaining;
                        }
                        success2 = new Failure(e);
                        break block5;
                    }
                    throw new MatchError((Object)try_);
                }
                success = success2;
                break block3;
            }
            throw new MatchError((Object)option);
        }
        return success;
    }

    public void save(SnapshotMetadata metadata, Object snapshot) {
        File tmpFile = this.withOutputStream(metadata, (Function1<OutputStream, BoxedUnit>)(Function1 & Serializable)x$5 -> {
            this.serialize(x$5, new Snapshot(snapshot));
            return BoxedUnit.UNIT;
        });
        tmpFile.renameTo(this.snapshotFileForWrite(metadata, this.snapshotFileForWrite$default$2()));
    }

    public Snapshot deserialize(InputStream inputStream) {
        return (Snapshot)this.serializationExtension().deserialize(package$.MODULE$.streamToBytes(inputStream), Snapshot.class).get();
    }

    public void serialize(OutputStream outputStream, Snapshot snapshot) {
        outputStream.write((byte[])this.serializationExtension().serialize(snapshot).get());
    }

    /*
     * WARNING - void declaration
     */
    public File withOutputStream(SnapshotMetadata metadata, Function1<OutputStream, BoxedUnit> p) {
        void var3_3;
        File tmpFile = this.snapshotFileForWrite(metadata, "tmp");
        this.withStream(new BufferedOutputStream(Files.newOutputStream(tmpFile.toPath(), new OpenOption[0])), p);
        return var3_3;
    }

    private <T> T withInputStream(SnapshotMetadata metadata, Function1<InputStream, T> p) {
        return this.withStream(new BufferedInputStream(Files.newInputStream(this.snapshotFileForWrite(metadata, this.snapshotFileForWrite$default$2()).toPath(), new OpenOption[0])), p);
    }

    private <A extends Closeable, B> B withStream(A stream, Function1<A, B> p) {
        Object object;
        try {
            object = p.apply(stream);
        }
        finally {
            stream.close();
        }
        return (B)object;
    }

    public File snapshotFileForWrite(SnapshotMetadata metadata, String extension) {
        return new File(this.snapshotDir(), new StringBuilder(11).append("snapshot-").append(URLEncoder.encode(metadata.persistenceId(), ByteString$.MODULE$.UTF_8())).append("-").append(metadata.sequenceNr()).append("-").append(metadata.timestamp()).append(extension).toString());
    }

    public String snapshotFileForWrite$default$2() {
        return "";
    }

    private Seq<SnapshotMetadata> snapshotMetadatas(String persistenceId, SnapshotSelectionCriteria criteria) {
        File[] files = this.snapshotDir().listFiles(new SnapshotFilenameFilter(persistenceId));
        return files == null ? scala.package$.MODULE$.Nil() : Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])files), (Function1 & Serializable)x$6 -> x$6.getName(), ClassTag$.MODULE$.apply(String.class))), (Function1 & Serializable)filename -> this.extractMetadata((String)filename).map((Function1 & Serializable)x0$1 -> {
            Tuple3 tuple3 = x0$1;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            String pid = (String)tuple3._1();
            long snr = BoxesRunTime.unboxToLong((Object)tuple3._2());
            long tms = BoxesRunTime.unboxToLong((Object)tuple3._3());
            SnapshotMetadata snapshotMetadata = SnapshotMetadata$.MODULE$.apply(URLDecoder.decode(pid, ByteString$.MODULE$.UTF_8()), snr, tms);
            return snapshotMetadata;
        }), ClassTag$.MODULE$.apply(SnapshotMetadata.class))), (Function1 & Serializable)md -> BoxesRunTime.boxToBoolean((boolean)LocalSnapshotStore.$anonfun$snapshotMetadatas$4(this, criteria, md)))).toVector();
    }

    @Override
    public void preStart() {
        this.snapshotDir();
        Actor.preStart$(this);
    }

    private File snapshotDir() {
        if (!(this.dir().isDirectory() || this.dir().mkdirs() || this.dir().isDirectory())) {
            throw new IOException(new StringBuilder(38).append("Failed to create snapshot directory [").append(this.dir().getCanonicalPath()).append("]").toString());
        }
        return this.dir();
    }

    public String akka$persistence$snapshot$local$LocalSnapshotStore$$defaultSystemEncoding() {
        return this.akka$persistence$snapshot$local$LocalSnapshotStore$$defaultSystemEncoding;
    }

    private Option<Tuple3<String, Object, Object>> extractMetadata(String filename) {
        None$ none$;
        int sequenceNumberEndIdx = filename.lastIndexOf(45);
        int persistenceIdEndIdx = filename.lastIndexOf(45, sequenceNumberEndIdx - 1);
        String timestampString = filename.substring(sequenceNumberEndIdx + 1);
        if (this.akka$persistence$snapshot$local$LocalSnapshotStore$$persistenceIdStartIdx() >= persistenceIdEndIdx || StringOps$.MODULE$.exists$extension(Predef$.MODULE$.augmentString(timestampString), (Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)LocalSnapshotStore.$anonfun$extractMetadata$1(BoxesRunTime.unboxToChar((Object)x$7))))) {
            none$ = None$.MODULE$;
        } else {
            String persistenceId = filename.substring(this.akka$persistence$snapshot$local$LocalSnapshotStore$$persistenceIdStartIdx(), persistenceIdEndIdx);
            long sequenceNumber = StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(filename.substring(persistenceIdEndIdx + 1, sequenceNumberEndIdx)));
            long timestamp = StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(filename.substring(sequenceNumberEndIdx + 1)));
            none$ = new Some((Object)new Tuple3((Object)persistenceId, (Object)BoxesRunTime.boxToLong((long)sequenceNumber), (Object)BoxesRunTime.boxToLong((long)timestamp)));
        }
        return none$;
    }

    public static final /* synthetic */ void $anonfun$deleteAsync$3(Seq x$3) {
    }

    public static final /* synthetic */ void $anonfun$deleteAsync$5(IndexedSeq x$4) {
    }

    public static final /* synthetic */ boolean $anonfun$snapshotMetadatas$4(LocalSnapshotStore $this, SnapshotSelectionCriteria criteria$1, SnapshotMetadata md) {
        return criteria$1.matches(md) && !$this.akka$persistence$snapshot$local$LocalSnapshotStore$$saving().contains((Object)md);
    }

    public static final /* synthetic */ boolean $anonfun$extractMetadata$1(char x$7) {
        return !RichChar$.MODULE$.isDigit$extension(Predef$.MODULE$.charWrapper(x$7));
    }

    public LocalSnapshotStore(Config config) {
        Actor.$init$(this);
        ActorLogging.$init$(this);
        SnapshotStore.$init$(this);
        this.akka$persistence$snapshot$local$LocalSnapshotStore$$FilenamePattern = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^snapshot-(.+)-(\\d+)-(\\d+)"));
        this.akka$persistence$snapshot$local$LocalSnapshotStore$$persistenceIdStartIdx = 9;
        this.maxLoadAttempts = BoxesRunTime.unboxToInt((Object)Helpers$Requiring$.MODULE$.requiring$extension(Helpers$.MODULE$.Requiring(BoxesRunTime.boxToInteger((int)config.getInt("max-load-attempts"))), (JFunction1.mcZI.sp & Serializable)x$1 -> x$1 > 1, (Function0<Object>)(Function0 & Serializable)() -> "max-load-attempts must be >= 1"));
        this.streamDispatcher = this.context().system().dispatchers().lookup(config.getString("stream-dispatcher"));
        this.dir = new File(config.getString("dir"));
        this.serializationExtension = (Serialization)SerializationExtension$.MODULE$.apply(this.context().system());
        this.akka$persistence$snapshot$local$LocalSnapshotStore$$saving = Set$.MODULE$.empty();
        this.akka$persistence$snapshot$local$LocalSnapshotStore$$defaultSystemEncoding = System.getProperty("file.encoding");
        Statics.releaseFence();
    }

    private final class SnapshotFilenameFilter
    implements FilenameFilter {
        private final String encodedPersistenceId;

        public String encodedPersistenceId() {
            return this.encodedPersistenceId;
        }

        @Override
        public boolean accept(File dir, String name) {
            int persistenceIdEndIdx = name.lastIndexOf(45, name.lastIndexOf(45) - 1);
            return LocalSnapshotStore.this.akka$persistence$snapshot$local$LocalSnapshotStore$$persistenceIdStartIdx() + this.encodedPersistenceId().length() == persistenceIdEndIdx && name.startsWith(this.encodedPersistenceId(), LocalSnapshotStore.this.akka$persistence$snapshot$local$LocalSnapshotStore$$persistenceIdStartIdx());
        }

        public SnapshotFilenameFilter(String persistenceId) {
            if (LocalSnapshotStore.this == null) {
                throw null;
            }
            this.encodedPersistenceId = URLEncoder.encode(persistenceId, LocalSnapshotStore.this.akka$persistence$snapshot$local$LocalSnapshotStore$$defaultSystemEncoding());
        }
    }

    private final class SnapshotSeqNrFilenameFilter
    implements FilenameFilter {
        private final SnapshotMetadata md;
        private final /* synthetic */ LocalSnapshotStore $outer;

        private final boolean matches(String pid, String snr, String tms) {
            return pid.equals(URLEncoder.encode(this.md.persistenceId(), this.$outer.akka$persistence$snapshot$local$LocalSnapshotStore$$defaultSystemEncoding())) && BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable)() -> StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(snr)) == $this.md.sequenceNr() && ($this.md.timestamp() == 0L || StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(tms)) == $this.md.timestamp())).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false));
        }

        @Override
        public boolean accept(File dir, String name) {
            boolean bl;
            Option option;
            String string = name;
            if (string != null && !(option = this.$outer.akka$persistence$snapshot$local$LocalSnapshotStore$$FilenamePattern().unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(3) == 0) {
                String pid = (String)((LinearSeqOps)option.get()).apply(0);
                String snr = (String)((LinearSeqOps)option.get()).apply(1);
                String tms = (String)((LinearSeqOps)option.get()).apply(2);
                bl = this.matches(pid, snr, tms);
            } else {
                bl = false;
            }
            return bl;
        }

        public SnapshotSeqNrFilenameFilter(LocalSnapshotStore $outer, SnapshotMetadata md) {
            this.md = md;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

