/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.rfc8528.data.api;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.net.URI;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNullByDefault;

@Beta
@NonNullByDefault
public final class YangLibraryConstants {
    public static final URI MODULE_NAMESPACE = URI.create("urn:ietf:params:xml:ns:yang:ietf-yang-library");
    public static final String MODULE_NAME = "ietf-yang-library";

    private YangLibraryConstants() {
    }

    public static enum ContainerName {
        RFC8525("yang-library"),
        RFC7895("modules-state");

        private static final ImmutableMap<String, ContainerName> NAME_TO_ENUM;
        private final String localName;

        private ContainerName(String localName) {
            this.localName = Objects.requireNonNull(localName);
        }

        public String getLocalName() {
            return this.localName;
        }

        public static Optional<ContainerName> forLocalName(String localName) {
            return Optional.ofNullable((ContainerName)((Object)NAME_TO_ENUM.get((Object)Objects.requireNonNull(localName))));
        }

        static {
            NAME_TO_ENUM = Maps.uniqueIndex(Arrays.asList(ContainerName.values()), ContainerName::getLocalName);
        }
    }
}

