/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.blueprint.ext;

import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import org.opendaylight.controller.blueprint.ext.RpcUtil;
import org.opendaylight.mdsal.binding.api.RpcProviderService;
import org.opendaylight.mdsal.dom.api.DOMRpcIdentifier;
import org.opendaylight.mdsal.dom.api.DOMRpcImplementationNotAvailableException;
import org.opendaylight.mdsal.dom.api.DOMRpcProviderService;
import org.opendaylight.mdsal.dom.api.DOMSchemaService;
import org.opendaylight.mdsal.dom.spi.RpcRoutingStrategy;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.util.concurrent.FluentFutures;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.osgi.framework.Bundle;
import org.osgi.service.blueprint.container.ComponentDefinitionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionProviderBean {
    static final String ACTION_PROVIDER = "action-provider";
    private static final Logger LOG = LoggerFactory.getLogger(ActionProviderBean.class);
    private DOMRpcProviderService domRpcProvider;
    private RpcProviderService bindingRpcProvider;
    private DOMSchemaService schemaService;
    private RpcService implementation;
    private String interfaceName;
    private Registration reg;
    private Bundle bundle;

    public void setBundle(Bundle bundle) {
        this.bundle = bundle;
    }

    public void setInterfaceName(String interfaceName) {
        this.interfaceName = interfaceName;
    }

    public void setImplementation(RpcService implementation) {
        this.implementation = implementation;
    }

    public void setDomRpcProvider(DOMRpcProviderService rpcProviderService) {
        this.domRpcProvider = rpcProviderService;
    }

    public void setBindingRpcProvider(RpcProviderService rpcProvider) {
        this.bindingRpcProvider = rpcProvider;
    }

    public void setSchemaService(DOMSchemaService schemaService) {
        this.schemaService = schemaService;
    }

    public void init() {
        Class<RpcService> interfaceClass = this.getRpcClass();
        LOG.debug("{}: resolved interface {} to {}", new Object[]{ACTION_PROVIDER, this.interfaceName, interfaceClass});
        if (this.implementation != null) {
            this.registerImplementation(interfaceClass);
        } else {
            this.registerFallback(interfaceClass);
        }
    }

    public void destroy() {
        if (this.reg != null) {
            try {
                this.reg.close();
            }
            catch (Exception e) {
                LOG.warn("{}: error while unregistering", (Object)ACTION_PROVIDER, (Object)e);
            }
            finally {
                this.reg = null;
            }
        }
    }

    private Class<RpcService> getRpcClass() {
        Class iface;
        try {
            iface = this.bundle.loadClass(this.interfaceName);
        }
        catch (ClassNotFoundException e) {
            throw new ComponentDefinitionException(String.format("The specified \"interface\" for %s \"%s\" does not refer to an available class", this.interfaceName, ACTION_PROVIDER), (Throwable)e);
        }
        if (!RpcService.class.isAssignableFrom(iface)) {
            throw new ComponentDefinitionException(String.format("The specified \"interface\" %s for \"%s\" is not an RpcService", this.interfaceName, ACTION_PROVIDER));
        }
        return iface;
    }

    private void registerFallback(Class<RpcService> interfaceClass) {
        Collection<QName> paths = RpcUtil.decomposeRpcService(interfaceClass, (SchemaContext)this.schemaService.getGlobalContext(), RpcRoutingStrategy::isContextBasedRouted);
        if (paths.isEmpty()) {
            LOG.warn("{}: interface {} has no actions defined", (Object)ACTION_PROVIDER, interfaceClass);
            return;
        }
        ImmutableSet rpcs = ImmutableSet.copyOf((Collection)Collections2.transform(paths, DOMRpcIdentifier::create));
        this.reg = this.domRpcProvider.registerRpcImplementation((rpc, input) -> FluentFutures.immediateFailedFluentFuture((Throwable)new DOMRpcImplementationNotAvailableException("Action %s has no instance matching %s", new Object[]{rpc, input})), (Set)rpcs);
        LOG.debug("Registered provider for {}", (Object)this.interfaceName);
    }

    private void registerImplementation(Class<RpcService> interfaceClass) {
        if (!interfaceClass.isInstance(this.implementation)) {
            throw new ComponentDefinitionException(String.format("The specified \"interface\" %s for \"%s\" is not implemented by RpcService \"ref\" %s", this.interfaceName, ACTION_PROVIDER, this.implementation.getClass()));
        }
        this.reg = this.bindingRpcProvider.registerRpcImplementation(interfaceClass, this.implementation);
        LOG.debug("Registered implementation {} for {}", (Object)this.implementation, (Object)this.interfaceName);
    }
}

