/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.blueprint.ext;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.aries.blueprint.ComponentDefinitionRegistry;
import org.apache.aries.blueprint.ComponentDefinitionRegistryProcessor;
import org.apache.aries.blueprint.ext.AbstractPropertyPlaceholder;
import org.apache.aries.blueprint.mutable.MutableBeanMetadata;
import org.apache.aries.blueprint.mutable.MutableServiceReferenceMetadata;
import org.apache.aries.util.AriesFrameworkUtil;
import org.gaul.modernizer_maven_annotations.SuppressModernizer;
import org.opendaylight.controller.blueprint.BlueprintContainerRestartService;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.blueprint.reflect.BeanProperty;
import org.osgi.service.blueprint.reflect.ComponentMetadata;
import org.osgi.service.blueprint.reflect.ValueMetadata;
import org.osgi.service.cm.ManagedService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentProcessor
implements ComponentDefinitionRegistryProcessor {
    static final String DEFAULT_TYPE_FILTER = "(|(type=default)(!(type=*)))";
    private static final Logger LOG = LoggerFactory.getLogger(ComponentProcessor.class);
    private static final String CM_PERSISTENT_ID_PROPERTY = "persistentId";
    private final List<ServiceRegistration<?>> managedServiceRegs = new ArrayList();
    private Bundle bundle;
    private BlueprintContainerRestartService blueprintContainerRestartService;
    private boolean restartDependentsOnUpdates;
    private boolean useDefaultForReferenceTypes;

    public void setBundle(Bundle bundle) {
        this.bundle = bundle;
    }

    public void setBlueprintContainerRestartService(BlueprintContainerRestartService restartService) {
        this.blueprintContainerRestartService = restartService;
    }

    public void setRestartDependentsOnUpdates(boolean restartDependentsOnUpdates) {
        this.restartDependentsOnUpdates = restartDependentsOnUpdates;
    }

    public void setUseDefaultForReferenceTypes(boolean useDefaultForReferenceTypes) {
        this.useDefaultForReferenceTypes = useDefaultForReferenceTypes;
    }

    public void destroy() {
        for (ServiceRegistration<?> reg : this.managedServiceRegs) {
            AriesFrameworkUtil.safeUnregisterService(reg);
        }
    }

    public void process(ComponentDefinitionRegistry registry) {
        LOG.debug("{}: In process", (Object)this.logName());
        for (String name : registry.getComponentDefinitionNames()) {
            ComponentMetadata component = registry.getComponentDefinition(name);
            if (component instanceof MutableBeanMetadata) {
                this.processMutableBeanMetadata((MutableBeanMetadata)component);
                continue;
            }
            if (!(component instanceof MutableServiceReferenceMetadata)) continue;
            this.processServiceReferenceMetadata((MutableServiceReferenceMetadata)component);
        }
    }

    private void processServiceReferenceMetadata(MutableServiceReferenceMetadata serviceRef) {
        if (!this.useDefaultForReferenceTypes) {
            return;
        }
        String filter = serviceRef.getFilter();
        String extFilter = serviceRef.getExtendedFilter() == null ? null : serviceRef.getExtendedFilter().getStringValue();
        LOG.debug("{}: processServiceReferenceMetadata for {}, filter: {}, ext filter: {}", new Object[]{this.logName(), serviceRef.getId(), filter, extFilter});
        if (Strings.isNullOrEmpty((String)filter) && Strings.isNullOrEmpty((String)extFilter)) {
            serviceRef.setFilter(DEFAULT_TYPE_FILTER);
            LOG.debug("{}: processServiceReferenceMetadata for {} set filter to {}", new Object[]{this.logName(), serviceRef.getId(), serviceRef.getFilter()});
        }
    }

    private void processMutableBeanMetadata(MutableBeanMetadata bean) {
        if (this.restartDependentsOnUpdates && bean.getRuntimeClass() != null && AbstractPropertyPlaceholder.class.isAssignableFrom(bean.getRuntimeClass())) {
            LOG.debug("{}: Found PropertyPlaceholder bean: {}, runtime {}", new Object[]{this.logName(), bean.getId(), bean.getRuntimeClass()});
            for (BeanProperty prop : bean.getProperties()) {
                if (!CM_PERSISTENT_ID_PROPERTY.equals(prop.getName())) continue;
                if (prop.getValue() instanceof ValueMetadata) {
                    ValueMetadata persistentId = (ValueMetadata)prop.getValue();
                    LOG.debug("{}: Found {} property, value : {}", new Object[]{this.logName(), CM_PERSISTENT_ID_PROPERTY, persistentId.getStringValue()});
                    this.registerManagedService(persistentId.getStringValue());
                    break;
                }
                LOG.debug("{}: {} property metadata {} is not instanceof ValueMetadata", new Object[]{this.logName(), CM_PERSISTENT_ID_PROPERTY, prop.getValue()});
                break;
            }
        }
    }

    @SuppressModernizer
    private void registerManagedService(final String persistentId) {
        ManagedService managedService = new ManagedService(){
            private final AtomicBoolean initialUpdate = new AtomicBoolean(true);
            private volatile Dictionary<String, ?> previousProperties;

            public void updated(Dictionary<String, ?> properties) {
                LOG.debug("{}: ManagedService updated for persistentId {}, properties: {}, initialUpdate: {}", new Object[]{ComponentProcessor.this.logName(), persistentId, properties, this.initialUpdate});
                if (!this.initialUpdate.compareAndSet(true, false) && !Objects.equals(this.previousProperties, properties)) {
                    ComponentProcessor.this.blueprintContainerRestartService.restartContainerAndDependents(ComponentProcessor.this.bundle);
                }
                this.previousProperties = properties;
            }
        };
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("service.pid", persistentId);
        ((Dictionary)props).put("Bundle-SymbolicName", this.bundle.getSymbolicName());
        ((Dictionary)props).put("Bundle-Version", (String)this.bundle.getHeaders().get("Bundle-Version"));
        this.managedServiceRegs.add(this.bundle.getBundleContext().registerService(ManagedService.class, (Object)managedService, props));
    }

    private String logName() {
        return this.bundle.getSymbolicName();
    }
}

