/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.storage.journal;

import com.esotericsoftware.kryo.KryoException;
import io.atomix.storage.StorageException;
import io.atomix.storage.journal.Indexed;
import io.atomix.storage.journal.JournalSegment;
import io.atomix.storage.journal.JournalWriter;
import io.atomix.storage.journal.index.JournalIndex;
import io.atomix.utils.memory.BufferCleaner;
import io.atomix.utils.serializer.Namespace;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.util.zip.CRC32;

class MappedJournalSegmentWriter<E>
implements JournalWriter<E> {
    private final MappedByteBuffer mappedBuffer;
    private final ByteBuffer buffer;
    private final JournalSegment<E> segment;
    private final int maxEntrySize;
    private final JournalIndex index;
    private final Namespace namespace;
    private final long firstIndex;
    private Indexed<E> lastEntry;

    MappedJournalSegmentWriter(MappedByteBuffer buffer, JournalSegment<E> segment, int maxEntrySize, JournalIndex index, Namespace namespace) {
        this.mappedBuffer = buffer;
        this.buffer = buffer.slice();
        this.segment = segment;
        this.maxEntrySize = maxEntrySize;
        this.index = index;
        this.namespace = namespace;
        this.firstIndex = segment.index();
        this.reset(0L);
    }

    MappedByteBuffer buffer() {
        return this.mappedBuffer;
    }

    @Override
    public void reset(long index) {
        this.buffer.position(64);
        int position = this.buffer.position();
        this.buffer.mark();
        try {
            int length = this.buffer.getInt();
            for (long nextIndex = this.firstIndex; 0 < length && length <= this.maxEntrySize && (index == 0L || nextIndex <= index); ++nextIndex) {
                long checksum = (long)this.buffer.getInt() & 0xFFFFFFFFL;
                CRC32 crc32 = new CRC32();
                ByteBuffer slice = this.buffer.slice();
                slice.limit(length);
                crc32.update(slice);
                if (checksum != crc32.getValue()) break;
                slice.rewind();
                Object entry = this.namespace.deserialize(slice);
                this.lastEntry = new Indexed(nextIndex, entry, length);
                this.index.index(nextIndex, position);
                position = this.buffer.position() + length;
                this.buffer.position(position);
                this.buffer.mark();
                length = this.buffer.getInt();
            }
            this.buffer.reset();
        }
        catch (BufferUnderflowException e) {
            this.buffer.reset();
        }
    }

    @Override
    public long getLastIndex() {
        return this.lastEntry != null ? this.lastEntry.index() : this.segment.index() - 1L;
    }

    @Override
    public Indexed<E> getLastEntry() {
        return this.lastEntry;
    }

    @Override
    public long getNextIndex() {
        if (this.lastEntry != null) {
            return this.lastEntry.index() + 1L;
        }
        return this.firstIndex;
    }

    public long size() {
        return this.buffer.position() + 64;
    }

    public boolean isEmpty() {
        return this.lastEntry == null;
    }

    @Override
    public void append(Indexed<E> entry) {
        long nextIndex = this.getNextIndex();
        if (entry.index() > nextIndex) {
            throw new IndexOutOfBoundsException("Entry index is not sequential");
        }
        if (entry.index() < nextIndex) {
            this.truncate(entry.index() - 1L);
        }
        this.append(entry.entry());
    }

    @Override
    public <T extends E> Indexed<T> append(T entry) {
        long index = this.getNextIndex();
        int position = this.buffer.position();
        if (position + 4 + 4 > this.buffer.limit()) {
            throw new BufferOverflowException();
        }
        this.buffer.position(position + 4 + 4);
        try {
            this.namespace.serialize(entry, this.buffer);
        }
        catch (KryoException e) {
            throw new BufferOverflowException();
        }
        int length = this.buffer.position() - (position + 4 + 4);
        if (length > this.maxEntrySize) {
            this.buffer.position(position);
            throw new StorageException.TooLarge("Entry size " + length + " exceeds maximum allowed bytes (" + this.maxEntrySize + ")");
        }
        CRC32 crc32 = new CRC32();
        this.buffer.position(position + 4 + 4);
        ByteBuffer slice = this.buffer.slice();
        slice.limit(length);
        crc32.update(slice);
        long checksum = crc32.getValue();
        this.buffer.position(position);
        this.buffer.putInt(length);
        this.buffer.putInt((int)checksum);
        this.buffer.position(position + 4 + 4 + length);
        Indexed<T> indexedEntry = new Indexed<T>(index, entry, length);
        this.lastEntry = indexedEntry;
        this.index.index(index, position);
        return indexedEntry;
    }

    @Override
    public void commit(long index) {
    }

    @Override
    public void truncate(long index) {
        if (index >= this.getLastIndex()) {
            return;
        }
        this.lastEntry = null;
        this.index.truncate(index);
        if (index < this.segment.index()) {
            this.buffer.position(64);
            this.buffer.putInt(0);
            this.buffer.putInt(0);
            this.buffer.position(64);
        } else {
            this.reset(index);
            int position = this.buffer.position();
            this.buffer.putInt(0);
            this.buffer.putInt(0);
            this.buffer.position(position);
        }
    }

    @Override
    public void flush() {
        this.mappedBuffer.force();
    }

    @Override
    public void close() {
        this.flush();
        try {
            BufferCleaner.freeBuffer(this.mappedBuffer);
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }
}

