/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.rfc8040.parser;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableList;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.rfc8040.model.api.YangDataEffectiveStatement;
import org.opendaylight.yangtools.rfc8040.model.api.YangDataStatement;
import org.opendaylight.yangtools.rfc8040.model.api.YangDataStatements;
import org.opendaylight.yangtools.rfc8040.parser.YangDataEffectiveStatementImpl;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.AbstractDeclaredStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.BaseStringStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;

@Beta
public final class YangDataStatementSupport
extends BaseStringStatementSupport<YangDataStatement, YangDataEffectiveStatement> {
    private static final YangDataStatementSupport INSTANCE = new YangDataStatementSupport((StatementDefinition)YangDataStatements.YANG_DATA);
    private final SubstatementValidator validator;

    private YangDataStatementSupport(StatementDefinition definition) {
        super(definition);
        this.validator = SubstatementValidator.builder((StatementDefinition)definition).addMandatory((StatementDefinition)YangStmtMapping.CONTAINER).addOptional((StatementDefinition)YangStmtMapping.USES).build();
    }

    public static YangDataStatementSupport getInstance() {
        return INSTANCE;
    }

    public void onFullDefinitionDeclared(StmtContext.Mutable<String, YangDataStatement, YangDataEffectiveStatement> ctx) {
        if (ctx.coerceParentContext().getParentContext() != null) {
            ctx.setIsSupportedToBuildEffective(false);
        }
    }

    public boolean isIgnoringIfFeatures() {
        return true;
    }

    public boolean isIgnoringConfig() {
        return true;
    }

    protected SubstatementValidator getSubstatementValidator() {
        return this.validator;
    }

    protected YangDataStatement createDeclared(@NonNull StmtContext<String, YangDataStatement, ?> ctx, ImmutableList<? extends DeclaredStatement<?>> substatements) {
        return new Declared(ctx.coerceRawStatementArgument(), substatements);
    }

    protected YangDataStatement createEmptyDeclared(StmtContext<String, YangDataStatement, ?> ctx) {
        return this.createDeclared(ctx, (ImmutableList<? extends DeclaredStatement<?>>)ImmutableList.of());
    }

    protected YangDataEffectiveStatement createEffective(StmtContext<String, YangDataStatement, YangDataEffectiveStatement> ctx, YangDataStatement declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        this.validator.validate(ctx);
        return new YangDataEffectiveStatementImpl(declared, substatements, ctx);
    }

    protected YangDataEffectiveStatement createEmptyEffective(StmtContext<String, YangDataStatement, YangDataEffectiveStatement> ctx, YangDataStatement declared) {
        return this.createEffective(ctx, declared, ImmutableList.of());
    }

    private static final class Declared
    extends AbstractDeclaredStatement.WithRawStringArgument.WithSubstatements
    implements YangDataStatement {
        Declared(String rawArgument, ImmutableList<? extends DeclaredStatement<?>> substatements) {
            super(rawArgument, substatements);
        }
    }
}

