/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.generator.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Verify;
import com.google.common.collect.Iterables;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.binding.generator.impl.ModuleContext;
import org.opendaylight.mdsal.binding.model.api.AccessModifier;
import org.opendaylight.mdsal.binding.model.api.AnnotationType;
import org.opendaylight.mdsal.binding.model.api.ConcreteType;
import org.opendaylight.mdsal.binding.model.api.Constant;
import org.opendaylight.mdsal.binding.model.api.DefaultType;
import org.opendaylight.mdsal.binding.model.api.Enumeration;
import org.opendaylight.mdsal.binding.model.api.GeneratedTransferObject;
import org.opendaylight.mdsal.binding.model.api.GeneratedType;
import org.opendaylight.mdsal.binding.model.api.JavaTypeName;
import org.opendaylight.mdsal.binding.model.api.MethodSignature;
import org.opendaylight.mdsal.binding.model.api.ParameterizedType;
import org.opendaylight.mdsal.binding.model.api.Restrictions;
import org.opendaylight.mdsal.binding.model.api.Type;
import org.opendaylight.mdsal.binding.model.api.type.builder.AnnotableTypeBuilder;
import org.opendaylight.mdsal.binding.model.api.type.builder.AnnotationTypeBuilder;
import org.opendaylight.mdsal.binding.model.api.type.builder.EnumBuilder;
import org.opendaylight.mdsal.binding.model.api.type.builder.GeneratedPropertyBuilder;
import org.opendaylight.mdsal.binding.model.api.type.builder.GeneratedTOBuilder;
import org.opendaylight.mdsal.binding.model.api.type.builder.GeneratedTypeBuilder;
import org.opendaylight.mdsal.binding.model.api.type.builder.GeneratedTypeBuilderBase;
import org.opendaylight.mdsal.binding.model.api.type.builder.MethodSignatureBuilder;
import org.opendaylight.mdsal.binding.model.api.type.builder.TypeMemberBuilder;
import org.opendaylight.mdsal.binding.model.util.BaseYangTypes;
import org.opendaylight.mdsal.binding.model.util.BindingGeneratorUtil;
import org.opendaylight.mdsal.binding.model.util.BindingTypes;
import org.opendaylight.mdsal.binding.model.util.Types;
import org.opendaylight.mdsal.binding.model.util.generated.type.builder.GeneratedPropertyBuilderImpl;
import org.opendaylight.mdsal.binding.spec.naming.BindingMapping;
import org.opendaylight.mdsal.binding.yang.types.AbstractTypeProvider;
import org.opendaylight.mdsal.binding.yang.types.GroupingDefinitionDependencySort;
import org.opendaylight.yangtools.concepts.Identifiable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.model.api.ActionDefinition;
import org.opendaylight.yangtools.yang.model.api.ActionNodeContainer;
import org.opendaylight.yangtools.yang.model.api.AnydataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.AnyxmlSchemaNode;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchemaNode;
import org.opendaylight.yangtools.yang.model.api.CaseSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ContainerLike;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DerivableSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DocumentedNode;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.GroupingDefinition;
import org.opendaylight.yangtools.yang.model.api.IdentitySchemaNode;
import org.opendaylight.yangtools.yang.model.api.InputSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.ModuleImport;
import org.opendaylight.yangtools.yang.model.api.NotificationDefinition;
import org.opendaylight.yangtools.yang.model.api.NotificationNodeContainer;
import org.opendaylight.yangtools.yang.model.api.OutputSchemaNode;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.TypedDataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.api.UsesNode;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;
import org.opendaylight.yangtools.yang.model.api.type.BitsTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.EnumTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.LeafrefTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.PatternConstraint;
import org.opendaylight.yangtools.yang.model.api.type.UnionTypeDefinition;
import org.opendaylight.yangtools.yang.model.util.ModuleDependencySort;
import org.opendaylight.yangtools.yang.model.util.SchemaContextUtil;
import org.opendaylight.yangtools.yang.model.util.SchemaNodeUtils;
import org.opendaylight.yangtools.yang.model.util.type.CompatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractTypeGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractTypeGenerator.class);
    private static final Splitter COLON_SPLITTER = Splitter.on((char)':');
    private static final JavaTypeName DEPRECATED_ANNOTATION = JavaTypeName.create(Deprecated.class);
    private static final JavaTypeName OVERRIDE_ANNOTATION = JavaTypeName.create(Override.class);
    private static final JavaTypeName CHECK_RETURN_VALUE_ANNOTATION = JavaTypeName.create((String)"edu.umd.cs.findbugs.annotations", (String)"CheckReturnValue");
    private static final Type LIST_STRING_TYPE = Types.listTypeFor((Type)BaseYangTypes.STRING_TYPE);
    private static final Comparator<AugmentationSchemaNode> AUGMENT_COMP = (o1, o2) -> {
        Iterator thisIt = o1.getTargetPath().getNodeIdentifiers().iterator();
        Iterator otherIt = o2.getTargetPath().getNodeIdentifiers().iterator();
        while (thisIt.hasNext()) {
            if (!otherIt.hasNext()) {
                return 1;
            }
            int comp = ((QName)thisIt.next()).compareTo((QName)otherIt.next());
            if (comp == 0) continue;
            return comp;
        }
        return otherIt.hasNext() ? -1 : 0;
    };
    private static final String AUGMENT_IDENTIFIER_NAME = "augment-identifier";
    private static final String YANG_EXT_NAMESPACE = "urn:opendaylight:yang:extension:yang-ext";
    private final Map<QNameModule, ModuleContext> genCtx = new HashMap<QNameModule, ModuleContext>();
    private final Map<String, Map<String, GeneratedTypeBuilder>> genTypeBuilders = new HashMap<String, Map<String, GeneratedTypeBuilder>>();
    private final AbstractTypeProvider typeProvider;
    private final @NonNull EffectiveModelContext schemaContext;
    private final Map<SchemaNode, JavaTypeName> renames;

    AbstractTypeGenerator(EffectiveModelContext context, AbstractTypeProvider typeProvider, Map<SchemaNode, JavaTypeName> renames) {
        this.schemaContext = Objects.requireNonNull(context);
        this.typeProvider = Objects.requireNonNull(typeProvider);
        this.renames = Objects.requireNonNull(renames);
        List contextModules = ModuleDependencySort.sort((Collection)this.schemaContext.getModules());
        ArrayList<ModuleContext> contexts = new ArrayList<ModuleContext>(contextModules.size());
        for (Module contextModule : contextModules) {
            contexts.add(this.moduleToGenTypes(contextModule));
        }
        contexts.forEach(this::allAugmentsToGenTypes);
    }

    final @NonNull EffectiveModelContext schemaContext() {
        return this.schemaContext;
    }

    final Collection<ModuleContext> moduleContexts() {
        return this.genCtx.values();
    }

    final ModuleContext moduleContext(QNameModule module) {
        return Objects.requireNonNull(this.genCtx.get(module), () -> "Module context not found for module " + module);
    }

    final AbstractTypeProvider typeProvider() {
        return this.typeProvider;
    }

    abstract void addCodegenInformation(GeneratedTypeBuilderBase<?> var1, Module var2);

    abstract void addCodegenInformation(GeneratedTypeBuilderBase<?> var1, Module var2, SchemaNode var3);

    abstract void addCodegenInformation(GeneratedTypeBuilder var1, Module var2, String var3, Collection<? extends SchemaNode> var4);

    abstract void addComment(TypeMemberBuilder<?> var1, DocumentedNode var2);

    abstract void addRpcMethodComment(TypeMemberBuilder<?> var1, RpcDefinition var2);

    private ModuleContext moduleToGenTypes(Module module) {
        ModuleContext context = new ModuleContext(module);
        this.genCtx.put(module.getQNameModule(), context);
        this.allTypeDefinitionsToGenTypes(context);
        this.groupingsToGenTypes(context, module.getGroupings());
        this.allIdentitiesToGenTypes(context);
        if (!module.getChildNodes().isEmpty()) {
            GeneratedTypeBuilder moduleType = this.moduleToDataType(context);
            context.addModuleNode(moduleType);
            this.resolveDataSchemaNodes(context, moduleType, (Type)moduleType, module.getChildNodes(), false);
        }
        this.rpcMethodsToGenType(context);
        this.notificationsToGenType(context);
        return context;
    }

    private void allTypeDefinitionsToGenTypes(ModuleContext context) {
        Module module = context.module();
        Preconditions.checkArgument((module.getName() != null ? 1 : 0) != 0, (Object)"Module name cannot be NULL.");
        for (TypeDefinition typedef : SchemaNodeUtils.getAllTypeDefinitions((DataNodeContainer)module)) {
            Type type;
            if (typedef == null || (type = this.typeProvider.generatedTypeForExtendedDefinitionType(typedef, (SchemaNode)typedef)) == null) continue;
            context.addTypedefType(typedef, type);
            context.addTypeToSchema(type, typedef);
        }
    }

    private GeneratedTypeBuilder processDataSchemaNode(ModuleContext context, Type baseInterface, DataSchemaNode node, boolean inGrouping) {
        if (node.isAugmenting() || node.isAddedByUses()) {
            return null;
        }
        GeneratedTypeBuilder genType = this.addDefaultInterfaceDefinition(context, (SchemaNode)node, baseInterface);
        AbstractTypeGenerator.addConcreteInterfaceMethods(genType);
        AbstractTypeGenerator.annotateDeprecatedIfNecessary((DocumentedNode.WithStatus)node, (AnnotableTypeBuilder)genType);
        Module module = context.module();
        genType.setModuleName(module.getName());
        this.addCodegenInformation((GeneratedTypeBuilderBase<?>)genType, module, (SchemaNode)node);
        genType.setSchemaPath(node.getPath());
        if (node instanceof DataNodeContainer) {
            context.addChildNodeType((SchemaNode)node, genType);
            this.groupingsToGenTypes(context, ((DataNodeContainer)node).getGroupings());
            this.processUsesAugments((DataNodeContainer)node, context, inGrouping);
        }
        return genType;
    }

    private Type containerToGenType(ModuleContext context, GeneratedTypeBuilder parent, Type baseInterface, ContainerSchemaNode node, boolean inGrouping) {
        GeneratedTypeBuilder genType = this.processDataSchemaNode(context, baseInterface, (DataSchemaNode)node, inGrouping);
        if (genType != null) {
            this.constructGetter(parent, (Type)genType, (SchemaNode)node);
            this.resolveDataSchemaNodes(context, genType, (Type)genType, node.getChildNodes(), inGrouping);
            this.actionsToGenType(context, (Type)genType, node, null, inGrouping);
            this.notificationsToGenType(context, (Type)genType, node, null, inGrouping);
        }
        return genType;
    }

    private GeneratedTypeBuilder listToGenType(ModuleContext context, GeneratedTypeBuilder parent, Type baseInterface, ListSchemaNode node, boolean inGrouping) {
        GeneratedTypeBuilder genType = this.processDataSchemaNode(context, baseInterface, (DataSchemaNode)node, inGrouping);
        if (genType != null) {
            GeneratedTOBuilder keyTypeBuilder;
            List<String> listKeys = AbstractTypeGenerator.listKeys(node);
            if (!listKeys.isEmpty()) {
                keyTypeBuilder = (GeneratedTOBuilder)this.typeProvider.newGeneratedTOBuilder(JavaTypeName.create((String)BindingGeneratorUtil.packageNameForGeneratedType((String)context.modulePackageName(), (SchemaPath)node.getPath()), (String)BindingMapping.getClassName((String)(node.getQName().getLocalName() + "Key")))).addImplementsType((Type)BindingTypes.identifier((Type)genType));
                genType.addImplementsType((Type)BindingTypes.identifiable((Type)keyTypeBuilder));
            } else {
                keyTypeBuilder = null;
            }
            ParameterizedType listType = keyTypeBuilder != null && !node.isUserOrdered() ? Types.mapTypeFor(keyTypeBuilder, (Type)genType) : Types.listTypeFor((Type)genType);
            this.constructGetter(parent, (Type)listType, (SchemaNode)node).setMechanics(MethodSignature.ValueMechanics.NULLIFY_EMPTY);
            AbstractTypeGenerator.constructNonnull(parent, (Type)listType, node);
            this.actionsToGenType(context, (Type)genType, node, (Type)keyTypeBuilder, inGrouping);
            this.notificationsToGenType(context, (Type)genType, node, (Type)keyTypeBuilder, inGrouping);
            for (DataSchemaNode schemaNode : node.getChildNodes()) {
                if (schemaNode.isAugmenting()) continue;
                this.addSchemaNodeToListBuilders(context, schemaNode, genType, keyTypeBuilder, listKeys, inGrouping);
            }
            if (keyTypeBuilder != null) {
                GeneratedPropertyBuilderImpl prop = new GeneratedPropertyBuilderImpl("serialVersionUID");
                prop.setValue(Long.toString(BindingGeneratorUtil.computeDefaultSUID((GeneratedTypeBuilderBase)keyTypeBuilder)));
                keyTypeBuilder.setSUID((GeneratedPropertyBuilder)prop);
            }
            AbstractTypeGenerator.typeBuildersToGenTypes(context, genType, keyTypeBuilder);
        }
        return genType;
    }

    private void processUsesAugments(DataNodeContainer node, ModuleContext context, boolean inGrouping) {
        for (UsesNode usesNode : node.getUses()) {
            for (AugmentationSchemaNode augment : usesNode.getAugmentations()) {
                this.usesAugmentationToGenTypes(context, augment, usesNode, node, inGrouping);
                this.processUsesAugments((DataNodeContainer)augment, context, inGrouping);
            }
        }
    }

    private void allAugmentsToGenTypes(ModuleContext context) {
        Module module = context.module();
        Preconditions.checkArgument((module != null ? 1 : 0) != 0, (Object)"Module reference cannot be NULL.");
        Preconditions.checkArgument((module.getName() != null ? 1 : 0) != 0, (Object)"Module name cannot be NULL.");
        Preconditions.checkState((module.getAugmentations() != null ? 1 : 0) != 0, (Object)"Augmentations Set cannot be NULL.");
        for (AugmentationSchemaNode augment : AbstractTypeGenerator.resolveAugmentations(module)) {
            this.augmentationToGenTypes(context, augment);
        }
    }

    private static List<AugmentationSchemaNode> resolveAugmentations(Module module) {
        Preconditions.checkArgument((module != null ? 1 : 0) != 0, (Object)"Module reference cannot be NULL.");
        Preconditions.checkState((module.getAugmentations() != null ? 1 : 0) != 0, (Object)"Augmentations Set cannot be NULL.");
        ArrayList<AugmentationSchemaNode> sortedAugmentations = new ArrayList<AugmentationSchemaNode>(module.getAugmentations());
        sortedAugmentations.sort(AUGMENT_COMP);
        return sortedAugmentations;
    }

    private GeneratedTypeBuilder moduleToDataType(ModuleContext context) {
        GeneratedTypeBuilder moduleDataTypeBuilder = this.moduleTypeBuilder(context, "Data");
        Module module = context.module();
        this.addImplementedInterfaceFromUses((DataNodeContainer)module, moduleDataTypeBuilder);
        moduleDataTypeBuilder.addImplementsType((Type)BindingTypes.DATA_ROOT);
        if (module.getUses().size() > 1) {
            AbstractTypeGenerator.narrowImplementedInterface(moduleDataTypeBuilder);
        }
        this.addCodegenInformation((GeneratedTypeBuilderBase<?>)moduleDataTypeBuilder, module);
        return moduleDataTypeBuilder;
    }

    private <T extends DataNodeContainer & ActionNodeContainer> void actionsToGenType(ModuleContext context, Type parent, T parentSchema, Type keyType, boolean inGrouping) {
        for (ActionDefinition action : ((ActionNodeContainer)parentSchema).getActions()) {
            GeneratedType output;
            GeneratedType input;
            if (action.isAugmenting()) continue;
            if (action.isAddedByUses()) {
                ActionDefinition orig = this.findOrigAction(parentSchema, action).get();
                ModuleContext origContext = this.moduleContext(((QName)orig.getPath().getPathFromRoot().iterator().next()).getModule());
                input = context.addAliasType(origContext, (ContainerLike)orig.getInput(), (ContainerLike)action.getInput());
                output = context.addAliasType(origContext, (ContainerLike)orig.getOutput(), (ContainerLike)action.getOutput());
            } else {
                input = this.actionContainer(context, (Type)BindingTypes.RPC_INPUT, (ContainerLike)action.getInput(), inGrouping);
                output = this.actionContainer(context, (Type)BindingTypes.RPC_OUTPUT, (ContainerLike)action.getOutput(), inGrouping);
            }
            if (parentSchema instanceof GroupingDefinition) continue;
            QName qname = action.getQName();
            GeneratedTypeBuilder builder = this.typeProvider.newGeneratedTypeBuilder(JavaTypeName.create((String)BindingGeneratorUtil.packageNameForGeneratedType((String)context.modulePackageName(), (SchemaPath)action.getPath()), (String)BindingMapping.getClassName((QName)qname)));
            AbstractTypeGenerator.qnameConstant(builder, context.moduleInfoType(), qname.getLocalName());
            AbstractTypeGenerator.annotateDeprecatedIfNecessary((DocumentedNode.WithStatus)action, (AnnotableTypeBuilder)builder);
            builder.addImplementsType((Type)(keyType != null ? BindingTypes.keyedListAction((Type)parent, (Type)keyType, (Type)input, (Type)output) : BindingTypes.action((Type)parent, (Type)input, (Type)output)));
            this.addCodegenInformation((GeneratedTypeBuilderBase<?>)builder, context.module(), (SchemaNode)action);
            context.addChildNodeType((SchemaNode)action, builder);
        }
    }

    private Optional<ActionDefinition> findOrigAction(DataNodeContainer parent, ActionDefinition action) {
        QName qname = action.getQName();
        for (UsesNode uses : parent.getUses()) {
            GroupingDefinition grp = uses.getSourceGrouping();
            Optional<ActionDefinition> found = grp.findAction(qname.bindTo(grp.getQName().getModule()));
            if (!found.isPresent()) continue;
            ActionDefinition result = (ActionDefinition)found.get();
            return result.isAddedByUses() ? this.findOrigAction((DataNodeContainer)grp, result) : found;
        }
        return Optional.empty();
    }

    private GeneratedType actionContainer(ModuleContext context, Type baseInterface, ContainerLike schema, boolean inGrouping) {
        GeneratedTypeBuilder genType = this.processDataSchemaNode(context, baseInterface, (DataSchemaNode)schema, inGrouping);
        this.resolveDataSchemaNodes(context, genType, (Type)genType, schema.getChildNodes(), inGrouping);
        return genType.build();
    }

    private void rpcMethodsToGenType(ModuleContext context) {
        Module module = context.module();
        Preconditions.checkArgument((module.getName() != null ? 1 : 0) != 0, (Object)"Module name cannot be NULL.");
        Collection rpcDefinitions = module.getRpcs();
        Preconditions.checkState((rpcDefinitions != null ? 1 : 0) != 0, (Object)("Set of rpcs from module " + module.getName() + " cannot be NULL."));
        if (rpcDefinitions.isEmpty()) {
            return;
        }
        GeneratedTypeBuilder interfaceBuilder = this.moduleTypeBuilder(context, "Service");
        interfaceBuilder.addImplementsType((Type)BindingTypes.RPC_SERVICE);
        this.addCodegenInformation(interfaceBuilder, module, "RPCs", rpcDefinitions);
        for (RpcDefinition rpc : rpcDefinitions) {
            if (rpc == null) continue;
            String rpcName = BindingMapping.getClassName((QName)rpc.getQName());
            String rpcMethodName = BindingMapping.getRpcMethodName((QName)rpc.getQName());
            MethodSignatureBuilder method = interfaceBuilder.addMethod(rpcMethodName);
            method.addAnnotation(CHECK_RETURN_VALUE_ANNOTATION);
            this.addRpcMethodComment((TypeMemberBuilder<?>)method, rpc);
            method.addParameter(this.createRpcContainer(context, rpcName, rpc, (ContainerLike)Verify.verifyNotNull((Object)rpc.getInput()), (Type)BindingTypes.RPC_INPUT), "input");
            method.setReturnType((Type)Types.listenableFutureTypeFor((Type)BindingTypes.rpcResult((Type)this.createRpcContainer(context, rpcName, rpc, (ContainerLike)Verify.verifyNotNull((Object)rpc.getOutput()), (Type)BindingTypes.RPC_OUTPUT))));
        }
        context.addTopLevelNodeType(interfaceBuilder);
    }

    private Type createRpcContainer(ModuleContext context, String rpcName, RpcDefinition rpc, ContainerLike schema, Type type) {
        this.processUsesAugments((DataNodeContainer)schema, context, false);
        GeneratedTypeBuilder outType = this.addRawInterfaceDefinition(context, JavaTypeName.create((String)context.modulePackageName(), (String)(rpcName + BindingMapping.getClassName((QName)schema.getQName()))), (SchemaNode)schema);
        this.addImplementedInterfaceFromUses((DataNodeContainer)schema, outType);
        outType.addImplementsType(type);
        outType.addImplementsType((Type)BindingTypes.augmentable((Type)outType));
        AbstractTypeGenerator.addConcreteInterfaceMethods(outType);
        AbstractTypeGenerator.annotateDeprecatedIfNecessary((DocumentedNode.WithStatus)rpc, (AnnotableTypeBuilder)outType);
        this.resolveDataSchemaNodes(context, outType, (Type)outType, schema.getChildNodes(), false);
        context.addChildNodeType((SchemaNode)schema, outType);
        return outType.build();
    }

    private void notificationsToGenType(ModuleContext context) {
        Module module = context.module();
        Preconditions.checkArgument((module.getName() != null ? 1 : 0) != 0, (Object)"Module name cannot be NULL.");
        Collection notifications = module.getNotifications();
        if (notifications.isEmpty()) {
            return;
        }
        GeneratedTypeBuilder listenerInterface = this.moduleTypeBuilder(context, "Listener");
        listenerInterface.addImplementsType((Type)BindingTypes.NOTIFICATION_LISTENER);
        for (NotificationDefinition notification : notifications) {
            if (notification == null) continue;
            this.processUsesAugments((DataNodeContainer)notification, context, false);
            GeneratedTypeBuilder notificationInterface = this.addDefaultInterfaceDefinition(context.modulePackageName(), (SchemaNode)notification, (Type)BindingTypes.DATA_OBJECT, context);
            AbstractTypeGenerator.addConcreteInterfaceMethods(notificationInterface);
            AbstractTypeGenerator.annotateDeprecatedIfNecessary((DocumentedNode.WithStatus)notification, (AnnotableTypeBuilder)notificationInterface);
            notificationInterface.addImplementsType((Type)BindingTypes.NOTIFICATION);
            context.addChildNodeType((SchemaNode)notification, notificationInterface);
            this.resolveDataSchemaNodes(context, notificationInterface, (Type)notificationInterface, notification.getChildNodes(), false);
            MethodSignatureBuilder notificationMethod = (MethodSignatureBuilder)((MethodSignatureBuilder)listenerInterface.addMethod("on" + notificationInterface.getName()).setAccessModifier(AccessModifier.PUBLIC)).addParameter((Type)notificationInterface, "notification").setReturnType((Type)Types.primitiveVoidType());
            AbstractTypeGenerator.annotateDeprecatedIfNecessary((DocumentedNode.WithStatus)notification, (AnnotableTypeBuilder)notificationMethod);
            if (notification.getStatus().equals((Object)Status.OBSOLETE)) {
                notificationMethod.setDefault(true);
            }
            this.addComment((TypeMemberBuilder<?>)notificationMethod, (DocumentedNode)notification);
        }
        this.addCodegenInformation(listenerInterface, module, "notifications", notifications);
        context.addTopLevelNodeType(listenerInterface);
    }

    private <T extends DataNodeContainer & NotificationNodeContainer> void notificationsToGenType(ModuleContext context, Type parent, T parentSchema, Type keyType, boolean inGrouping) {
        Collection notifications = ((NotificationNodeContainer)parentSchema).getNotifications();
        if (notifications.isEmpty()) {
            return;
        }
        for (NotificationDefinition notif : notifications) {
            if (notif.isAugmenting() || parentSchema instanceof GroupingDefinition) continue;
            this.processUsesAugments((DataNodeContainer)notif, context, false);
            GeneratedTypeBuilder notifInterface = this.addDefaultInterfaceDefinition(BindingGeneratorUtil.packageNameForGeneratedType((String)context.modulePackageName(), (SchemaPath)notif.getPath()), (SchemaNode)notif, (Type)BindingTypes.DATA_OBJECT, context);
            AbstractTypeGenerator.addConcreteInterfaceMethods(notifInterface);
            AbstractTypeGenerator.annotateDeprecatedIfNecessary((DocumentedNode.WithStatus)notif, (AnnotableTypeBuilder)notifInterface);
            notifInterface.addImplementsType((Type)(keyType != null ? BindingTypes.keyedListNotification((Type)notifInterface, (Type)parent, (Type)keyType) : BindingTypes.instanceNotification((Type)notifInterface, (Type)parent)));
            context.addChildNodeType((SchemaNode)notif, notifInterface);
            this.resolveDataSchemaNodes(context, notifInterface, (Type)notifInterface, notif.getChildNodes(), false);
        }
    }

    private void allIdentitiesToGenTypes(ModuleContext context) {
        Collection schemaIdentities = context.module().getIdentities();
        if (schemaIdentities != null && !schemaIdentities.isEmpty()) {
            for (IdentitySchemaNode identity : schemaIdentities) {
                this.identityToGenType(context, identity);
            }
        }
    }

    private void identityToGenType(ModuleContext context, IdentitySchemaNode identity) {
        if (identity == null) {
            return;
        }
        JavaTypeName name = this.renames.get(identity);
        if (name == null) {
            name = JavaTypeName.create((String)BindingGeneratorUtil.packageNameForGeneratedType((String)context.modulePackageName(), (SchemaPath)identity.getPath()), (String)BindingMapping.getClassName((QName)identity.getQName()));
        }
        GeneratedTypeBuilder newType = this.typeProvider.newGeneratedTypeBuilder(name);
        Collection baseIdentities = identity.getBaseIdentities();
        if (!baseIdentities.isEmpty()) {
            for (IdentitySchemaNode baseIdentity : baseIdentities) {
                JavaTypeName base = this.renames.get(baseIdentity);
                if (base == null) {
                    QName qname = baseIdentity.getQName();
                    base = JavaTypeName.create((String)BindingMapping.getRootPackageName((QNameModule)qname.getModule()), (String)BindingMapping.getClassName((QName)qname));
                }
                GeneratedTransferObject gto = this.typeProvider.newGeneratedTOBuilder(base).build();
                newType.addImplementsType((Type)gto);
            }
        } else {
            newType.addImplementsType((Type)BindingTypes.BASE_IDENTITY);
        }
        Module module = context.module();
        this.addCodegenInformation((GeneratedTypeBuilderBase<?>)newType, module, (SchemaNode)identity);
        newType.setModuleName(module.getName());
        newType.setSchemaPath(identity.getPath());
        AbstractTypeGenerator.qnameConstant(newType, context.moduleInfoType(), identity.getQName().getLocalName());
        context.addIdentityType(identity, newType);
    }

    private static Constant qnameConstant(GeneratedTypeBuilderBase<?> toBuilder, JavaTypeName yangModuleInfo, String localName) {
        return toBuilder.addConstant((Type)BindingTypes.QNAME, "QNAME", new AbstractMap.SimpleImmutableEntry<JavaTypeName, String>(yangModuleInfo, localName));
    }

    private void groupingsToGenTypes(ModuleContext context, Collection<? extends GroupingDefinition> groupings) {
        for (GroupingDefinition grouping : new GroupingDefinitionDependencySort().sort(groupings)) {
            GeneratedTypeBuilder genType = this.addDefaultInterfaceDefinition(context, (SchemaNode)grouping);
            AbstractTypeGenerator.narrowImplementedInterface(genType);
            AbstractTypeGenerator.annotateDeprecatedIfNecessary((DocumentedNode.WithStatus)grouping, (AnnotableTypeBuilder)genType);
            context.addGroupingType(grouping, genType);
            this.resolveDataSchemaNodes(context, genType, (Type)genType, grouping.getChildNodes(), true);
            this.groupingsToGenTypes(context, grouping.getGroupings());
            this.processUsesAugments((DataNodeContainer)grouping, context, true);
            this.actionsToGenType(context, (Type)genType, grouping, null, true);
            this.notificationsToGenType(context, (Type)genType, grouping, null, true);
        }
    }

    private Enumeration resolveInnerEnumFromTypeDefinition(EnumTypeDefinition enumTypeDef, QName enumName, GeneratedTypeBuilder typeBuilder, ModuleContext context) {
        EnumBuilder enumBuilder = typeBuilder.addEnumeration(BindingMapping.getClassName((QName)enumName));
        this.typeProvider.addEnumDescription(enumBuilder, enumTypeDef);
        enumBuilder.updateEnumPairsFromEnumTypeDef(enumTypeDef);
        Enumeration ret = enumBuilder.toInstance((Type)typeBuilder);
        context.addTypeToSchema((Type)ret, (TypeDefinition<?>)enumTypeDef);
        context.addInnerTypedefType(enumTypeDef.getPath(), (Type)ret);
        return ret;
    }

    private GeneratedTypeBuilder moduleTypeBuilder(ModuleContext context, String postfix) {
        Module module = context.module();
        String moduleName = BindingMapping.getClassName((String)module.getName()) + postfix;
        GeneratedTypeBuilder moduleBuilder = this.typeProvider.newGeneratedTypeBuilder(JavaTypeName.create((String)context.modulePackageName(), (String)moduleName));
        moduleBuilder.setModuleName(moduleName);
        this.addCodegenInformation((GeneratedTypeBuilderBase<?>)moduleBuilder, module);
        return moduleBuilder;
    }

    private void augmentationToGenTypes(ModuleContext context, AugmentationSchemaNode augSchema) {
        JavaTypeName targetName;
        Preconditions.checkArgument((augSchema != null ? 1 : 0) != 0, (Object)"Augmentation Schema cannot be NULL.");
        Preconditions.checkState((augSchema.getTargetPath() != null ? 1 : 0) != 0, (Object)"Augmentation Schema does not contain Target Path (Target Path is NULL).");
        this.processUsesAugments((DataNodeContainer)augSchema, context, false);
        SchemaNodeIdentifier targetPath = augSchema.getTargetPath();
        SchemaNode targetSchemaNode = null;
        targetSchemaNode = SchemaContextUtil.findDataSchemaNode((SchemaContext)this.schemaContext, (List)targetPath.getNodeIdentifiers());
        if (targetSchemaNode instanceof DataSchemaNode && ((DataSchemaNode)targetSchemaNode).isAddedByUses()) {
            if (targetSchemaNode instanceof DerivableSchemaNode) {
                targetSchemaNode = ((DerivableSchemaNode)targetSchemaNode).getOriginal().orElse(null);
            }
            if (targetSchemaNode == null) {
                throw new IllegalStateException("Failed to find target node from grouping in augmentation " + augSchema + " in module " + context.module().getName());
            }
        }
        if (targetSchemaNode == null) {
            throw new IllegalArgumentException("augment target not found: " + targetPath);
        }
        if (targetSchemaNode instanceof ChoiceSchemaNode) {
            GeneratedTypeBuilder builder = this.findChildNodeByPath(targetSchemaNode.getPath());
            Preconditions.checkState((builder != null ? 1 : 0) != 0, (String)"Choice target type not generated for %s", (Object)targetSchemaNode);
            this.generateTypesFromAugmentedChoiceCases(context, (Type)builder.build(), (ChoiceSchemaNode)targetSchemaNode, augSchema.getChildNodes(), null, false);
            return;
        }
        if (targetSchemaNode instanceof CaseSchemaNode) {
            GeneratedTypeBuilder builder = this.findCaseByPath(targetSchemaNode.getPath());
            Preconditions.checkState((builder != null ? 1 : 0) != 0, (String)"Case target type not generated for %s", (Object)targetSchemaNode);
            targetName = (JavaTypeName)builder.getIdentifier();
        } else {
            GeneratedTypeBuilder builder = this.findChildNodeByPath(targetSchemaNode.getPath());
            if (builder == null) {
                targetName = this.findAliasByPath(targetSchemaNode.getPath());
                Preconditions.checkState((targetName != null ? 1 : 0) != 0, (String)"Target type not yet generated: %s", (Object)targetSchemaNode);
            } else {
                targetName = (JavaTypeName)builder.getIdentifier();
            }
        }
        this.addRawAugmentGenTypeDefinition(context, (Type)DefaultType.of((JavaTypeName)targetName), augSchema, false);
    }

    private void usesAugmentationToGenTypes(ModuleContext context, AugmentationSchemaNode augSchema, UsesNode usesNode, DataNodeContainer usesNodeParent, boolean inGrouping) {
        Preconditions.checkArgument((augSchema != null ? 1 : 0) != 0, (Object)"Augmentation Schema cannot be NULL.");
        Preconditions.checkState((augSchema.getTargetPath() != null ? 1 : 0) != 0, (Object)"Augmentation Schema does not contain Target Path (Target Path is NULL).");
        this.processUsesAugments((DataNodeContainer)augSchema, context, inGrouping);
        SchemaNodeIdentifier targetPath = augSchema.getTargetPath();
        DataSchemaNode targetSchemaNode = AbstractTypeGenerator.findOriginalTargetFromGrouping(targetPath, usesNode);
        if (targetSchemaNode == null) {
            throw new IllegalArgumentException("augment target not found: " + targetPath);
        }
        GeneratedTypeBuilder targetTypeBuilder = this.findChildNodeByPath(targetSchemaNode.getPath());
        if (targetTypeBuilder == null) {
            targetTypeBuilder = this.findCaseByPath(targetSchemaNode.getPath());
        }
        if (targetTypeBuilder == null) {
            throw new NullPointerException("Target type not yet generated: " + (SchemaNode)targetSchemaNode);
        }
        if (!(targetSchemaNode instanceof ChoiceSchemaNode)) {
            if (usesNodeParent instanceof SchemaNode) {
                this.addRawAugmentGenTypeDefinition(context, BindingGeneratorUtil.packageNameForAugmentedGeneratedType((String)context.modulePackageName(), (SchemaPath)((SchemaNode)usesNodeParent).getPath()), (Type)targetTypeBuilder.build(), augSchema, inGrouping);
            } else {
                this.addRawAugmentGenTypeDefinition(context, (Type)targetTypeBuilder.build(), augSchema, inGrouping);
            }
        } else {
            this.generateTypesFromAugmentedChoiceCases(context, (Type)targetTypeBuilder.build(), (ChoiceSchemaNode)targetSchemaNode, augSchema.getChildNodes(), usesNodeParent, inGrouping);
        }
    }

    private static DataSchemaNode findOriginalTargetFromGrouping(SchemaNodeIdentifier targetPath, UsesNode parentUsesNode) {
        GroupingDefinition result = parentUsesNode.getSourceGrouping();
        for (QName node : targetPath.getNodeIdentifiers()) {
            if (result instanceof DataNodeContainer) {
                QName resultNode = node.bindTo(result.getQName().getModule());
                DataSchemaNode found = ((DataNodeContainer)result).dataChildByName(resultNode);
                if (found == null) {
                    if (result instanceof ActionNodeContainer) {
                        found = ((ActionNodeContainer)result).findAction(resultNode).orElse(null);
                    }
                    if (found == null && result instanceof NotificationNodeContainer) {
                        found = ((NotificationNodeContainer)result).findNotification(resultNode).orElse(null);
                    }
                }
                result = found;
                continue;
            }
            if (result instanceof ChoiceSchemaNode) {
                result = AbstractTypeGenerator.findNamedCase((ChoiceSchemaNode)result, node.getLocalName());
                continue;
            }
            if (result instanceof ActionDefinition) {
                ActionDefinition action = (ActionDefinition)result;
                QName resultNode = node.bindTo(result.getQName().getModule());
                InputSchemaNode input = action.getInput();
                OutputSchemaNode output = action.getOutput();
                if (resultNode.equals((Object)input.getQName())) {
                    result = input;
                    continue;
                }
                if (resultNode.equals((Object)output.getQName())) {
                    result = output;
                    continue;
                }
                result = null;
                continue;
            }
            if (result == null) continue;
            throw new IllegalStateException("Cannot handle " + (SchemaNode)result);
        }
        if (result == null) {
            return null;
        }
        if (result instanceof DerivableSchemaNode) {
            DerivableSchemaNode castedResult = (DerivableSchemaNode)result;
            Optional originalNode = castedResult.getOriginal();
            if (castedResult.isAddedByUses() && originalNode.isPresent()) {
                result = (SchemaNode)originalNode.get();
            }
        }
        if (result instanceof DataSchemaNode) {
            DataSchemaNode resultDataSchemaNode = (DataSchemaNode)result;
            if (resultDataSchemaNode.isAddedByUses()) {
                throw new IllegalStateException("Failed to generate code for augment in " + parentUsesNode);
            }
            return resultDataSchemaNode;
        }
        throw new IllegalStateException("Target node of uses-augment statement must be DataSchemaNode. Failed to generate code for augment in " + parentUsesNode);
    }

    private GeneratedTypeBuilder addRawAugmentGenTypeDefinition(ModuleContext context, String augmentPackageName, Type targetTypeRef, AugmentationSchemaNode augSchema, boolean inGrouping) {
        Map augmentBuilders = this.genTypeBuilders.computeIfAbsent(augmentPackageName, k -> new HashMap());
        String augIdentifier = AbstractTypeGenerator.getAugmentIdentifier(augSchema.getUnknownSchemaNodes());
        String augTypeName = augIdentifier != null ? BindingMapping.getClassName((String)augIdentifier) : AbstractTypeGenerator.augGenTypeName(augmentBuilders, targetTypeRef.getName());
        GeneratedTypeBuilder augTypeBuilder = this.typeProvider.newGeneratedTypeBuilder(JavaTypeName.create((String)augmentPackageName, (String)augTypeName));
        augTypeBuilder.addImplementsType((Type)BindingTypes.augmentation((Type)targetTypeRef));
        AbstractTypeGenerator.addConcreteInterfaceMethods(augTypeBuilder);
        AbstractTypeGenerator.annotateDeprecatedIfNecessary((DocumentedNode.WithStatus)augSchema, (AnnotableTypeBuilder)augTypeBuilder);
        this.addImplementedInterfaceFromUses((DataNodeContainer)augSchema, augTypeBuilder);
        this.augSchemaNodeToMethods(context, augTypeBuilder, augSchema.getChildNodes(), inGrouping);
        this.actionsToGenType(context, (Type)augTypeBuilder, augSchema, null, inGrouping);
        this.notificationsToGenType(context, (Type)augTypeBuilder, augSchema, null, inGrouping);
        augmentBuilders.put(augTypeName, augTypeBuilder);
        if (!augSchema.getChildNodes().isEmpty()) {
            context.addTypeToAugmentation(augTypeBuilder, augSchema);
        }
        context.addAugmentType(augTypeBuilder);
        return augTypeBuilder;
    }

    private GeneratedTypeBuilder addRawAugmentGenTypeDefinition(ModuleContext context, Type targetTypeRef, AugmentationSchemaNode augSchema, boolean inGrouping) {
        return this.addRawAugmentGenTypeDefinition(context, context.modulePackageName(), targetTypeRef, augSchema, inGrouping);
    }

    private static String getAugmentIdentifier(Collection<? extends UnknownSchemaNode> unknownSchemaNodes) {
        for (UnknownSchemaNode unknownSchemaNode : unknownSchemaNodes) {
            QName nodeType = unknownSchemaNode.getNodeType();
            if (!AUGMENT_IDENTIFIER_NAME.equals(nodeType.getLocalName()) || !YANG_EXT_NAMESPACE.equals(nodeType.getNamespace().toString())) continue;
            return unknownSchemaNode.getNodeParameter();
        }
        return null;
    }

    private static String augGenTypeName(Map<String, GeneratedTypeBuilder> builders, String genTypeName) {
        int index = 1;
        if (builders != null) {
            while (builders.containsKey(genTypeName + index)) {
                ++index;
            }
        }
        return genTypeName + index;
    }

    private GeneratedTypeBuilder resolveDataSchemaNodes(ModuleContext context, GeneratedTypeBuilder parent, @Nullable Type childOf, Iterable<? extends DataSchemaNode> schemaNodes, boolean inGrouping) {
        if (schemaNodes != null && parent != null) {
            ConcreteType baseInterface = childOf == null ? BindingTypes.DATA_OBJECT : BindingTypes.childOf((Type)childOf);
            for (DataSchemaNode dataSchemaNode : schemaNodes) {
                if (dataSchemaNode.isAugmenting()) continue;
                this.addSchemaNodeToBuilderAsMethod(context, dataSchemaNode, parent, (Type)baseInterface, inGrouping);
            }
        }
        return parent;
    }

    private void addSchemaNodeToBuilderAsMethod(ModuleContext context, DataSchemaNode schemaNode, GeneratedTypeBuilder parent, Type baseInterface, boolean inGrouping) {
        if (!schemaNode.isAddedByUses()) {
            this.addUnambiguousNodeToBuilderAsMethod(context, schemaNode, parent, baseInterface, inGrouping);
        } else if (AbstractTypeGenerator.needGroupingMethodOverride(schemaNode, parent)) {
            this.addLeafrefNodeToBuilderAsMethod(context, (TypedDataSchemaNode)schemaNode, parent, inGrouping);
        }
    }

    private static boolean needGroupingMethodOverride(DataSchemaNode child, GeneratedTypeBuilder parent) {
        return child instanceof TypedDataSchemaNode && AbstractTypeGenerator.needGroupingMethodOverride((TypedDataSchemaNode)child, parent);
    }

    private static boolean needGroupingMethodOverride(TypedDataSchemaNode child, GeneratedTypeBuilder parent) {
        return AbstractTypeGenerator.isRelativeLeafref(child.getType()) && AbstractTypeGenerator.needMethodDefinition(child.getQName().getLocalName(), parent);
    }

    private static boolean needMethodDefinition(String localName, GeneratedTypeBuilder parent) {
        for (Type implementsType : parent.getImplementsTypes()) {
            if (!(implementsType instanceof GeneratedType)) continue;
            InheritedGetter precision = AbstractTypeGenerator.findInheritedGetter(localName, (GeneratedType)implementsType);
            switch (precision) {
                case RESOLVED: {
                    return false;
                }
                case UNRESOLVED: {
                    return true;
                }
            }
        }
        throw new IllegalStateException(localName + " should be present in " + parent + " or in one of its ancestors as a getter");
    }

    private static InheritedGetter findInheritedGetter(String localName, GeneratedType impl) {
        return AbstractTypeGenerator.findInheritedGetter(impl, BindingMapping.getGetterMethodName((String)localName));
    }

    private static InheritedGetter findInheritedGetter(GeneratedType type, String getter) {
        for (MethodSignature method : type.getMethodDefinitions()) {
            if (!getter.equals(method.getName())) continue;
            return InheritedGetter.fromAnnotations(method.getAnnotations());
        }
        for (Type implementsType : type.getImplements()) {
            InheritedGetter found;
            if (!(implementsType instanceof GeneratedType) || (found = AbstractTypeGenerator.findInheritedGetter((GeneratedType)implementsType, getter)) == InheritedGetter.NOT_PRESENT) continue;
            return found;
        }
        return InheritedGetter.NOT_PRESENT;
    }

    private static boolean isRelativeLeafref(TypeDefinition<? extends TypeDefinition<?>> type) {
        return type instanceof LeafrefTypeDefinition && !((LeafrefTypeDefinition)type).getPathStatement().isAbsolute();
    }

    private GeneratedTypeBuilder augSchemaNodeToMethods(ModuleContext context, GeneratedTypeBuilder typeBuilder, Iterable<? extends DataSchemaNode> schemaNodes, boolean inGrouping) {
        if (schemaNodes != null && typeBuilder != null) {
            ParameterizedType baseInterface = BindingTypes.childOf((Type)typeBuilder);
            for (DataSchemaNode dataSchemaNode : schemaNodes) {
                if (dataSchemaNode.isAugmenting()) continue;
                this.addSchemaNodeToBuilderAsMethod(context, dataSchemaNode, typeBuilder, (Type)baseInterface, inGrouping);
            }
        }
        return typeBuilder;
    }

    private void addLeafrefNodeToBuilderAsMethod(ModuleContext context, TypedDataSchemaNode node, GeneratedTypeBuilder typeBuilder, boolean inGrouping) {
        if (node != null && typeBuilder != null) {
            if (node instanceof LeafSchemaNode) {
                this.resolveLeafLeafrefNodeAsMethod(typeBuilder, (LeafSchemaNode)node, context, inGrouping);
            } else if (node instanceof LeafListSchemaNode) {
                this.resolveLeafListLeafrefNode(typeBuilder, (LeafListSchemaNode)node, context, inGrouping);
            } else {
                AbstractTypeGenerator.logUnableToAddNodeAsMethod((DataSchemaNode)node, typeBuilder);
            }
        }
    }

    private void addUnambiguousNodeToBuilderAsMethod(ModuleContext context, DataSchemaNode node, GeneratedTypeBuilder typeBuilder, Type baseInterface, boolean inGrouping) {
        if (node instanceof LeafSchemaNode) {
            this.resolveUnambiguousLeafNodeAsMethod(typeBuilder, (LeafSchemaNode)node, context, inGrouping);
        } else if (node instanceof LeafListSchemaNode) {
            this.resolveUnambiguousLeafListNode(typeBuilder, (LeafListSchemaNode)node, context, inGrouping);
        } else if (node instanceof ContainerSchemaNode) {
            this.containerToGenType(context, typeBuilder, baseInterface, (ContainerSchemaNode)node, inGrouping);
        } else if (node instanceof ListSchemaNode) {
            this.listToGenType(context, typeBuilder, baseInterface, (ListSchemaNode)node, inGrouping);
        } else if (node instanceof ChoiceSchemaNode) {
            this.choiceToGeneratedType(context, typeBuilder, (ChoiceSchemaNode)node, inGrouping);
        } else if (node instanceof AnyxmlSchemaNode || node instanceof AnydataSchemaNode) {
            this.opaqueToGeneratedType(context, typeBuilder, node);
        } else {
            AbstractTypeGenerator.logUnableToAddNodeAsMethod(node, typeBuilder);
        }
    }

    private static void logUnableToAddNodeAsMethod(DataSchemaNode node, GeneratedTypeBuilder typeBuilder) {
        LOG.debug("Unable to add schema node {} as method in {}: unsupported type of node.", node.getClass(), (Object)typeBuilder.getFullyQualifiedName());
    }

    private void choiceToGeneratedType(ModuleContext context, GeneratedTypeBuilder parent, ChoiceSchemaNode choiceNode, boolean inGrouping) {
        if (!choiceNode.isAddedByUses()) {
            GeneratedTypeBuilder choiceTypeBuilder = this.addRawInterfaceDefinition(context, JavaTypeName.create((String)BindingGeneratorUtil.packageNameForGeneratedType((String)context.modulePackageName(), (SchemaPath)choiceNode.getPath()), (String)BindingMapping.getClassName((QName)choiceNode.getQName())), (SchemaNode)choiceNode);
            choiceTypeBuilder.addImplementsType((Type)BindingTypes.choiceIn((Type)parent));
            AbstractTypeGenerator.annotateDeprecatedIfNecessary((DocumentedNode.WithStatus)choiceNode, (AnnotableTypeBuilder)choiceTypeBuilder);
            context.addChildNodeType((SchemaNode)choiceNode, choiceTypeBuilder);
            GeneratedType choiceType = choiceTypeBuilder.build();
            this.generateTypesFromChoiceCases(context, (Type)choiceType, choiceNode, inGrouping);
            this.constructGetter(parent, (Type)choiceType, (SchemaNode)choiceNode);
        }
    }

    private void opaqueToGeneratedType(ModuleContext context, GeneratedTypeBuilder parent, DataSchemaNode anyNode) {
        if (!anyNode.isAddedByUses()) {
            GeneratedTypeBuilder anyxmlTypeBuilder = this.addRawInterfaceDefinition(context, JavaTypeName.create((String)BindingGeneratorUtil.packageNameForGeneratedType((String)context.modulePackageName(), (SchemaPath)anyNode.getPath()), (String)BindingMapping.getClassName((QName)anyNode.getQName())), (SchemaNode)anyNode);
            ((GeneratedTypeBuilder)anyxmlTypeBuilder.addImplementsType((Type)BindingTypes.opaqueObject((Type)anyxmlTypeBuilder))).addImplementsType((Type)BindingTypes.childOf((Type)parent));
            AbstractTypeGenerator.defaultImplementedInterace(anyxmlTypeBuilder);
            AbstractTypeGenerator.annotateDeprecatedIfNecessary((DocumentedNode.WithStatus)anyNode, (AnnotableTypeBuilder)anyxmlTypeBuilder);
            context.addChildNodeType((SchemaNode)anyNode, anyxmlTypeBuilder);
            this.constructGetter(parent, (Type)anyxmlTypeBuilder.build(), (SchemaNode)anyNode);
        }
    }

    private void generateTypesFromChoiceCases(ModuleContext context, Type refChoiceType, ChoiceSchemaNode choiceNode, boolean inGrouping) {
        Preconditions.checkArgument((refChoiceType != null ? 1 : 0) != 0, (Object)"Referenced Choice Type cannot be NULL.");
        Preconditions.checkArgument((choiceNode != null ? 1 : 0) != 0, (Object)"ChoiceNode cannot be NULL.");
        for (CaseSchemaNode caseNode : choiceNode.getCases()) {
            if (caseNode != null && !caseNode.isAddedByUses() && !caseNode.isAugmenting()) {
                GeneratedTypeBuilder caseTypeBuilder = this.addDefaultInterfaceDefinition(context, (SchemaNode)caseNode);
                caseTypeBuilder.addImplementsType(refChoiceType);
                AbstractTypeGenerator.addConcreteInterfaceMethods(caseTypeBuilder);
                AbstractTypeGenerator.annotateDeprecatedIfNecessary((DocumentedNode.WithStatus)caseNode, (AnnotableTypeBuilder)caseTypeBuilder);
                context.addCaseType(caseNode.getPath(), caseTypeBuilder);
                context.addChoiceToCaseMapping(refChoiceType, (Type)caseTypeBuilder, caseNode);
                Collection caseChildNodes = caseNode.getChildNodes();
                if (caseChildNodes != null) {
                    SchemaPath choiceNodeParentPath = choiceNode.getPath().getParent();
                    if (!Iterables.isEmpty((Iterable)choiceNodeParentPath.getPathFromRoot())) {
                        SchemaNode parent = SchemaContextUtil.findDataSchemaNode((SchemaContext)this.schemaContext, (SchemaPath)choiceNodeParentPath);
                        if (parent instanceof AugmentationSchemaNode) {
                            AugmentationSchemaNode augSchema = (AugmentationSchemaNode)parent;
                            SchemaNodeIdentifier targetPath = augSchema.getTargetPath();
                            SchemaNode targetSchemaNode = SchemaContextUtil.findNodeInSchemaContext((SchemaContext)this.schemaContext, (Iterable)targetPath.getNodeIdentifiers());
                            if (targetSchemaNode instanceof DataSchemaNode && ((DataSchemaNode)targetSchemaNode).isAddedByUses()) {
                                if (targetSchemaNode instanceof DerivableSchemaNode) {
                                    targetSchemaNode = ((DerivableSchemaNode)targetSchemaNode).getOriginal().orElse(null);
                                }
                                if (targetSchemaNode == null) {
                                    throw new IllegalStateException("Failed to find target node from grouping for augmentation " + augSchema + " in module " + context.module().getName());
                                }
                            }
                            parent = targetSchemaNode;
                        }
                        Preconditions.checkState((parent != null ? 1 : 0) != 0, (String)"Could not find Choice node parent %s", (Object)choiceNodeParentPath);
                        GeneratedTypeBuilder childOfType = this.findChildNodeByPath(parent.getPath());
                        if (childOfType == null) {
                            childOfType = this.findGroupingByPath(parent.getPath());
                        }
                        this.resolveDataSchemaNodes(context, caseTypeBuilder, (Type)childOfType, caseChildNodes, inGrouping);
                    } else {
                        this.resolveDataSchemaNodes(context, caseTypeBuilder, (Type)this.moduleToDataType(context), caseChildNodes, inGrouping);
                    }
                }
            }
            this.processUsesAugments((DataNodeContainer)caseNode, context, inGrouping);
        }
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH"})
    private void generateTypesFromAugmentedChoiceCases(ModuleContext context, Type targetType, ChoiceSchemaNode targetNode, Iterable<? extends DataSchemaNode> augmentedNodes, DataNodeContainer usesNodeParent, boolean inGrouping) {
        Preconditions.checkArgument((targetType != null ? 1 : 0) != 0, (Object)"Referenced Choice Type cannot be NULL.");
        Preconditions.checkArgument((augmentedNodes != null ? 1 : 0) != 0, (Object)"Set of Choice Case Nodes cannot be NULL.");
        for (DataSchemaNode dataSchemaNode : augmentedNodes) {
            if (dataSchemaNode == null) continue;
            GeneratedTypeBuilder caseTypeBuilder = this.addDefaultInterfaceDefinition(context, (SchemaNode)dataSchemaNode);
            caseTypeBuilder.addImplementsType(targetType);
            AbstractTypeGenerator.addConcreteInterfaceMethods(caseTypeBuilder);
            CaseSchemaNode node = null;
            String caseLocalName = dataSchemaNode.getQName().getLocalName();
            if (dataSchemaNode instanceof CaseSchemaNode) {
                node = (CaseSchemaNode)dataSchemaNode;
            } else if (AbstractTypeGenerator.findNamedCase(targetNode, caseLocalName) == null) {
                String targetNodeLocalName = targetNode.getQName().getLocalName();
                for (DataSchemaNode dataSchemaNode2 : usesNodeParent.getChildNodes()) {
                    if (!(dataSchemaNode2 instanceof ChoiceSchemaNode) || !targetNodeLocalName.equals(dataSchemaNode2.getQName().getLocalName())) continue;
                    node = AbstractTypeGenerator.findNamedCase((ChoiceSchemaNode)dataSchemaNode2, caseLocalName);
                    break;
                }
            } else {
                node = AbstractTypeGenerator.findNamedCase(targetNode, caseLocalName);
            }
            Collection childNodes = node.getChildNodes();
            if (childNodes != null) {
                this.resolveDataSchemaNodes(context, caseTypeBuilder, (Type)this.findChildOfType(targetNode), childNodes, inGrouping);
            }
            context.addCaseType(dataSchemaNode.getPath(), caseTypeBuilder);
            context.addChoiceToCaseMapping(targetType, (Type)caseTypeBuilder, node);
        }
    }

    private GeneratedTypeBuilder findChildOfType(ChoiceSchemaNode targetNode) {
        SchemaPath nodePath = targetNode.getPath();
        SchemaPath parentSp = nodePath.getParent();
        if (parentSp.getParent() == null) {
            return this.moduleContext(nodePath.getLastComponent().getModule()).getModuleNode();
        }
        SchemaNode parent = SchemaContextUtil.findDataSchemaNode((SchemaContext)this.schemaContext, (SchemaPath)parentSp);
        GeneratedTypeBuilder childOfType = null;
        if (parent instanceof CaseSchemaNode) {
            childOfType = this.findCaseByPath(parent.getPath());
        } else if (parent instanceof DataSchemaNode || parent instanceof NotificationDefinition) {
            childOfType = this.findChildNodeByPath(parent.getPath());
        } else if (parent instanceof GroupingDefinition) {
            childOfType = this.findGroupingByPath(parent.getPath());
        }
        if (childOfType == null) {
            throw new IllegalArgumentException("Failed to find parent type of choice " + targetNode);
        }
        return childOfType;
    }

    private static CaseSchemaNode findNamedCase(ChoiceSchemaNode choice, String caseName) {
        List cases = choice.findCaseNodes(caseName);
        return cases.isEmpty() ? null : (CaseSchemaNode)cases.get(0);
    }

    private static boolean isInnerType(LeafSchemaNode leaf, TypeDefinition<?> type) {
        if (leaf.getPath().equals((Object)type.getPath())) {
            return true;
        }
        return leaf.getPath().equals((Object)type.getPath().getParent());
    }

    private void addPatternConstant(GeneratedTypeBuilder typeBuilder, String leafName, List<PatternConstraint> patternConstraints) {
        if (!patternConstraints.isEmpty()) {
            StringBuilder field = new StringBuilder().append("PATTERN_CONSTANTS").append("_").append(BindingMapping.getPropertyName((String)leafName));
            typeBuilder.addConstant(LIST_STRING_TYPE, field.toString(), this.typeProvider.resolveRegExpressions(patternConstraints));
        }
    }

    private Type resolveLeafLeafrefNodeAsMethod(GeneratedTypeBuilder typeBuilder, LeafSchemaNode leaf, ModuleContext context, boolean inGrouping) {
        Module parentModule = SchemaContextUtil.findParentModule((SchemaContext)this.schemaContext, (SchemaNode)leaf);
        Type returnType = this.resolveReturnType(typeBuilder, leaf, context, parentModule, inGrouping);
        if (returnType != null && AbstractTypeGenerator.isTypeSpecified(returnType)) {
            this.processContextRefExtension(leaf, this.constructOverrideGetter(typeBuilder, returnType, (SchemaNode)leaf), parentModule);
        }
        return returnType;
    }

    private void resolveLeafListNodeAsMethod(GeneratedTypeBuilder typeBuilder, LeafListSchemaNode leafList, ModuleContext context, boolean inGrouping) {
        if (!leafList.isAddedByUses()) {
            this.resolveUnambiguousLeafListNode(typeBuilder, leafList, context, inGrouping);
        } else if (AbstractTypeGenerator.needGroupingMethodOverride((TypedDataSchemaNode)leafList, typeBuilder)) {
            this.resolveLeafListLeafrefNode(typeBuilder, leafList, context, inGrouping);
        }
    }

    private Type resolveUnambiguousLeafNodeAsMethod(GeneratedTypeBuilder typeBuilder, LeafSchemaNode leaf, ModuleContext context, boolean inGrouping) {
        Module parentModule = SchemaContextUtil.findParentModule((SchemaContext)this.schemaContext, (SchemaNode)leaf);
        Type returnType = this.resolveReturnType(typeBuilder, leaf, context, parentModule, inGrouping);
        if (returnType != null) {
            this.processContextRefExtension(leaf, this.constructGetter(typeBuilder, returnType, (SchemaNode)leaf), parentModule);
        }
        return returnType;
    }

    private Type resolveReturnType(GeneratedTypeBuilder typeBuilder, LeafSchemaNode leaf, ModuleContext context, Module parentModule, boolean inGrouping) {
        Type returnType = null;
        TypeDefinition typeDef = CompatUtils.compatType((TypedDataSchemaNode)leaf);
        if (AbstractTypeGenerator.isInnerType(leaf, typeDef)) {
            if (typeDef instanceof EnumTypeDefinition) {
                EnumTypeDefinition enumTypeDef = (EnumTypeDefinition)typeDef;
                returnType = this.resolveInnerEnumFromTypeDefinition(enumTypeDef, leaf.getQName(), typeBuilder, context);
                this.typeProvider.putReferencedType(leaf.getPath(), returnType);
            } else if (typeDef instanceof UnionTypeDefinition) {
                UnionTypeDefinition unionDef = (UnionTypeDefinition)typeDef;
                returnType = this.addTOToTypeBuilder(unionDef, typeBuilder, (DataSchemaNode)leaf, parentModule);
                context.addInnerTypedefType(typeDef.getPath(), returnType);
            } else if (typeDef instanceof BitsTypeDefinition) {
                GeneratedTOBuilder genTOBuilder = this.addTOToTypeBuilder((BitsTypeDefinition)typeDef, typeBuilder, (DataSchemaNode)leaf, parentModule);
                if (genTOBuilder != null) {
                    returnType = genTOBuilder.build();
                }
            } else {
                SchemaNode leafrefTarget;
                Restrictions restrictions = BindingGeneratorUtil.getRestrictions((TypeDefinition)typeDef);
                TypeDefinition<?> baseOrDeclaredType = AbstractTypeGenerator.getBaseOrDeclaredType(typeDef);
                if (baseOrDeclaredType instanceof LeafrefTypeDefinition && (leafrefTarget = this.typeProvider.getTargetForLeafref((LeafrefTypeDefinition)baseOrDeclaredType, (SchemaNode)leaf)) instanceof TypedDataSchemaNode) {
                    returnType = context.getInnerType(((TypedDataSchemaNode)leafrefTarget).getType().getPath());
                }
                if (returnType == null) {
                    returnType = this.typeProvider.javaTypeForSchemaDefinitionType(baseOrDeclaredType, (SchemaNode)leaf, restrictions, inGrouping);
                }
                this.addPatternConstant(typeBuilder, leaf.getQName().getLocalName(), restrictions.getPatternConstraints());
            }
        } else {
            Restrictions restrictions = BindingGeneratorUtil.getRestrictions((TypeDefinition)typeDef);
            returnType = this.typeProvider.javaTypeForSchemaDefinitionType(typeDef, (SchemaNode)leaf, restrictions, inGrouping);
            this.addPatternConstant(typeBuilder, leaf.getQName().getLocalName(), restrictions.getPatternConstraints());
        }
        if (returnType == null) {
            return null;
        }
        if (typeDef instanceof EnumTypeDefinition) {
            this.typeProvider.putReferencedType(leaf.getPath(), returnType);
        }
        return returnType;
    }

    private static boolean isTypeSpecified(Type type) {
        return !type.equals(Types.objectType());
    }

    private static TypeDefinition<?> getBaseOrDeclaredType(TypeDefinition<?> typeDef) {
        TypeDefinition baseType = typeDef.getBaseType();
        return baseType != null && baseType.getBaseType() != null ? baseType : typeDef;
    }

    private void processContextRefExtension(LeafSchemaNode leaf, MethodSignatureBuilder getter, Module module) {
        for (UnknownSchemaNode node : leaf.getUnknownSchemaNodes()) {
            QName nodeType = node.getNodeType();
            if (!"context-reference".equals(nodeType.getLocalName())) continue;
            String nodeParam = node.getNodeParameter();
            IdentitySchemaNode identity = null;
            String basePackageName = null;
            Iterable splittedElement = COLON_SPLITTER.split((CharSequence)nodeParam);
            Iterator iterator = splittedElement.iterator();
            int length = Iterables.size((Iterable)splittedElement);
            if (length == 1) {
                identity = AbstractTypeGenerator.findIdentityByName(module.getIdentities(), (String)iterator.next());
                basePackageName = BindingMapping.getRootPackageName((QNameModule)module.getQNameModule());
            } else if (length == 2) {
                String prefix = (String)iterator.next();
                Module dependentModule = this.findModuleFromImports(module.getImports(), prefix);
                if (dependentModule == null) {
                    throw new IllegalArgumentException("Failed to process context-reference: unknown prefix " + prefix);
                }
                identity = AbstractTypeGenerator.findIdentityByName(dependentModule.getIdentities(), (String)iterator.next());
                basePackageName = BindingMapping.getRootPackageName((QNameModule)dependentModule.getQNameModule());
            } else {
                throw new IllegalArgumentException("Failed to process context-reference: unknown identity " + nodeParam);
            }
            if (identity == null) {
                throw new IllegalArgumentException("Failed to process context-reference: unknown identity " + nodeParam);
            }
            AnnotationTypeBuilder rc = getter.addAnnotation(BindingTypes.ROUTING_CONTEXT);
            String packageName = BindingGeneratorUtil.packageNameForGeneratedType((String)basePackageName, (SchemaPath)identity.getPath());
            String genTypeName = BindingMapping.getClassName((String)identity.getQName().getLocalName());
            rc.addParameter("value", packageName + "." + genTypeName + ".class");
        }
    }

    private static IdentitySchemaNode findIdentityByName(Collection<? extends IdentitySchemaNode> identities, String name) {
        for (IdentitySchemaNode identitySchemaNode : identities) {
            if (!identitySchemaNode.getQName().getLocalName().equals(name)) continue;
            return identitySchemaNode;
        }
        return null;
    }

    private Module findModuleFromImports(Collection<? extends ModuleImport> imports, String prefix) {
        for (ModuleImport moduleImport : imports) {
            if (!moduleImport.getPrefix().equals(prefix)) continue;
            return this.schemaContext.findModule(moduleImport.getModuleName(), moduleImport.getRevision()).orElse(null);
        }
        return null;
    }

    private boolean resolveLeafSchemaNodeAsProperty(GeneratedTOBuilder toBuilder, LeafSchemaNode leaf, boolean isReadOnly) {
        if (leaf != null && toBuilder != null) {
            Type returnType;
            TypeDefinition typeDef = CompatUtils.compatType((TypedDataSchemaNode)leaf);
            if (typeDef instanceof UnionTypeDefinition) {
                ModuleContext mc = this.moduleContext(typeDef.getQName().getModule());
                returnType = mc.getTypedefs().get(typeDef.getPath());
                if (returnType == null) {
                    returnType = mc.getInnerType(typeDef.getPath());
                }
            } else if (typeDef instanceof EnumTypeDefinition && typeDef.getBaseType() == null) {
                LeafSchemaNode originalLeaf = (LeafSchemaNode)SchemaNodeUtils.getRootOriginalIfPossible((SchemaNode)leaf);
                QName qname = originalLeaf.getQName();
                returnType = this.moduleContext(qname.getModule()).getInnerType(originalLeaf.getType().getPath());
            } else {
                returnType = this.typeProvider.javaTypeForSchemaDefinitionType(typeDef, (SchemaNode)leaf);
            }
            return this.resolveLeafSchemaNodeAsProperty(toBuilder, leaf, returnType, isReadOnly);
        }
        return false;
    }

    private boolean resolveLeafSchemaNodeAsProperty(GeneratedTOBuilder toBuilder, LeafSchemaNode leaf, Type returnType, boolean isReadOnly) {
        if (returnType == null) {
            return false;
        }
        String leafName = leaf.getQName().getLocalName();
        GeneratedPropertyBuilder propBuilder = toBuilder.addProperty(BindingMapping.getPropertyName((String)leafName));
        propBuilder.setReadOnly(isReadOnly);
        propBuilder.setReturnType(returnType);
        this.addComment((TypeMemberBuilder<?>)propBuilder, (DocumentedNode)leaf);
        toBuilder.addEqualsIdentity(propBuilder);
        toBuilder.addHashIdentity(propBuilder);
        toBuilder.addToStringProperty(propBuilder);
        return true;
    }

    private void resolveLeafListLeafrefNode(GeneratedTypeBuilder typeBuilder, LeafListSchemaNode node, ModuleContext context, boolean inGrouping) {
        Type returnType = this.resolveLeafListItemsType(typeBuilder, node, context, inGrouping, SchemaContextUtil.findParentModule((SchemaContext)this.schemaContext, (SchemaNode)node));
        if (AbstractTypeGenerator.isTypeSpecified(returnType)) {
            this.constructOverrideGetter(typeBuilder, (Type)Types.listTypeFor((Type)returnType), (SchemaNode)node);
        }
    }

    private Type resolveUnambiguousLeafListNode(GeneratedTypeBuilder typeBuilder, LeafListSchemaNode node, ModuleContext context, boolean inGrouping) {
        Module parentModule = SchemaContextUtil.findParentModule((SchemaContext)this.schemaContext, (SchemaNode)node);
        Type listItemsType = this.resolveLeafListItemsType(typeBuilder, node, context, inGrouping, parentModule);
        ParameterizedType returnType = listItemsType.equals(Types.objectType()) ? Types.listTypeWildcard() : Types.listTypeFor((Type)listItemsType);
        this.constructGetter(typeBuilder, (Type)returnType, (SchemaNode)node);
        return returnType;
    }

    private Type resolveLeafListItemsType(GeneratedTypeBuilder typeBuilder, LeafListSchemaNode node, ModuleContext context, boolean inGrouping, Module parentModule) {
        Type returnType;
        TypeDefinition typeDef = node.getType();
        if (typeDef.getBaseType() == null) {
            if (typeDef instanceof EnumTypeDefinition) {
                EnumTypeDefinition enumTypeDef = (EnumTypeDefinition)typeDef;
                returnType = this.resolveInnerEnumFromTypeDefinition(enumTypeDef, node.getQName(), typeBuilder, context);
                this.typeProvider.putReferencedType(node.getPath(), returnType);
            } else if (typeDef instanceof UnionTypeDefinition) {
                UnionTypeDefinition unionDef = (UnionTypeDefinition)typeDef;
                returnType = this.addTOToTypeBuilder(unionDef, typeBuilder, (DataSchemaNode)node, parentModule);
            } else if (typeDef instanceof BitsTypeDefinition) {
                GeneratedTOBuilder genTOBuilder = this.addTOToTypeBuilder((BitsTypeDefinition)typeDef, typeBuilder, (DataSchemaNode)node, parentModule);
                returnType = genTOBuilder.build();
            } else {
                Restrictions restrictions = BindingGeneratorUtil.getRestrictions((TypeDefinition)typeDef);
                returnType = this.typeProvider.javaTypeForSchemaDefinitionType(typeDef, (SchemaNode)node, restrictions, inGrouping);
                this.addPatternConstant(typeBuilder, node.getQName().getLocalName(), restrictions.getPatternConstraints());
            }
        } else {
            Restrictions restrictions = BindingGeneratorUtil.getRestrictions((TypeDefinition)typeDef);
            returnType = this.typeProvider.javaTypeForSchemaDefinitionType(typeDef, (SchemaNode)node, restrictions, inGrouping);
            this.addPatternConstant(typeBuilder, node.getQName().getLocalName(), restrictions.getPatternConstraints());
        }
        return returnType;
    }

    private Type createReturnTypeForUnion(GeneratedTOBuilder genTOBuilder, UnionTypeDefinition typeDef, GeneratedTypeBuilder typeBuilder, Module parentModule) {
        GeneratedTOBuilder returnTypeBuilder = this.typeProvider.newGeneratedTOBuilder((JavaTypeName)genTOBuilder.getIdentifier());
        returnTypeBuilder.setIsUnion(true);
        this.addCodegenInformation((GeneratedTypeBuilderBase<?>)returnTypeBuilder, parentModule, (SchemaNode)typeDef);
        returnTypeBuilder.setSchemaPath(typeDef.getPath());
        returnTypeBuilder.setModuleName(parentModule.getName());
        GeneratedTransferObject returnType = returnTypeBuilder.build();
        genTOBuilder.setTypedef(true);
        genTOBuilder.setIsUnion(true);
        AbstractTypeProvider.addUnitsToGenTO(genTOBuilder, typeDef.getUnits().orElse(null));
        this.createUnionBuilder(genTOBuilder, typeBuilder, returnType, parentModule);
        return returnType;
    }

    private void createUnionBuilder(GeneratedTOBuilder genTOBuilder, GeneratedTypeBuilder typeBuilder, GeneratedTransferObject returnType, Module parentModule) {
        StringBuilder sb = new StringBuilder();
        ((JavaTypeName)genTOBuilder.getIdentifier()).localNameComponents().forEach(sb::append);
        GeneratedTOBuilder unionBuilder = this.typeProvider.newGeneratedTOBuilder(JavaTypeName.create((String)typeBuilder.getPackageName(), (String)sb.append("Builder").toString()));
        unionBuilder.setIsUnionBuilder(true);
        MethodSignatureBuilder method = unionBuilder.addMethod("getDefaultInstance");
        method.setReturnType((Type)returnType);
        method.addParameter((Type)Types.STRING, "defaultValue");
        method.setAccessModifier(AccessModifier.PUBLIC);
        method.setStatic(true);
        GeneratedTransferObject unionBuilderType = unionBuilder.build();
        this.typeProvider.getAdditionalTypes().computeIfAbsent(parentModule, key -> new HashSet()).add(unionBuilderType);
    }

    private GeneratedTypeBuilder addDefaultInterfaceDefinition(ModuleContext context, SchemaNode schemaNode) {
        return this.addDefaultInterfaceDefinition(context, schemaNode, (Type)BindingTypes.DATA_OBJECT);
    }

    private GeneratedTypeBuilder addDefaultInterfaceDefinition(ModuleContext context, SchemaNode schemaNode, Type baseInterface) {
        String packageName = BindingGeneratorUtil.packageNameForGeneratedType((String)context.modulePackageName(), (SchemaPath)schemaNode.getPath());
        return this.addDefaultInterfaceDefinition(packageName, schemaNode, baseInterface, context);
    }

    private GeneratedTypeBuilder addDefaultInterfaceDefinition(String packageName, SchemaNode schemaNode, Type baseInterface, ModuleContext context) {
        JavaTypeName name = this.renames.get(schemaNode);
        if (name == null) {
            name = JavaTypeName.create((String)packageName, (String)BindingMapping.getClassName((QName)schemaNode.getQName()));
        }
        GeneratedTypeBuilder it = this.addRawInterfaceDefinition(context, name, schemaNode);
        it.addImplementsType(baseInterface);
        if (!(schemaNode instanceof GroupingDefinition)) {
            it.addImplementsType((Type)BindingTypes.augmentable((Type)it));
        }
        if (schemaNode instanceof DataNodeContainer) {
            DataNodeContainer containerSchema = (DataNodeContainer)schemaNode;
            this.groupingsToGenTypes(context, containerSchema.getGroupings());
            this.addImplementedInterfaceFromUses(containerSchema, it);
        }
        return it;
    }

    private GeneratedTypeBuilder addRawInterfaceDefinition(ModuleContext context, JavaTypeName identifier, SchemaNode schemaNode) {
        Preconditions.checkArgument((schemaNode != null ? 1 : 0) != 0, (Object)"Data Schema Node cannot be NULL.");
        Preconditions.checkArgument((schemaNode.getQName() != null ? 1 : 0) != 0, (Object)"QName for Data Schema Node cannot be NULL.");
        String schemaNodeName = schemaNode.getQName().getLocalName();
        Preconditions.checkArgument((schemaNodeName != null ? 1 : 0) != 0, (Object)"Local Name of QName for Data Schema Node cannot be NULL.");
        GeneratedTypeBuilder newType = this.typeProvider.newGeneratedTypeBuilder(identifier);
        AbstractTypeGenerator.qnameConstant(newType, context.moduleInfoType(), schemaNode.getQName().getLocalName());
        Module module = context.module();
        this.addCodegenInformation((GeneratedTypeBuilderBase<?>)newType, module, schemaNode);
        newType.setSchemaPath(schemaNode.getPath());
        newType.setModuleName(module.getName());
        String packageName = identifier.packageName();
        String simpleName = identifier.simpleName();
        if (!this.genTypeBuilders.containsKey(packageName)) {
            HashMap<String, GeneratedTypeBuilder> builders = new HashMap<String, GeneratedTypeBuilder>();
            builders.put(simpleName, newType);
            this.genTypeBuilders.put(packageName, builders);
        } else {
            Map<String, GeneratedTypeBuilder> builders = this.genTypeBuilders.get(packageName);
            if (!builders.containsKey(simpleName)) {
                builders.put(simpleName, newType);
            }
        }
        return newType;
    }

    private MethodSignatureBuilder constructGetter(GeneratedTypeBuilder interfaceBuilder, Type returnType, SchemaNode node) {
        MethodSignatureBuilder getMethod = interfaceBuilder.addMethod(BindingMapping.getGetterMethodName((String)node.getQName().getLocalName()));
        getMethod.setReturnType(returnType);
        AbstractTypeGenerator.annotateDeprecatedIfNecessary((DocumentedNode.WithStatus)node, (AnnotableTypeBuilder)getMethod);
        this.addComment((TypeMemberBuilder<?>)getMethod, (DocumentedNode)node);
        if (Types.BOOLEAN.equals(returnType)) {
            ((MethodSignatureBuilder)interfaceBuilder.addMethod(BindingMapping.getGetterMethodName((String)node.getQName().getLocalName(), (boolean)true)).setAccessModifier(AccessModifier.PUBLIC)).setDefault(true).setReturnType((Type)Types.BOOLEAN);
        }
        return getMethod;
    }

    private MethodSignatureBuilder constructOverrideGetter(GeneratedTypeBuilder interfaceBuilder, Type returnType, SchemaNode node) {
        MethodSignatureBuilder getter = this.constructGetter(interfaceBuilder, returnType, node);
        getter.addAnnotation(OVERRIDE_ANNOTATION);
        return getter;
    }

    private static void constructNonnull(GeneratedTypeBuilder interfaceBuilder, Type returnType, ListSchemaNode node) {
        MethodSignatureBuilder getMethod = interfaceBuilder.addMethod(BindingMapping.getNonnullMethodName((String)node.getQName().getLocalName()));
        ((MethodSignatureBuilder)getMethod.setReturnType(returnType)).setDefault(true);
        AbstractTypeGenerator.annotateDeprecatedIfNecessary((DocumentedNode.WithStatus)node, (AnnotableTypeBuilder)getMethod);
    }

    private void addSchemaNodeToListBuilders(ModuleContext context, DataSchemaNode schemaNode, GeneratedTypeBuilder typeBuilder, GeneratedTOBuilder genTOBuilder, List<String> listKeys, boolean inGrouping) {
        Preconditions.checkArgument((schemaNode != null ? 1 : 0) != 0, (Object)"Data Schema Node cannot be NULL.");
        Preconditions.checkArgument((typeBuilder != null ? 1 : 0) != 0, (Object)"Generated Type Builder cannot be NULL.");
        if (schemaNode instanceof LeafSchemaNode) {
            LeafSchemaNode leaf = (LeafSchemaNode)schemaNode;
            String leafName = leaf.getQName().getLocalName();
            Type type = !schemaNode.isAddedByUses() ? this.resolveUnambiguousLeafNodeAsMethod(typeBuilder, leaf, context, inGrouping) : (AbstractTypeGenerator.needGroupingMethodOverride((TypedDataSchemaNode)leaf, typeBuilder) ? this.resolveLeafLeafrefNodeAsMethod(typeBuilder, leaf, context, inGrouping) : null);
            if (listKeys.contains(leafName)) {
                if (type == null) {
                    this.resolveLeafSchemaNodeAsProperty(genTOBuilder, leaf, true);
                } else {
                    this.resolveLeafSchemaNodeAsProperty(genTOBuilder, leaf, type, true);
                }
            }
        } else if (schemaNode instanceof LeafListSchemaNode) {
            this.resolveLeafListNodeAsMethod(typeBuilder, (LeafListSchemaNode)schemaNode, context, inGrouping);
        } else if (!schemaNode.isAddedByUses()) {
            if (schemaNode instanceof ContainerSchemaNode) {
                this.containerToGenType(context, typeBuilder, (Type)BindingTypes.childOf((Type)typeBuilder), (ContainerSchemaNode)schemaNode, inGrouping);
            } else if (schemaNode instanceof ChoiceSchemaNode) {
                this.choiceToGeneratedType(context, typeBuilder, (ChoiceSchemaNode)schemaNode, inGrouping);
            } else if (schemaNode instanceof ListSchemaNode) {
                this.listToGenType(context, typeBuilder, (Type)BindingTypes.childOf((Type)typeBuilder), (ListSchemaNode)schemaNode, inGrouping);
            } else if (schemaNode instanceof AnyxmlSchemaNode || schemaNode instanceof AnydataSchemaNode) {
                this.opaqueToGeneratedType(context, typeBuilder, schemaNode);
            }
        }
    }

    private static void typeBuildersToGenTypes(ModuleContext context, GeneratedTypeBuilder typeBuilder, GeneratedTOBuilder genTOBuilder) {
        Preconditions.checkArgument((typeBuilder != null ? 1 : 0) != 0, (Object)"Generated Type Builder cannot be NULL.");
        if (genTOBuilder != null) {
            GeneratedTransferObject genTO = genTOBuilder.build();
            ((MethodSignatureBuilder)typeBuilder.addMethod("key").setReturnType((Type)genTO)).addAnnotation(OVERRIDE_ANNOTATION);
            context.addGeneratedTOBuilder(genTOBuilder);
        }
    }

    private static List<String> listKeys(ListSchemaNode list) {
        List keyDefinition = list.getKeyDefinition();
        switch (keyDefinition.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(((QName)keyDefinition.get(0)).getLocalName());
            }
        }
        ArrayList<String> listKeys = new ArrayList<String>(keyDefinition.size());
        for (QName keyDef : keyDefinition) {
            listKeys.add(keyDef.getLocalName());
        }
        return listKeys;
    }

    private Type addTOToTypeBuilder(UnionTypeDefinition typeDef, GeneratedTypeBuilder typeBuilder, DataSchemaNode leaf, Module parentModule) {
        List<GeneratedTOBuilder> types = this.typeProvider.provideGeneratedTOBuildersForUnionTypeDef(AbstractTypeGenerator.allocateNestedType((JavaTypeName)typeBuilder.getIdentifier(), leaf.getQName()), typeDef, (SchemaNode)leaf);
        Preconditions.checkState((!types.isEmpty() ? 1 : 0) != 0, (String)"No GeneratedTOBuilder objects generated from union %s", (Object)typeDef);
        ArrayList<GeneratedTOBuilder> genTOBuilders = new ArrayList<GeneratedTOBuilder>(types);
        GeneratedTOBuilder resultTOBuilder = types.remove(0);
        types.forEach(arg_0 -> ((GeneratedTOBuilder)resultTOBuilder).addEnclosingTransferObject(arg_0));
        genTOBuilders.forEach(arg_0 -> ((GeneratedTypeBuilder)typeBuilder).addEnclosingTransferObject(arg_0));
        for (GeneratedTOBuilder builder : types) {
            if (!builder.isUnion()) continue;
            GeneratedTransferObject type = builder.build();
            this.createUnionBuilder(builder, typeBuilder, type, parentModule);
        }
        return this.createReturnTypeForUnion(resultTOBuilder, typeDef, typeBuilder, parentModule);
    }

    private GeneratedTOBuilder addTOToTypeBuilder(BitsTypeDefinition typeDef, GeneratedTypeBuilder typeBuilder, DataSchemaNode leaf, Module parentModule) {
        GeneratedTOBuilder genTOBuilder = this.typeProvider.provideGeneratedTOBuilderForBitsTypeDefinition(AbstractTypeGenerator.allocateNestedType((JavaTypeName)typeBuilder.getIdentifier(), leaf.getQName()), typeDef, parentModule.getName());
        typeBuilder.addEnclosingTransferObject(genTOBuilder);
        return genTOBuilder;
    }

    private GeneratedTypeBuilder addImplementedInterfaceFromUses(DataNodeContainer dataNodeContainer, GeneratedTypeBuilder builder) {
        for (UsesNode usesNode : dataNodeContainer.getUses()) {
            GeneratedTypeBuilder genType = this.findGrouping(usesNode.getSourceGrouping());
            if (genType == null) {
                throw new IllegalStateException("Grouping " + usesNode.getSourceGrouping().getQName() + " is not resolved for " + builder.getFullyQualifiedName());
            }
            builder.addImplementsType((Type)genType.build());
        }
        return builder;
    }

    private JavaTypeName findAliasByPath(SchemaPath path) {
        for (ModuleContext ctx : this.genCtx.values()) {
            JavaTypeName result = ctx.getAlias(path);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private GeneratedTypeBuilder findChildNodeByPath(SchemaPath path) {
        for (ModuleContext ctx : this.genCtx.values()) {
            GeneratedTypeBuilder result = ctx.getChildNode(path);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private GeneratedTypeBuilder findGrouping(GroupingDefinition grouping) {
        for (ModuleContext ctx : this.genCtx.values()) {
            GeneratedTypeBuilder result = ctx.getGrouping(grouping.getPath());
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private GeneratedTypeBuilder findGroupingByPath(SchemaPath path) {
        for (ModuleContext ctx : this.genCtx.values()) {
            GeneratedTypeBuilder result = ctx.getGrouping(path);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private GeneratedTypeBuilder findCaseByPath(SchemaPath path) {
        for (ModuleContext ctx : this.genCtx.values()) {
            GeneratedTypeBuilder result = ctx.getCase(path);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private static JavaTypeName allocateNestedType(JavaTypeName parent, QName child) {
        return parent.createEnclosed(BindingMapping.getClassName((QName)child), "$");
    }

    private static void annotateDeprecatedIfNecessary(DocumentedNode.WithStatus node, AnnotableTypeBuilder builder) {
        switch (node.getStatus()) {
            case DEPRECATED: {
                builder.addAnnotation(DEPRECATED_ANNOTATION);
                break;
            }
            case OBSOLETE: {
                builder.addAnnotation(DEPRECATED_ANNOTATION).addParameter("forRemoval", "true");
                break;
            }
            case CURRENT: {
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled status in " + node);
            }
        }
    }

    private static void addConcreteInterfaceMethods(GeneratedTypeBuilder typeBuilder) {
        AbstractTypeGenerator.defaultImplementedInterace(typeBuilder);
        ((MethodSignatureBuilder)((MethodSignatureBuilder)typeBuilder.addMethod("bindingHashCode").setAccessModifier(AccessModifier.PUBLIC)).setStatic(true)).setReturnType((Type)Types.primitiveIntType());
        ((MethodSignatureBuilder)((MethodSignatureBuilder)typeBuilder.addMethod("bindingEquals").setAccessModifier(AccessModifier.PUBLIC)).setStatic(true)).setReturnType((Type)Types.primitiveBooleanType());
        ((MethodSignatureBuilder)((MethodSignatureBuilder)typeBuilder.addMethod("bindingToString").setAccessModifier(AccessModifier.PUBLIC)).setStatic(true)).setReturnType((Type)Types.STRING);
    }

    private static void narrowImplementedInterface(GeneratedTypeBuilder typeBuilder) {
        AbstractTypeGenerator.defineImplementedInterfaceMethod(typeBuilder, (Type)Types.wildcardTypeFor((JavaTypeName)((JavaTypeName)typeBuilder.getIdentifier())));
    }

    private static void defaultImplementedInterace(GeneratedTypeBuilder typeBuilder) {
        AbstractTypeGenerator.defineImplementedInterfaceMethod(typeBuilder, (Type)DefaultType.of((Identifiable)typeBuilder)).setDefault(true);
    }

    private static MethodSignatureBuilder defineImplementedInterfaceMethod(GeneratedTypeBuilder typeBuilder, Type classType) {
        MethodSignatureBuilder ret = (MethodSignatureBuilder)((MethodSignatureBuilder)typeBuilder.addMethod("implementedInterface").setAccessModifier(AccessModifier.PUBLIC)).setReturnType((Type)Types.classType((Type)classType));
        ret.addAnnotation(OVERRIDE_ANNOTATION);
        return ret;
    }

    private static enum InheritedGetter {
        NOT_PRESENT,
        RESOLVED,
        UNRESOLVED;


        static InheritedGetter fromAnnotations(List<AnnotationType> annotations) {
            for (AnnotationType annotation : annotations) {
                if (!OVERRIDE_ANNOTATION.equals(annotation.getIdentifier())) continue;
                return RESOLVED;
            }
            return UNRESOLVED;
        }
    }
}

