/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.generator.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opendaylight.mdsal.binding.generator.impl.AbstractTypeGenerator;
import org.opendaylight.mdsal.binding.model.api.JavaTypeName;
import org.opendaylight.mdsal.binding.model.api.Type;
import org.opendaylight.mdsal.binding.model.api.TypeComment;
import org.opendaylight.mdsal.binding.model.api.TypeMemberComment;
import org.opendaylight.mdsal.binding.model.api.YangSourceDefinition;
import org.opendaylight.mdsal.binding.model.api.type.builder.GeneratedTypeBuilder;
import org.opendaylight.mdsal.binding.model.api.type.builder.GeneratedTypeBuilderBase;
import org.opendaylight.mdsal.binding.model.api.type.builder.TypeMemberBuilder;
import org.opendaylight.mdsal.binding.model.util.TypeComments;
import org.opendaylight.mdsal.binding.yang.types.CodegenTypeProvider;
import org.opendaylight.yangtools.yang.model.api.DocumentedNode;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;

final class CodegenTypeGenerator
extends AbstractTypeGenerator {
    CodegenTypeGenerator(EffectiveModelContext context, Map<SchemaNode, JavaTypeName> renames) {
        super(context, new CodegenTypeProvider((SchemaContext)context, renames), renames);
    }

    List<Type> toTypes(Collection<? extends Module> modules) {
        ArrayList<Type> filteredGenTypes = new ArrayList<Type>();
        for (Module module : modules) {
            filteredGenTypes.addAll(this.moduleContext(module.getQNameModule()).getGeneratedTypes());
            Set<Type> additionalTypes = this.typeProvider().getAdditionalTypes().get(module);
            if (additionalTypes == null) continue;
            filteredGenTypes.addAll(additionalTypes);
        }
        return filteredGenTypes;
    }

    @Override
    void addCodegenInformation(GeneratedTypeBuilderBase<?> genType, Module module, SchemaNode node) {
        YangSourceDefinition.of((Module)module, (SchemaNode)node).ifPresent(arg_0 -> genType.setYangSourceDefinition(arg_0));
        TypeComments.description((DocumentedNode)node).ifPresent(arg_0 -> genType.addComment(arg_0));
        node.getDescription().ifPresent(arg_0 -> genType.setDescription(arg_0));
        node.getReference().ifPresent(arg_0 -> genType.setReference(arg_0));
    }

    @Override
    void addCodegenInformation(GeneratedTypeBuilderBase<?> genType, Module module) {
        YangSourceDefinition.of((Module)module).ifPresent(arg_0 -> genType.setYangSourceDefinition(arg_0));
        TypeComments.description((DocumentedNode)module).ifPresent(arg_0 -> genType.addComment(arg_0));
        module.getDescription().ifPresent(arg_0 -> genType.setDescription(arg_0));
        module.getReference().ifPresent(arg_0 -> genType.setReference(arg_0));
    }

    @Override
    void addCodegenInformation(GeneratedTypeBuilder interfaceBuilder, Module module, String description, Collection<? extends SchemaNode> nodes) {
        interfaceBuilder.addComment((TypeComment)TypeComments.javadoc((String)("Interface for implementing the following YANG " + description + " defined in module <b>" + module.getName() + "</b>")).get());
        YangSourceDefinition.of((Module)module, nodes).ifPresent(arg_0 -> ((GeneratedTypeBuilder)interfaceBuilder).setYangSourceDefinition(arg_0));
    }

    @Override
    void addComment(TypeMemberBuilder<?> genType, DocumentedNode node) {
        node.getDescription().map(TypeMemberComment::referenceOf).ifPresent(arg_0 -> genType.setComment(arg_0));
    }

    @Override
    void addRpcMethodComment(TypeMemberBuilder<?> genType, RpcDefinition node) {
        String rpcName = node.getQName().getLocalName();
        genType.setComment(new TypeMemberComment("Invoke {@code " + rpcName + "} RPC.", (String)node.getDescription().orElse(null), "@param input of {@code " + rpcName + "}\n@return output of {@code " + rpcName + "}"));
    }
}

