/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.generator.impl;

import com.google.common.annotations.Beta;
import java.util.IdentityHashMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.opendaylight.mdsal.binding.generator.impl.GeneratorUtils;
import org.opendaylight.mdsal.binding.generator.impl.RenameMappingException;
import org.opendaylight.mdsal.binding.generator.impl.RuntimeTypeGenerator;
import org.opendaylight.mdsal.binding.model.api.JavaTypeName;
import org.opendaylight.mdsal.binding.runtime.api.BindingRuntimeGenerator;
import org.opendaylight.mdsal.binding.runtime.api.BindingRuntimeTypes;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Beta
@Component(immediate=true)
public final class DefaultBindingRuntimeGenerator
implements BindingRuntimeGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultBindingRuntimeGenerator.class);

    @Inject
    public DefaultBindingRuntimeGenerator() {
    }

    public BindingRuntimeTypes generateTypeMapping(EffectiveModelContext context) {
        GeneratorUtils.checkContext((SchemaContext)context);
        IdentityHashMap<SchemaNode, JavaTypeName> renames = new IdentityHashMap<SchemaNode, JavaTypeName>();
        while (true) {
            try {
                return new RuntimeTypeGenerator(context, renames).toTypeMapping();
            }
            catch (RenameMappingException e) {
                GeneratorUtils.rename(renames, e);
                continue;
            }
            break;
        }
    }

    @Activate
    void activate() {
        LOG.info("Binding/YANG type support activated");
    }

    @Deactivate
    void deactivate() {
        LOG.info("Binding/YANG type support deactivated");
    }
}

