/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.generator.impl;

import com.google.common.base.Preconditions;
import java.util.Map;
import org.opendaylight.mdsal.binding.generator.impl.RenameMappingException;
import org.opendaylight.mdsal.binding.model.api.JavaTypeName;
import org.opendaylight.yangtools.yang.model.api.GroupingDefinition;
import org.opendaylight.yangtools.yang.model.api.IdentitySchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class GeneratorUtils {
    private static final Logger LOG = LoggerFactory.getLogger(GeneratorUtils.class);

    private GeneratorUtils() {
    }

    static void checkContext(SchemaContext context) {
        Preconditions.checkArgument((context != null ? 1 : 0) != 0, (Object)"Schema Context reference cannot be NULL.");
        Preconditions.checkState((context.getModules() != null ? 1 : 0) != 0, (Object)"Schema Context does not contain defined modules.");
    }

    static void rename(Map<SchemaNode, JavaTypeName> renames, RenameMappingException ex) {
        String suffix;
        JavaTypeName name = ex.getName();
        SchemaNode def = ex.getDefinition();
        JavaTypeName existing = renames.get(def);
        if (existing != null) {
            throw new IllegalStateException("Attempted to relocate " + def + " to " + name + ", already remapped to " + existing, ex);
        }
        if (def instanceof IdentitySchemaNode) {
            suffix = "$I";
        } else if (def instanceof GroupingDefinition) {
            suffix = "$G";
        } else if (def instanceof TypeDefinition) {
            suffix = "$T";
        } else {
            throw new IllegalStateException("Unhandled remapping of " + def + " at " + name, ex);
        }
        JavaTypeName newName = name.createSibling(name.simpleName() + suffix);
        renames.put(def, newName);
        LOG.debug("Restarting code generation after remapping {} to {}", (Object)name, (Object)newName);
    }
}

