/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.generator.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.binding.generator.impl.RenameMappingException;
import org.opendaylight.mdsal.binding.model.api.GeneratedType;
import org.opendaylight.mdsal.binding.model.api.JavaTypeName;
import org.opendaylight.mdsal.binding.model.api.Type;
import org.opendaylight.mdsal.binding.model.api.type.builder.GeneratedTOBuilder;
import org.opendaylight.mdsal.binding.model.api.type.builder.GeneratedTypeBuilder;
import org.opendaylight.mdsal.binding.spec.naming.BindingMapping;
import org.opendaylight.yangtools.concepts.Mutable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchemaNode;
import org.opendaylight.yangtools.yang.model.api.CaseSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ContainerLike;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DocumentedNode;
import org.opendaylight.yangtools.yang.model.api.GroupingDefinition;
import org.opendaylight.yangtools.yang.model.api.IdentitySchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.NotificationDefinition;
import org.opendaylight.yangtools.yang.model.api.OperationDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ModuleContext
implements Mutable {
    private static final Logger LOG = LoggerFactory.getLogger(ModuleContext.class);
    private final BiMap<Type, AugmentationSchemaNode> typeToAugmentation = HashBiMap.create();
    private final Map<SchemaPath, GeneratedTypeBuilder> childNodes = new HashMap<SchemaPath, GeneratedTypeBuilder>();
    private final Map<SchemaPath, GeneratedTypeBuilder> groupings = new HashMap<SchemaPath, GeneratedTypeBuilder>();
    private final BiMap<Type, CaseSchemaNode> caseTypeToSchema = HashBiMap.create();
    private final Map<SchemaPath, GeneratedTypeBuilder> cases = new HashMap<SchemaPath, GeneratedTypeBuilder>();
    private final Map<QName, GeneratedTypeBuilder> identities = new HashMap<QName, GeneratedTypeBuilder>();
    private final List<GeneratedTypeBuilder> augmentations = new ArrayList<GeneratedTypeBuilder>();
    private final Multimap<Type, Type> choiceToCases = HashMultimap.create();
    private final Set<GeneratedTypeBuilder> topLevelNodes = new HashSet<GeneratedTypeBuilder>();
    private final Map<SchemaPath, JavaTypeName> aliases = new HashMap<SchemaPath, JavaTypeName>();
    private final Map<Type, DocumentedNode.WithStatus> typeToSchema = new HashMap<Type, DocumentedNode.WithStatus>();
    private final List<GeneratedTOBuilder> genTOs = new ArrayList<GeneratedTOBuilder>();
    private final Map<SchemaPath, Type> innerTypes = new HashMap<SchemaPath, Type>();
    private final Map<SchemaPath, Type> typedefs = new HashMap<SchemaPath, Type>();
    private final Module module;
    private final Map<JavaTypeName, SchemaNode> nameMapping = new HashMap<JavaTypeName, SchemaNode>();
    private GeneratedTypeBuilder moduleNode;
    private JavaTypeName moduleInfoType;
    private String modulePackageName;

    ModuleContext(Module module) {
        this.module = Objects.requireNonNull(module);
    }

    Module module() {
        return this.module;
    }

    @NonNull String modulePackageName() {
        String ret = this.modulePackageName;
        if (ret == null) {
            this.modulePackageName = ret = BindingMapping.getRootPackageName((QNameModule)this.module.getQNameModule());
        }
        return ret;
    }

    @NonNull JavaTypeName moduleInfoType() {
        JavaTypeName ret = this.moduleInfoType;
        if (ret == null) {
            this.moduleInfoType = ret = JavaTypeName.create((String)this.modulePackageName(), (String)"$YangModuleInfoImpl");
        }
        return ret;
    }

    List<Type> getGeneratedTypes() {
        ArrayList<Type> result = new ArrayList<Type>();
        if (this.moduleNode != null) {
            result.add((Type)this.moduleNode.build());
        }
        for (GeneratedTOBuilder generatedTOBuilder : this.genTOs) {
            result.add((Type)generatedTOBuilder.build());
        }
        for (Type type : this.typedefs.values()) {
            if (type == null) continue;
            result.add(type);
        }
        for (GeneratedTypeBuilder generatedTypeBuilder : this.childNodes.values()) {
            result.add((Type)generatedTypeBuilder.build());
        }
        for (GeneratedTypeBuilder generatedTypeBuilder : this.groupings.values()) {
            result.add((Type)generatedTypeBuilder.build());
        }
        for (GeneratedTypeBuilder generatedTypeBuilder : this.cases.values()) {
            result.add((Type)generatedTypeBuilder.build());
        }
        for (GeneratedTypeBuilder generatedTypeBuilder : this.identities.values()) {
            result.add((Type)generatedTypeBuilder.build());
        }
        for (GeneratedTypeBuilder generatedTypeBuilder : this.topLevelNodes) {
            result.add((Type)generatedTypeBuilder.build());
        }
        for (GeneratedTypeBuilder generatedTypeBuilder : this.augmentations) {
            result.add((Type)generatedTypeBuilder.build());
        }
        return result;
    }

    public Multimap<Type, Type> getChoiceToCases() {
        return Multimaps.unmodifiableMultimap(this.choiceToCases);
    }

    public GeneratedTypeBuilder getModuleNode() {
        return this.moduleNode;
    }

    public GeneratedTypeBuilder getChildNode(SchemaPath path) {
        return this.childNodes.get(path);
    }

    public GeneratedTypeBuilder getGrouping(SchemaPath path) {
        return this.groupings.get(path);
    }

    public GeneratedTypeBuilder getCase(SchemaPath path) {
        return this.cases.get(path);
    }

    public void addModuleNode(GeneratedTypeBuilder newModuleNode) {
        this.moduleNode = newModuleNode;
    }

    public void addGeneratedTOBuilder(GeneratedTOBuilder builder) {
        this.genTOs.add(builder);
    }

    @NonNull GeneratedType addAliasType(ModuleContext sourceContext, ContainerLike source, ContainerLike alias) {
        GeneratedTypeBuilder builder = sourceContext.getChildNode(source.getPath());
        Preconditions.checkState((builder != null ? 1 : 0) != 0, (String)"Could not find builder for %s", (Object)source);
        JavaTypeName id = (JavaTypeName)builder.getIdentifier();
        SchemaPath path = alias.getPath();
        JavaTypeName prev = this.aliases.putIfAbsent(path, id);
        Preconditions.checkState((prev == null ? 1 : 0) != 0, (String)"Type aliasing conflict on %s: %s vs %s", (Object)path, (Object)prev, (Object)id);
        return builder.build();
    }

    @Nullable JavaTypeName getAlias(SchemaPath path) {
        return this.aliases.get(path);
    }

    public void addChildNodeType(SchemaNode def, GeneratedTypeBuilder builder) {
        this.checkNamingConflict(def, (JavaTypeName)builder.getIdentifier());
        this.childNodes.put(def.getPath(), builder);
        this.typeToSchema.put((Type)builder, (DocumentedNode.WithStatus)def);
    }

    public void addGroupingType(GroupingDefinition def, GeneratedTypeBuilder builder) {
        this.checkNamingConflict((SchemaNode)def, (JavaTypeName)builder.getIdentifier());
        this.groupings.put(def.getPath(), builder);
    }

    public void addTypedefType(TypeDefinition<?> def, Type type) {
        JavaTypeName name = (JavaTypeName)type.getIdentifier();
        SchemaNode existingDef = (SchemaNode)this.nameMapping.putIfAbsent(name, (SchemaNode)def);
        if (existingDef != null) {
            if (!(existingDef instanceof TypeDefinition)) {
                throw ModuleContext.resolveNamingConfict(existingDef, def, name);
            }
            LOG.debug("GeneratedType conflict between {} and {} on {}", new Object[]{def, existingDef, name});
        }
        this.typedefs.put(def.getPath(), type);
    }

    public void addCaseType(SchemaPath path, GeneratedTypeBuilder builder) {
        this.cases.put(path, builder);
    }

    public void addIdentityType(IdentitySchemaNode def, GeneratedTypeBuilder builder) {
        this.checkNamingConflict((SchemaNode)def, (JavaTypeName)builder.getIdentifier());
        this.identities.put(def.getQName(), builder);
    }

    public void addTopLevelNodeType(GeneratedTypeBuilder builder) {
        this.topLevelNodes.add(builder);
    }

    public void addAugmentType(GeneratedTypeBuilder builder) {
        this.augmentations.add(builder);
    }

    public Map<SchemaPath, Type> getTypedefs() {
        return this.typedefs;
    }

    public Map<SchemaPath, GeneratedTypeBuilder> getChildNodes() {
        return Collections.unmodifiableMap(this.childNodes);
    }

    public Map<SchemaPath, GeneratedTypeBuilder> getGroupings() {
        return Collections.unmodifiableMap(this.groupings);
    }

    public Map<SchemaPath, GeneratedTypeBuilder> getCases() {
        return Collections.unmodifiableMap(this.cases);
    }

    public Map<QName, GeneratedTypeBuilder> getIdentities() {
        return Collections.unmodifiableMap(this.identities);
    }

    public Set<GeneratedTypeBuilder> getTopLevelNodes() {
        return Collections.unmodifiableSet(this.topLevelNodes);
    }

    public List<GeneratedTypeBuilder> getAugmentations() {
        return Collections.unmodifiableList(this.augmentations);
    }

    public BiMap<Type, AugmentationSchemaNode> getTypeToAugmentation() {
        return Maps.unmodifiableBiMap(this.typeToAugmentation);
    }

    public void addTypeToAugmentation(GeneratedTypeBuilder builder, AugmentationSchemaNode schema) {
        this.typeToAugmentation.put((Object)builder, (Object)schema);
        this.typeToSchema.put((Type)builder, (DocumentedNode.WithStatus)schema);
    }

    public void addChoiceToCaseMapping(Type choiceType, Type caseType, CaseSchemaNode schema) {
        this.choiceToCases.put((Object)choiceType, (Object)caseType);
        this.caseTypeToSchema.put((Object)caseType, (Object)schema);
        this.typeToSchema.put(caseType, (DocumentedNode.WithStatus)schema);
    }

    public BiMap<Type, CaseSchemaNode> getCaseTypeToSchemas() {
        return Maps.unmodifiableBiMap(this.caseTypeToSchema);
    }

    public Map<Type, DocumentedNode.WithStatus> getTypeToSchema() {
        return Collections.unmodifiableMap(this.typeToSchema);
    }

    protected void addTypeToSchema(Type type, TypeDefinition<?> typedef) {
        this.typeToSchema.put(type, (DocumentedNode.WithStatus)typedef);
    }

    void addInnerTypedefType(SchemaPath path, Type type) {
        this.innerTypes.put(path, type);
    }

    public Type getInnerType(SchemaPath path) {
        return this.innerTypes.get(path);
    }

    private void checkNamingConflict(SchemaNode def, JavaTypeName name) {
        SchemaNode existingDef = this.nameMapping.putIfAbsent(name, def);
        if (existingDef != null) {
            if (def.equals(existingDef)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Duplicate definition on {} as {}", new Object[]{name, def, new Throwable()});
                }
            } else {
                throw ModuleContext.resolveNamingConfict(existingDef, def, name);
            }
        }
    }

    private static IllegalStateException resolveNamingConfict(SchemaNode existing, SchemaNode incoming, JavaTypeName name) {
        if (existing instanceof IdentitySchemaNode) {
            if (incoming instanceof GroupingDefinition || incoming instanceof TypeDefinition || incoming instanceof DataSchemaNode || incoming instanceof NotificationDefinition || incoming instanceof OperationDefinition) {
                return new RenameMappingException(name, existing);
            }
        } else if (existing instanceof GroupingDefinition) {
            if (incoming instanceof IdentitySchemaNode) {
                return new RenameMappingException(name, incoming);
            }
            if (incoming instanceof TypeDefinition || incoming instanceof DataSchemaNode || incoming instanceof NotificationDefinition || incoming instanceof OperationDefinition) {
                return new RenameMappingException(name, existing);
            }
        } else if (existing instanceof TypeDefinition) {
            if (incoming instanceof GroupingDefinition || incoming instanceof IdentitySchemaNode) {
                return new RenameMappingException(name, incoming);
            }
            if (incoming instanceof DataSchemaNode || incoming instanceof NotificationDefinition || incoming instanceof OperationDefinition) {
                return new RenameMappingException(name, existing);
            }
        } else if (incoming instanceof GroupingDefinition || incoming instanceof IdentitySchemaNode || incoming instanceof TypeDefinition) {
            return new RenameMappingException(name, incoming);
        }
        return new IllegalStateException(String.format("Unhandled GeneratedType conflict between %s and %s on %s", incoming, existing, name));
    }
}

