/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.yang.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.opendaylight.mdsal.binding.yang.types.NodeWrappedType;
import org.opendaylight.yangtools.util.TopologicalSort;
import org.opendaylight.yangtools.yang.model.api.ActionDefinition;
import org.opendaylight.yangtools.yang.model.api.ActionNodeContainer;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchemaNode;
import org.opendaylight.yangtools.yang.model.api.CaseSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.GroupingDefinition;
import org.opendaylight.yangtools.yang.model.api.NotificationDefinition;
import org.opendaylight.yangtools.yang.model.api.NotificationNodeContainer;
import org.opendaylight.yangtools.yang.model.api.UsesNode;

public class GroupingDefinitionDependencySort {
    public List<GroupingDefinition> sort(Collection<? extends GroupingDefinition> groupingDefinitions) {
        if (groupingDefinitions == null) {
            throw new IllegalArgumentException("Set of Type Definitions cannot be NULL!");
        }
        List sortedNodes = TopologicalSort.sort(this.groupingDefinitionsToNodes(groupingDefinitions));
        ArrayList<GroupingDefinition> resultGroupingDefinitions = new ArrayList<GroupingDefinition>(sortedNodes.size());
        for (TopologicalSort.Node node : sortedNodes) {
            NodeWrappedType nodeWrappedType = (NodeWrappedType)node;
            resultGroupingDefinitions.add((GroupingDefinition)nodeWrappedType.getWrappedType());
        }
        return resultGroupingDefinitions;
    }

    private Set<TopologicalSort.Node> groupingDefinitionsToNodes(Collection<? extends GroupingDefinition> groupingDefinitions) {
        HashMap<GroupingDefinition, NodeWrappedType> nodeMap = new HashMap<GroupingDefinition, NodeWrappedType>();
        HashSet<TopologicalSort.Node> resultNodes = new HashSet<TopologicalSort.Node>();
        for (GroupingDefinition groupingDefinition : groupingDefinitions) {
            NodeWrappedType node = new NodeWrappedType(groupingDefinition);
            nodeMap.put(groupingDefinition, node);
            resultNodes.add((TopologicalSort.Node)node);
        }
        for (TopologicalSort.Node node : resultNodes) {
            NodeWrappedType nodeWrappedType = (NodeWrappedType)node;
            GroupingDefinition groupingDefinition = (GroupingDefinition)nodeWrappedType.getWrappedType();
            Set<UsesNode> usesNodes = this.getAllUsesNodes((DataNodeContainer)groupingDefinition);
            for (UsesNode usesNode : usesNodes) {
                TopologicalSort.Node nodeTo = (TopologicalSort.Node)nodeMap.get(usesNode.getSourceGrouping());
                if (nodeTo == null) continue;
                nodeWrappedType.addEdge(nodeTo);
            }
        }
        return resultNodes;
    }

    private Set<UsesNode> getAllUsesNodes(DataNodeContainer container) {
        HashSet<UsesNode> ret = new HashSet<UsesNode>();
        Collection usesNodes = container.getUses();
        ret.addAll(usesNodes);
        for (UsesNode usesNode : usesNodes) {
            for (AugmentationSchemaNode augment : usesNode.getAugmentations()) {
                ret.addAll(this.getAllUsesNodes((DataNodeContainer)augment));
            }
        }
        for (GroupingDefinition groupingDefinition : container.getGroupings()) {
            ret.addAll(this.getAllUsesNodes((DataNodeContainer)groupingDefinition));
        }
        for (DataSchemaNode childNode : container.getChildNodes()) {
            if (childNode instanceof DataNodeContainer) {
                ret.addAll(this.getAllUsesNodes((DataNodeContainer)childNode));
                continue;
            }
            if (!(childNode instanceof ChoiceSchemaNode)) continue;
            for (CaseSchemaNode choiceCaseNode : ((ChoiceSchemaNode)childNode).getCases()) {
                ret.addAll(this.getAllUsesNodes((DataNodeContainer)choiceCaseNode));
            }
        }
        if (container instanceof ActionNodeContainer) {
            for (ActionDefinition action : ((ActionNodeContainer)container).getActions()) {
                ret.addAll(this.getAllUsesNodes((DataNodeContainer)action.getInput()));
                ret.addAll(this.getAllUsesNodes((DataNodeContainer)action.getOutput()));
            }
        }
        if (container instanceof NotificationNodeContainer) {
            for (NotificationDefinition notification : ((NotificationNodeContainer)container).getNotifications()) {
                ret.addAll(this.getAllUsesNodes((DataNodeContainer)notification));
            }
        }
        return ret;
    }
}

