/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.mdsal.core.general.entity.rev150930;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.mdsal.core.general.entity.rev150930.Entity;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.mdsal.core.general.entity.rev150930.EntityKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class EntityBuilder
implements Builder<Entity> {
    private String _name;
    private EntityKey key;
    Map<Class<? extends Augmentation<Entity>>, Augmentation<Entity>> augmentation = Collections.emptyMap();

    public EntityBuilder() {
    }

    public EntityBuilder(Entity base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Entity>>, Augmentation<Entity>>(aug);
        }
        this.key = base.key();
        this._name = base.getName();
    }

    public EntityKey key() {
        return this.key;
    }

    public String getName() {
        return this._name;
    }

    public <E$$ extends Augmentation<Entity>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public EntityBuilder withKey(EntityKey key) {
        this.key = key;
        return this;
    }

    public EntityBuilder setName(String value) {
        this._name = value;
        return this;
    }

    public EntityBuilder addAugmentation(Augmentation<Entity> augmentation) {
        Class augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Entity>>, Augmentation<Entity>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public EntityBuilder removeAugmentation(Class<? extends Augmentation<Entity>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Entity build() {
        return new EntityImpl(this);
    }

    private static final class EntityImpl
    extends AbstractAugmentable<Entity>
    implements Entity {
        private final String _name;
        private final EntityKey key;
        private int hash = 0;
        private volatile boolean hashValid = false;

        EntityImpl(EntityBuilder base) {
            super(base.augmentation);
            this.key = base.key() != null ? base.key() : new EntityKey(base.getName());
            this._name = this.key.getName();
        }

        @Override
        public EntityKey key() {
            return this.key;
        }

        @Override
        public String getName() {
            return this._name;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Entity.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return Entity.bindingEquals(this, obj);
        }

        public String toString() {
            return Entity.bindingToString(this);
        }
    }
}

